/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.net.URISyntaxException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalDispatcher {
    private static InternalDispatcher instance = new InternalDispatcher();

    public static InternalDispatcher getInstance() {
        return instance;
    }

    public static void setInstance(InternalDispatcher instance) {
        InternalDispatcher.instance = instance;
    }

    public Object getEntity(String uri) {
        return this.getResponse(uri).getEntity();
    }

    public Response delete(String uri) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "DELETE"));
    }

    public Response putEntity(String uri, Object entity) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "PUT"), entity);
    }

    public Response postEntity(String uri, Object entity) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "POST"), entity);
    }

    public Response getResponse(String uri) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "GET"));
    }

    public Response getResponse(MockHttpRequest request) {
        return this.getResponse(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponse(MockHttpRequest request, Object entity) {
        Dispatcher dispatcher;
        block3: {
            dispatcher = ResteasyProviderFactory.getContextData(Dispatcher.class);
            if (dispatcher != null) break block3;
            Response response = null;
            return response;
        }
        this.enhanceRequest(request);
        Response response = dispatcher.internalInvocation(request, new MockHttpResponse(), entity);
        return response;
    }

    protected void enhanceRequest(MockHttpRequest request) {
        HttpRequest previousRequest = ResteasyProviderFactory.getContextData(HttpRequest.class);
        if (previousRequest != null) {
            this.getHeaders(request).putAll(this.getHeaders(previousRequest));
        }
    }

    private MultivaluedMap<String, String> getHeaders(HttpRequest request) {
        return request.getHttpHeaders().getRequestHeaders();
    }

    public static MockHttpRequest createRequest(String uri, String verb) {
        try {
            return MockHttpRequest.create(verb, uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("could not create uri for internal dispatching", e);
        }
    }
}

