/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jboss.shrinkwrap.resolver.impl.maven.aether.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathWorkspaceReader
implements WorkspaceReader {
    private static final Logger log = Logger.getLogger(ClasspathWorkspaceReader.class.getName());
    private static final String CLASS_PATH_KEY = "java.class.path";
    private static final String SUREFIRE_CLASS_PATH_KEY = "surefire.test.class.path";
    private final Set<String> classPathEntries;

    public ClasspathWorkspaceReader() {
        String classPath = SecurityActions.getProperty(CLASS_PATH_KEY);
        String surefireClassPath = SecurityActions.getProperty(SUREFIRE_CLASS_PATH_KEY);
        this.classPathEntries = new LinkedHashSet<String>();
        this.classPathEntries.addAll(this.getClassPathEntries(surefireClassPath));
        this.classPathEntries.addAll(this.getClassPathEntries(classPath));
    }

    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository("classpath");
    }

    public File findArtifact(Artifact artifact) {
        for (String classpathEntry : this.classPathEntries) {
            File pomFile;
            File file = new File(classpathEntry);
            if (file.isDirectory()) {
                File pomFile2 = new File(file.getParentFile().getParentFile(), "pom.xml");
                if (!pomFile2.isFile()) continue;
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Processing " + pomFile2.getAbsolutePath() + " for classpath artifact resolution");
                    }
                    Document pom = this.loadPom(pomFile2);
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xpath = factory.newXPath();
                    String groupId = xpath.evaluate("/project/groupId", pom);
                    String artifactId = xpath.evaluate("/project/artifactId", pom);
                    String type = xpath.evaluate("/project/packaging", pom);
                    String version = xpath.evaluate("/project/version", pom);
                    if (groupId == null || groupId.equals("")) {
                        groupId = xpath.evaluate("/project/parent/groupId", pom);
                    }
                    if (type == null || type.equals("")) {
                        type = "jar";
                    }
                    if (version == null || version.equals("")) {
                        version = xpath.evaluate("/project/parent/version", pom);
                    }
                    DefaultArtifact foundArtifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + type + ":" + version);
                    foundArtifact.setFile(pomFile2);
                    if (!foundArtifact.getGroupId().equals(artifact.getGroupId()) || !foundArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
                    return pomFile2;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not parse pom.xml: " + pomFile2, e);
                }
            }
            if (!file.isFile()) continue;
            StringBuilder name = new StringBuilder().append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
            if (!file.getAbsolutePath().contains(name.toString())) continue;
            if ("pom".equals(artifact.getExtension()) && (pomFile = new File(file.getParentFile().getParentFile(), "pom.xml")).isFile()) {
                return pomFile;
            }
            if (!Validate.isNullOrEmpty(artifact.getClassifier())) {
                name.append("-").append(artifact.getClassifier());
            }
            name.append(".").append(artifact.getExtension());
            if (!file.getAbsolutePath().endsWith(name.toString())) continue;
            return file;
        }
        return null;
    }

    private Document loadPom(File pom) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(pom);
    }

    public List<String> findVersions(Artifact artifact) {
        return new ArrayList<String>();
    }

    private Set<String> getClassPathEntries(String classPath) {
        if (classPath == null || classPath.length() < 1) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(classPath.split(String.valueOf(File.pathSeparatorChar))));
    }
}

