/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.AbstractWeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.AbstractBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public class DefaultBeanArchiveScanner
extends AbstractBeanArchiveScanner {
    private static final Logger logger = Logger.getLogger(DefaultBeanArchiveScanner.class);
    protected final ResourceLoader resourceLoader;

    public DefaultBeanArchiveScanner(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        super(bootstrap);
        this.resourceLoader = resourceLoader;
    }

    @Override
    public List<BeanArchiveScanner.ScanResult> scan() {
        String[] resources;
        ImmutableList.Builder results = ImmutableList.builder();
        for (String resourceName : resources = AbstractWeldDeployment.RESOURCES) {
            for (URL beansXmlUrl : this.resourceLoader.getResources(resourceName)) {
                BeansXml beansXml = this.parseBeansXml(beansXmlUrl);
                if (!this.accept(beansXml)) continue;
                results.add((Object)new BeanArchiveScanner.ScanResult(beansXml, this.getBeanArchiveReference(beansXmlUrl)));
            }
        }
        return results.build();
    }

    protected String getBeanArchiveReference(URL url) {
        String ref = null;
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            CommonLogger.LOG.couldNotReadResource(url, e);
        }
        if ("file".equals(url.getProtocol())) {
            ref = new File(uri.getSchemeSpecificPart()).getParentFile().getParent();
        } else if ("jar".equals(url.getProtocol())) {
            ref = uri.getSchemeSpecificPart();
            if (ref.lastIndexOf("!/") > 0) {
                ref = ref.substring(0, ref.lastIndexOf("!/"));
            }
            ref = this.getBeanArchiveReferenceForJar(ref, url);
        } else {
            logger.warnv("Unable to adapt URL: {0}, using its external form instead", (Object)url);
            ref = url.toExternalForm();
        }
        logger.debugv("Resolved bean archive reference: {0} for URL: {1}", (Object)ref, (Object)url);
        return ref;
    }

    protected String getBeanArchiveReferenceForJar(String path, URL fallback) {
        if (path.startsWith("file:")) {
            return path.substring("file:".length());
        }
        if (path.startsWith("war:")) {
            return path;
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            ClassLoader jnlpClassLoader = WeldResourceLoader.getClassLoader();
            Class<?> jnlpClClass = jnlpClassLoader.getClass();
            try {
                if (jnlpClClass.getName().equals("net.sourceforge.jnlp.runtime.JNLPClassLoader")) {
                    Field f = jnlpClassLoader.getClass().getDeclaredField("tracker");
                    f.setAccessible(true);
                    Object tracker = f.get(jnlpClassLoader);
                    Method m = tracker.getClass().getMethod("getCacheFile", URL.class);
                    File jarFile = (File)m.invoke(tracker, new URL(path));
                    return jarFile.getPath();
                }
                Method m = jnlpClClass.getMethod("getJarFile", URL.class);
                ZipFile jarFile = (ZipFile)m.invoke((Object)jnlpClassLoader, new URL(path));
                return jarFile.getName();
            }
            catch (NoSuchFieldException nsfe) {
                CommonLogger.LOG.unexpectedClassLoader(nsfe);
            }
            catch (NoSuchMethodException nsme) {
                CommonLogger.LOG.unexpectedClassLoader(nsme);
            }
            catch (IllegalArgumentException iarge) {
                CommonLogger.LOG.unexpectedClassLoader(iarge);
            }
            catch (InvocationTargetException ite) {
                CommonLogger.LOG.jnlpClassLoaderInternalException(ite);
            }
            catch (Exception iacce) {
                CommonLogger.LOG.jnlpClassLoaderInvocationException(iacce);
            }
        }
        logger.warnv("Unable to adapt JAR file URL: {0}, using its external form instead", (Object)path);
        return fallback.toExternalForm();
    }
}

