/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.UnsupportedVersion;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.util.Preconditions;

public class JandexIndexBeanArchiveHandler
implements BeanArchiveHandler {
    private static final String JANDEX_INDEX_NAME = "META-INF/jandex.idx";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String SEPARATOR = "!/";
    private Index indexCache = null;
    private String indexCacheUrlPath = null;

    public boolean canHandle(String urlPath) {
        return this.getIndex(urlPath) != null;
    }

    @Override
    public BeanArchiveBuilder handle(String urlPath) {
        Index index = this.getIndex(urlPath);
        if (index == null) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder().setAttribute(JandexDiscoveryStrategy.INDEX_ATTRIBUTE_NAME, index);
        this.handleArchiveByIndex(index, builder);
        return builder;
    }

    private Index getIndex(String urlPath) {
        Preconditions.checkArgumentNotNull(urlPath, "urlPath");
        if (this.indexCacheUrlPath == null || !this.indexCacheUrlPath.equals(urlPath)) {
            Index newIndex;
            this.indexCache = newIndex = this.loadJandexIndex(urlPath);
            this.indexCacheUrlPath = urlPath;
        }
        return this.indexCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index loadJandexIndex(String urlPath) {
        URL indexURL = null;
        Index index = null;
        String indexUrlString = this.getJandexIndexURLString(urlPath);
        try {
            indexURL = new URL(indexUrlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
        InputStream indexFileStream = null;
        try {
            indexFileStream = indexURL.openStream();
            CommonLogger.LOG.foundJandexIndex(indexURL);
            IndexReader indexFileReader = new IndexReader(indexFileStream);
            index = indexFileReader.read();
        }
        catch (IllegalArgumentException e) {
            CommonLogger.LOG.warnv("Jandex index at {} is not valid", (Object)indexUrlString);
        }
        catch (UnsupportedVersion e) {
            CommonLogger.LOG.warnv("Version of Jandex index at {} is not supported", (Object)indexUrlString);
        }
        catch (FileNotFoundException ignore) {
            CommonLogger.LOG.tracev("No Jandex index found at {}", (Object)indexUrlString);
        }
        catch (IOException ioe) {
            CommonLogger.LOG.warnv("Cannot load Jandex index at {}", (Object)indexUrlString);
            CommonLogger.LOG.catchingDebug(ioe);
        }
        finally {
            if (indexFileStream != null) {
                try {
                    indexFileStream.close();
                }
                catch (IOException ioe) {
                    CommonLogger.LOG.couldNotCloseStreamOfJandexIndex(urlPath, ioe);
                }
            }
        }
        return index;
    }

    private String getJandexIndexURLString(String urlPath) {
        String indexUrlString = FILE_URL_PREFIX + urlPath + SEPARATOR + JANDEX_INDEX_NAME;
        if (urlPath.toLowerCase().endsWith(".jar")) {
            indexUrlString = JAR_URL_PREFIX + indexUrlString;
        }
        return indexUrlString;
    }

    private void handleArchiveByIndex(Index index, BeanArchiveBuilder builder) {
        for (ClassInfo classInfo : index.getKnownClasses()) {
            builder.addClass(classInfo.name().toString());
        }
    }
}

