/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.classloading;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public abstract class ClassLoaderProvider {
    private static final RuntimePermission SET_DEFAULT_CLASSLOADER_PROVIDER = new RuntimePermission("org.jboss.wsf.spi.SET_DEFAULT_CLASSLOADER_PROVIDER");
    private static ClassLoaderProvider provider = new ClassLoaderProvider(){

        @Override
        public ClassLoader getWebServiceSubsystemClassLoader() {
            return 1.getContextClassLoader();
        }

        @Override
        public ClassLoader getServerIntegrationClassLoader() {
            return 1.getContextClassLoader();
        }

        @Override
        public ClassLoader getServerJAXRPCIntegrationClassLoader() {
            return 1.getContextClassLoader();
        }
    };
    private static volatile boolean set = false;

    public static void setDefaultProvider(ClassLoaderProvider p) {
        ClassLoaderProvider.checkPermission(SET_DEFAULT_CLASSLOADER_PROVIDER);
        provider = p;
        set = true;
    }

    public static ClassLoaderProvider getDefaultProvider() {
        return provider;
    }

    public static boolean isSet() {
        return set;
    }

    public abstract ClassLoader getWebServiceSubsystemClassLoader();

    public abstract ClassLoader getServerIntegrationClassLoader();

    public abstract ClassLoader getServerJAXRPCIntegrationClassLoader();

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

