/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

public final class JvmAbi {
    public static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    public static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    public static final String DEFAULT_IMPLS_DELEGATE_SUFFIX = "$defaultImpl";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String DELEGATED_PROPERTIES_ARRAY_NAME = "$$delegatedProperties";
    public static final String DELEGATE_SUPER_FIELD_PREFIX = "$$delegate_";
    public static final String INSTANCE_FIELD = "INSTANCE";
    public static final String DEFAULT_MODULE_NAME = "main";
    public static final ClassId REFLECTION_FACTORY_IMPL = ClassId.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT = "$i$a$";
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION = "$i$f$";

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedProperty(@NotNull Name propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        String string = propertyName.asString() + "$annotations";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        return string;
    }

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedTypeAlias(@NotNull Name typeAliasName) {
        if (typeAliasName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAliasName", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedTypeAlias"));
        }
        String string = typeAliasName.asString() + "$annotations";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedTypeAlias"));
        }
        return string;
    }

    public static boolean isGetterName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/JvmAbi", "isGetterName"));
        }
        return name2.startsWith("get") || name2.startsWith("is");
    }

    public static boolean isSetterName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/JvmAbi", "isSetterName"));
        }
        return name2.startsWith("set");
    }

    @NotNull
    public static String getterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "getterName"));
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : "get" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "getterName"));
        }
        return string;
    }

    @NotNull
    public static String setterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "setterName"));
        }
        String string = "set" + (JvmAbi.startsWithIsPrefix(propertyName) ? propertyName.substring("is".length()) : CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "setterName"));
        }
        return string;
    }

    public static boolean startsWithIsPrefix(String name2) {
        if (!name2.startsWith("is")) {
            return false;
        }
        if (name2.length() == "is".length()) {
            return false;
        }
        char c = name2.charAt("is".length());
        return 'a' > c || c > 'z';
    }

    public static boolean isPropertyWithBackingFieldInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/load/java/JvmAbi", "isPropertyWithBackingFieldInOuterClass"));
        }
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && JvmAbi.isCompanionObjectWithBackingFieldsInOuter(propertyDescriptor.getContainingDeclaration());
    }

    public static boolean isCompanionObjectWithBackingFieldsInOuter(@NotNull DeclarationDescriptor companionObject) {
        if (companionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "companionObject", "org/jetbrains/kotlin/load/java/JvmAbi", "isCompanionObjectWithBackingFieldsInOuter"));
        }
        return DescriptorUtils.isCompanionObject(companionObject) && DescriptorUtils.isClassOrEnumClass(companionObject.getContainingDeclaration()) && !CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject((ClassDescriptor)companionObject);
    }
}

