/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.comparators.FirCallableDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "()V", "compare", "", "a", "b", "TypeAndNameComparator", "tree"})
public final class FirMemberDeclarationComparator
implements Comparator<FirMemberDeclaration> {
    @NotNull
    public static final FirMemberDeclarationComparator INSTANCE = new FirMemberDeclarationComparator();

    private FirMemberDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a instanceof FirCallableDeclaration && b instanceof FirCallableDeclaration) {
            return FirCallableDeclarationComparator.INSTANCE.compare((FirCallableDeclaration)a, (FirCallableDeclaration)b);
        }
        int typeAndNameDiff = TypeAndNameComparator.INSTANCE.compare(a, b);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        FirMemberDeclaration firMemberDeclaration = a;
        if (firMemberDeclaration instanceof FirClass) {
            boolean bl = b instanceof FirClass;
            if (!bl) {
                boolean $i$a$-require-FirMemberDeclarationComparator$compare$32 = false;
                String $i$a$-require-FirMemberDeclarationComparator$compare$32 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw new IllegalArgumentException($i$a$-require-FirMemberDeclarationComparator$compare$32.toString());
            }
            String string2 = FirDeclarationUtilKt.getClassId((FirClass)((Object)a)).getPackageFqName().asString();
            String string3 = FirDeclarationUtilKt.getClassId((FirClass)((Object)b)).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"b.classId.packageFqName.asString()");
            return string2.compareTo(string3);
        }
        if (firMemberDeclaration instanceof FirTypeAlias) {
            boolean bl = b instanceof FirTypeAlias;
            if (!bl) {
                boolean bl2 = false;
                String string4 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw new IllegalArgumentException(string4.toString());
            }
            return FirTypeRefComparator.INSTANCE.compare(((FirTypeAlias)a).getExpandedTypeRef(), ((FirTypeAlias)b).getExpandedTypeRef());
        }
        throw new IllegalStateException(("Unsupported member declaration comparison: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null)).toString());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator$TypeAndNameComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "()V", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Lorg/jetbrains/kotlin/name/Name;", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)I", "compare", "a", "b", "tree"})
    public static final class TypeAndNameComparator
    implements Comparator<FirMemberDeclaration> {
        @NotNull
        public static final TypeAndNameComparator INSTANCE = new TypeAndNameComparator();

        private TypeAndNameComparator() {
        }

        private final int getPriority(FirMemberDeclaration $this$priority) {
            int n;
            FirMemberDeclaration firMemberDeclaration = $this$priority;
            if (firMemberDeclaration instanceof FirEnumEntry) {
                n = 7;
            } else if (firMemberDeclaration instanceof FirConstructor) {
                n = 6;
            } else if (firMemberDeclaration instanceof FirProperty) {
                n = 5;
            } else if (firMemberDeclaration instanceof FirField) {
                n = 4;
            } else if (firMemberDeclaration instanceof FirFunction) {
                n = 3;
            } else if (firMemberDeclaration instanceof FirClass) {
                n = 2;
            } else if (firMemberDeclaration instanceof FirTypeAlias) {
                n = 1;
            } else if (firMemberDeclaration instanceof FirErrorProperty) {
                n = 0;
            } else if (firMemberDeclaration instanceof FirValueParameter) {
                n = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        private final Name getName(FirMemberDeclaration $this$name) {
            Name name;
            FirMemberDeclaration firMemberDeclaration = $this$name;
            if (firMemberDeclaration instanceof FirCallableDeclaration) {
                name = ((FirCallableDeclaration)$this$name).getSymbol().getCallableId().getCallableName();
            } else if (firMemberDeclaration instanceof FirClass) {
                Name name2 = FirDeclarationUtilKt.getClassId((FirClass)((Object)$this$name)).getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"this.classId.shortClassName");
                name = name2;
            } else if (firMemberDeclaration instanceof FirTypeAlias) {
                name = ((FirTypeAlias)$this$name).getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return name;
        }

        @Override
        public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int priorityDiff = this.getPriority(a) - this.getPriority(b);
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            if (a instanceof FirEnumEntry) {
                boolean bl = b instanceof FirEnumEntry;
                if (!bl) {
                    boolean bl2 = false;
                    String string2 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                    throw new IllegalArgumentException(string2.toString());
                }
                return 0;
            }
            return this.getName(a).compareTo(this.getName(b));
        }
    }
}

