/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance(PsiParameterImpl.class);
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub2) {
        if (stub2 == null) {
            PsiParameterImpl.$$$reportNull$$$0(0);
        }
        this(stub2, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub2, @NotNull IStubElementType type2) {
        if (stub2 == null) {
            PsiParameterImpl.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            PsiParameterImpl.$$$reportNull$$$0(2);
        }
        super(stub2, type2);
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiParameterImpl.$$$reportNull$$$0(3);
        }
        super(node);
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType functionalInterfaceType = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(param, false, () -> LambdaUtil.getFunctionalInterfaceType(lambdaExpression, true));
            PsiType type2 = lambdaExpression.getGroundTargetType(functionalInterfaceType);
            if (type2 instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type2).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(conjunct, parameterIndex);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(type2, parameterIndex);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)super.clone();
        clone.myCachedType = null;
        return clone;
    }

    @Override
    @NotNull
    public final String getName() {
        PsiParameterStub stub2 = (PsiParameterStub)this.getGreenStub();
        if (stub2 != null) {
            String string2 = stub2.getName();
            if (string2 == null) {
                PsiParameterImpl.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String string3 = this.getNameIdentifier().getText();
        if (string3 == null) {
            PsiParameterImpl.$$$reportNull$$$0(5);
        }
        return string3;
    }

    @Override
    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiParameterImpl.$$$reportNull$$$0(6);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = PsiTreeUtil.getRequiredChildOfType(this, PsiIdentifier.class);
        if (psiIdentifier == null) {
            PsiParameterImpl.$$$reportNull$$$0(7);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiParameterImpl.$$$reportNull$$$0(8);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiParameterStub stub2 = (PsiParameterStub)this.getStub();
        if (stub2 != null) {
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                type2 = JavaSharedImplUtil.createTypeFromStub(this, stub2.getType(false));
                this.myCachedType = new SoftReference<PsiType>(type2);
            }
            PsiType psiType2 = type2;
            if (psiType2 == null) {
                PsiParameterImpl.$$$reportNull$$$0(9);
            }
            return psiType2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null || this.isLambdaParameter() && typeElement.isInferredType()) {
            assert (this.isLambdaParameter()) : this;
            PsiType psiType3 = PsiParameterImpl.getLambdaParameterType(this);
            if (psiType3 == null) {
                PsiParameterImpl.$$$reportNull$$$0(10);
            }
            return psiType3;
        }
        PsiType psiType4 = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType4 == null) {
            PsiParameterImpl.$$$reportNull$$$0(11);
        }
        return psiType4;
    }

    private boolean isLambdaParameter() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiParameterList && parent2.getParent() instanceof PsiLambdaExpression;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList2 = this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList2 != null) : this;
        PsiModifierList psiModifierList = modifierList2;
        if (psiModifierList == null) {
            PsiParameterImpl.$$$reportNull$$$0(12);
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiParameterImpl.$$$reportNull$$$0(13);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiParameterImpl.$$$reportNull$$$0(14);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent2 = this.getParent();
        if (parent2 == null) {
            PsiParameterImpl psiParameterImpl = this;
            if (psiParameterImpl == null) {
                PsiParameterImpl.$$$reportNull$$$0(15);
            }
            return psiParameterImpl;
        }
        if (parent2 instanceof PsiParameterList) {
            PsiElement psiElement = parent2.getParent();
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(16);
            }
            return psiElement;
        }
        if (parent2 instanceof PsiForeachStatement) {
            PsiElement psiElement = parent2;
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        if (parent2 instanceof PsiCatchSection) {
            PsiElement psiElement = parent2;
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement[] children2 = parent2.getChildren();
        if (children2 != null) {
            for (int i = 0; i < children2.length; ++i) {
                if (!children2[i].equals(this)) continue;
                for (int j = i + 1; j < children2.length; ++j) {
                    if (!(children2[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children2[j];
                    if (psiElement == null) {
                        PsiParameterImpl.$$$reportNull$$$0(19);
                    }
                    return psiElement;
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + this + ") parent' (" + parent2 + ") children: " + Arrays.asList(children2));
        if (null == null) {
            PsiParameterImpl.$$$reportNull$$$0(20);
        }
        return null;
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterStub stub2 = (PsiParameterStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull(typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        return new LocalSearchScope(declarationScope);
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index2;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiParameterList && (gParent = parent2.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && originalMethod != gParent && (index2 = ((PsiParameterList)parent2).getParameterIndex(this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index2];
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiParameterImpl";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiParameterImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

