/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.annotation.AnnotationFileUpdater;
import org.jetbrains.kotlin.annotation.AnnotationWriter;
import org.jetbrains.kotlin.annotation.CompactAnnotationWriter;
import org.jetbrains.kotlin.annotation.MutableKotlinAnnotationProvider;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/annotation/AnnotationFileUpdaterImpl;", "Lorg/jetbrains/kotlin/annotation/AnnotationFileUpdater;", "generatedAnnotationFile", "Ljava/io/File;", "(Ljava/io/File;)V", "lastSuccessfullyUpdatedFile", "kotlin.jvm.PlatformType", "logger", "Lorg/gradle/api/logging/Logger;", "revert", "", "updateAnnotations", "outdatedClasses", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-gradle-plugin"})
public final class AnnotationFileUpdaterImpl
implements AnnotationFileUpdater {
    private final Logger logger;
    private final File lastSuccessfullyUpdatedFile;
    private final File generatedAnnotationFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updateAnnotations(@NotNull Iterable<? extends JvmClassName> outdatedClasses) {
        Object object;
        Object object2;
        Logger it;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(outdatedClasses, (String)"outdatedClasses");
        Iterable<? extends JvmClassName> iterable = outdatedClasses;
        Collection destination$iv = new HashSet();
        for (Object item$iv : $receiver$iv) {
            String string;
            JvmClassName jvmClassName = (JvmClassName)item$iv;
            Collection collection = destination$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getFqNameForClassNameWithoutDollars().asString(), (String)"it.fqNameForClassNameWithoutDollars.asString()");
            collection.add(string);
        }
        HashSet outdatedClassesFqNames = (HashSet)destination$iv;
        MutableKotlinAnnotationProvider $receiver = object2 = new MutableKotlinAnnotationProvider();
        File file = this.lastSuccessfullyUpdatedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lastSuccessfullyUpdatedFile");
        $receiver.addAnnotationsFrom(file);
        $receiver.removeClasses((Set)outdatedClassesFqNames);
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Logger $receiver$iv2 = logger;
        if ($receiver$iv2.isDebugEnabled()) {
            it = $receiver$iv2;
            object = "Removed annotation entries for fq-names [" + CollectionsKt.joinToString$default((Iterable)outdatedClassesFqNames, null, null, null, (int)0, null, null, (int)63, null) + ']';
            GradleUtilsKt.kotlinDebug(it, (String)object);
        }
        if (this.generatedAnnotationFile.exists()) {
            $receiver.addAnnotationsFrom(this.generatedAnnotationFile);
            Logger logger2 = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
            $receiver$iv2 = logger2;
            if ($receiver$iv2.isDebugEnabled()) {
                it = $receiver$iv2;
                object = "Added annotation entries from " + this.generatedAnnotationFile;
                GradleUtilsKt.kotlinDebug(it, (String)object);
            }
        }
        MutableKotlinAnnotationProvider annotationsProvider = object2;
        this.generatedAnnotationFile.delete();
        object2 = this.generatedAnnotationFile;
        Object object3 = Charsets.UTF_8;
        int $receiver$iv22 = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, $receiver$iv22);
        object3 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            annotationsProvider.writeAnnotations((AnnotationWriter)new CompactAnnotationWriter((Writer)writer));
            Logger logger3 = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
            Logger $receiver$iv3 = logger3;
            if ($receiver$iv3.isDebugEnabled()) {
                object = $receiver$iv3;
                object4 = "Written updated annotations to " + this.generatedAnnotationFile;
                GradleUtilsKt.kotlinDebug((Logger)object, (String)object4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        File file2 = this.lastSuccessfullyUpdatedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"lastSuccessfullyUpdatedFile");
        FilesKt.copyTo$default((File)this.generatedAnnotationFile, (File)file2, (boolean)true, (int)0, (int)4, null);
    }

    public void revert() {
        File file = this.lastSuccessfullyUpdatedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lastSuccessfullyUpdatedFile");
        FilesKt.copyTo$default((File)file, (File)this.generatedAnnotationFile, (boolean)true, (int)0, (int)4, null);
    }

    public AnnotationFileUpdaterImpl(@NotNull File generatedAnnotationFile) {
        Intrinsics.checkParameterIsNotNull((Object)generatedAnnotationFile, (String)"generatedAnnotationFile");
        this.generatedAnnotationFile = generatedAnnotationFile;
        this.logger = Logging.getLogger(this.getClass());
        this.lastSuccessfullyUpdatedFile = File.createTempFile("kapt-annotations-copy", "tmp");
        if (this.generatedAnnotationFile.exists()) {
            File file = this.lastSuccessfullyUpdatedFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lastSuccessfullyUpdatedFile");
            FilesKt.copyTo$default((File)this.generatedAnnotationFile, (File)file, (boolean)true, (int)0, (int)4, null);
        } else {
            File file = this.lastSuccessfullyUpdatedFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lastSuccessfullyUpdatedFile");
            FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        }
    }
}

