/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.compress;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class VLQUtil {
    private VLQUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static void writeLong(long l, @NotNull OutputStream outputStream) throws IOException {
        int b;
        if (outputStream == null) {
            VLQUtil.$$$reportNull$$$0(0);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        byte[] stack = new byte[10];
        int bytes = 0;
        do {
            b = (int)(l & 0x7FL);
            stack[bytes++] = b;
        } while ((l >>= 7) > 0L);
        while (--bytes >= 0) {
            void output;
            b = stack[bytes] & 0xFF;
            if (bytes > 0) {
                b |= 0x80;
            }
            output.write(b);
        }
    }

    public static void writeInt(int i, @NotNull OutputStream output) throws IOException {
        int b;
        if (output == null) {
            VLQUtil.$$$reportNull$$$0(1);
        }
        if (i < 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        byte[] stack = new byte[5];
        int bytes = 0;
        do {
            b = i & 0x7F;
            stack[bytes++] = b;
        } while ((i >>= 7) > 0);
        while (--bytes >= 0) {
            b = stack[bytes] & 0xFF;
            if (bytes > 0) {
                b |= 0x80;
            }
            output.write(b);
        }
    }

    public static long readLong(@NotNull InputStream input) throws IOException {
        int b;
        if (input == null) {
            VLQUtil.$$$reportNull$$$0(2);
        }
        long result = 0L;
        do {
            if ((b = input.read()) == -1) {
                throw new EOFException();
            }
            result = (result << 7) + (long)(b & 0x7F);
        } while ((b & 0x80) != 0);
        return result;
    }

    public static int readInt(@NotNull InputStream input) throws IOException {
        int b;
        if (input == null) {
            VLQUtil.$$$reportNull$$$0(3);
        }
        int result = 0;
        do {
            if ((b = input.read()) == -1) {
                throw new EOFException();
            }
            result = (result << 7) + (b & 0x7F);
        } while ((b & 0x80) != 0);
        return result;
    }

    public static void writeCount(int count, int totalValues, @NotNull OutputStream output) throws IOException {
        if (output == null) {
            VLQUtil.$$$reportNull$$$0(4);
        }
        do {
            if (totalValues <= 256) {
                output.write(count & 0xFF);
                break;
            }
            output.write(count < 128 ? count & 0x7F : count & 0x7F | 0x80);
            totalValues >>= 7;
        } while ((count >>= 7) > 0);
    }

    public static int readCount(int totalValues, @NotNull InputStream input) throws IOException {
        if (input == null) {
            VLQUtil.$$$reportNull$$$0(5);
        }
        int result = 0;
        int bites = 0;
        while (totalValues > 256) {
            int b = input.read();
            result += (b & 0x7F) << bites;
            if ((b & 0x80) == 0) {
                return result;
            }
            totalValues >>= 7;
            bites += 7;
        }
        return result + ((input.read() & 0xFF) << bites);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/compress/VLQUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLong";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeInt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readLong";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readInt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCount";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

