/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.compress;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jetbrains.exodus.compress.VLQUtil;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcDiff {
    @NotNull
    private final Config config;
    @NotNull
    private final Deflater compressor;
    @NotNull
    private final Inflater decompressor;
    @NotNull
    private final byte[] dictionaryBytes;
    @NotNull
    private final byte[] sourceBytes;
    @NotNull
    private final byte[] compressedBytes;

    public VcDiff() {
        this(Config.DEFAULT);
    }

    public VcDiff(@NotNull Config config) {
        if (config == null) {
            VcDiff.$$$reportNull$$$0(0);
        }
        this.config = config;
        this.compressor = new Deflater(9);
        this.decompressor = new Inflater();
        int windowSize = config.getWindowSize();
        this.dictionaryBytes = new byte[windowSize / 2];
        this.sourceBytes = new byte[windowSize];
        this.compressedBytes = new byte[windowSize * 2];
    }

    @NotNull
    public Config getConfig() {
        Config config = this.config;
        if (config == null) {
            VcDiff.$$$reportNull$$$0(1);
        }
        return config;
    }

    public void close() {
        this.compressor.end();
        this.decompressor.end();
    }

    public boolean encode(@NotNull InputStream source, @Nullable InputStream previousSource, @NotNull OutputStream delta) throws IOException {
        int windowSize;
        int halfWindowSize;
        byte[] sourceWindow;
        int actuallyRead;
        if (source == null) {
            VcDiff.$$$reportNull$$$0(2);
        }
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(3);
        }
        if ((actuallyRead = IOUtil.readFully(source, sourceWindow = new byte[halfWindowSize = (windowSize = this.config.getWindowSize()) / 2])) < 1) {
            return true;
        }
        LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
        this.encodeDiffWindow(new ByteArrayInputStream(sourceWindow, 0, actuallyRead), previousSource, tempOutput);
        int tempOutputSize = tempOutput.size();
        if (tempOutputSize * 100 / actuallyRead > this.config.getTargetPercentage()) {
            VLQUtil.writeInt(0, delta);
            delta.write(sourceWindow, 0, actuallyRead);
            IOUtil.copyStreams(source, delta, IOUtil.BUFFER_ALLOCATOR);
            return false;
        }
        VLQUtil.writeInt(windowSize, delta);
        delta.write(tempOutput.toByteArray(), 0, tempOutput.size());
        while (this.encodeDiffWindow(source, previousSource, delta) > 0) {
        }
        return true;
    }

    public OutputStream encode(@Nullable InputStream previousSource, @NotNull OutputStream delta) {
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(4);
        }
        return this.encode(previousSource, delta, this.config);
    }

    public OutputStream encode(final @Nullable InputStream previousSource, final @NotNull OutputStream delta, final @NotNull Config config) {
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(5);
        }
        if (config == null) {
            VcDiff.$$$reportNull$$$0(6);
        }
        return new OutputStream(){
            private final int windowSize;
            private LightByteArrayOutputStream tempOutput;
            private boolean ratioTested;
            {
                this.windowSize = config.getWindowSize();
                this.tempOutput = new LightByteArrayOutputStream();
                this.ratioTested = false;
            }

            @Override
            public void write(int b) throws IOException {
                if (this.tempOutput == null) {
                    delta.write(b);
                } else {
                    this.tempOutput.write(b);
                    this.flushTempOutputIfNecessary();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.tempOutput == null) {
                    delta.write(b, off, len);
                } else {
                    this.tempOutput.write(b, off, len);
                    this.flushTempOutputIfNecessary();
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    if (this.tempOutput != null) {
                        while (this.tempOutput.size() > 0) {
                            this.flushTempOutput();
                            if (this.tempOutput != null) continue;
                            return;
                        }
                        if (this.ratioTested) {
                            VLQUtil.writeInt(0, delta);
                        }
                    }
                }
                finally {
                    delta.close();
                }
            }

            private void flushTempOutputIfNecessary() throws IOException {
                while (this.tempOutput != null && this.tempOutput.size() >= this.windowSize) {
                    this.flushTempOutput();
                }
            }

            private void flushTempOutput() throws IOException {
                int size = this.tempOutput.size();
                if (size > 0) {
                    int actuallyRead;
                    byte[] tempOutputBytes = this.tempOutput.toByteArray();
                    if (this.ratioTested) {
                        actuallyRead = VcDiff.this.encodeDiffWindow(new ByteArrayInputStream(tempOutputBytes, 0, size), previousSource, delta);
                    } else {
                        LightByteArrayOutputStream testOutput = new LightByteArrayOutputStream();
                        actuallyRead = VcDiff.this.encodeDiffWindow(new ByteArrayInputStream(tempOutputBytes, 0, size), previousSource, testOutput);
                        int testOutputSize = testOutput.size();
                        if (testOutputSize * 100 / actuallyRead > config.getTargetPercentage()) {
                            Runnable beforeWritingUncompressedClosure = config.getBeforeWritingUncompressedClosure();
                            if (beforeWritingUncompressedClosure != null) {
                                beforeWritingUncompressedClosure.run();
                            }
                            VLQUtil.writeInt(0, delta);
                            delta.write(tempOutputBytes, 0, size);
                            this.tempOutput = null;
                            return;
                        }
                        this.ratioTested = true;
                        Runnable beforeWritingCompressedClosure = config.getBeforeWritingCompressedClosure();
                        if (beforeWritingCompressedClosure != null) {
                            beforeWritingCompressedClosure.run();
                        }
                        VLQUtil.writeInt(this.windowSize, delta);
                        delta.write(testOutput.toByteArray(), 0, testOutputSize);
                    }
                    if (actuallyRead == size) {
                        this.tempOutput = new LightByteArrayOutputStream();
                    } else {
                        int newSize = size - actuallyRead;
                        System.arraycopy(tempOutputBytes, actuallyRead, tempOutputBytes, 0, newSize);
                        this.tempOutput.setSize(newSize);
                    }
                }
            }
        };
    }

    public void decode(@Nullable InputStream previousSource, @NotNull InputStream delta, @NotNull OutputStream source) throws IOException {
        int windowSize;
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(7);
        }
        if (source == null) {
            VcDiff.$$$reportNull$$$0(8);
        }
        try {
            windowSize = VLQUtil.readInt(delta);
        }
        catch (EOFException e) {
            return;
        }
        if (windowSize == 0) {
            IOUtil.copyStreams(delta, source, IOUtil.BUFFER_ALLOCATOR);
            return;
        }
        while (!this.decodeDiffWindow(previousSource, delta, source)) {
        }
    }

    public InputStream decode(final @Nullable InputStream previousSource, final @NotNull InputStream delta) throws IOException {
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(9);
        }
        return new InputStream(){
            private int windowSize = -1;
            private InputStream tempStream = null;
            private boolean eof = false;

            @Override
            public int read() throws IOException {
                if (this.readHeader()) {
                    while (true) {
                        int result;
                        if (this.tempStream != null && (result = this.tempStream.read()) >= 0) {
                            return result;
                        }
                        if (this.eof) break;
                        LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
                        this.eof = VcDiff.this.decodeDiffWindow(previousSource, delta, tempOutput);
                        this.tempStream = this.eof ? null : new ByteArrayInputStream(tempOutput.toByteArray(), 0, tempOutput.size());
                    }
                }
                return this.windowSize == 0 ? delta.read() : -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.readHeader()) {
                    while (true) {
                        int result;
                        if (this.tempStream != null && (result = this.tempStream.read(b, off, len)) > 0) {
                            return result;
                        }
                        if (this.eof) break;
                        LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
                        this.eof = VcDiff.this.decodeDiffWindow(previousSource, delta, tempOutput);
                        this.tempStream = this.eof ? null : new ByteArrayInputStream(tempOutput.toByteArray(), 0, tempOutput.size());
                    }
                }
                return this.windowSize == 0 ? delta.read(b, off, len) : -1;
            }

            private boolean readHeader() throws IOException {
                if (this.windowSize == -1) {
                    try {
                        this.windowSize = VLQUtil.readInt(delta);
                    }
                    catch (EOFException e) {
                        return false;
                    }
                }
                return this.windowSize > 0;
            }
        };
    }

    private int encodeDiffWindow(@NotNull InputStream source, @Nullable InputStream previousSource, @NotNull OutputStream delta) throws IOException {
        if (source == null) {
            VcDiff.$$$reportNull$$$0(10);
        }
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(11);
        }
        int dictionarySize = previousSource == null ? 0 : IOUtil.readFully(previousSource, this.dictionaryBytes);
        this.compressor.reset();
        int windowSize = this.config.getWindowSize();
        int actuallyRead = IOUtil.readFully(source, this.sourceBytes, windowSize - dictionarySize);
        if (actuallyRead <= 0) {
            VLQUtil.writeInt(0, delta);
        } else {
            if (dictionarySize > 0) {
                this.compressor.setDictionary(this.dictionaryBytes, 0, dictionarySize);
            }
            this.compressor.setInput(this.sourceBytes, 0, actuallyRead);
            this.compressor.finish();
            int compressedSize = this.compressor.deflate(this.compressedBytes);
            VLQUtil.writeInt(compressedSize, delta);
            delta.write(this.compressedBytes, 0, compressedSize);
        }
        return actuallyRead;
    }

    private boolean decodeDiffWindow(@Nullable InputStream previousSource, @NotNull InputStream delta, @NotNull OutputStream output) throws IOException {
        int compressedSize;
        if (delta == null) {
            VcDiff.$$$reportNull$$$0(12);
        }
        if (output == null) {
            VcDiff.$$$reportNull$$$0(13);
        }
        if ((compressedSize = VLQUtil.readInt(delta)) > 0) {
            int dictionarySize = previousSource == null ? 0 : IOUtil.readFully(previousSource, this.dictionaryBytes);
            this.decompressor.reset();
            try {
                if (IOUtil.readFully(delta, this.compressedBytes, compressedSize) != compressedSize) {
                    throw new DataFormatException();
                }
                this.decompressor.setInput(this.compressedBytes);
                int sourceSize = this.decompressor.inflate(this.sourceBytes);
                if (dictionarySize > 0 && this.decompressor.needsDictionary()) {
                    this.decompressor.getAdler();
                    this.decompressor.setDictionary(this.dictionaryBytes, 0, dictionarySize);
                    sourceSize = this.decompressor.inflate(this.sourceBytes);
                }
                output.write(this.sourceBytes, 0, sourceSize);
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return compressedSize == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/exodus/compress/VcDiff";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/exodus/compress/VcDiff";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "encodeDiffWindow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "decodeDiffWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Config {
        public static final Config DEFAULT = new Config();
        private static final int DEFAULT_WINDOW_SIZE = 32768;
        private static final int DEFAULT_TARGET_PERCENTAGE = 50;
        private int windowSize;
        private int targetPercentage;
        @Nullable
        private Runnable beforeWritingCompressedClosure;
        @Nullable
        private Runnable beforeWritingUncompressedClosure;

        public Config() {
            this.windowSize = 32768;
            this.targetPercentage = 50;
            this.beforeWritingCompressedClosure = null;
            this.beforeWritingUncompressedClosure = null;
        }

        private Config(@NotNull Config source) {
            if (source == null) {
                Config.$$$reportNull$$$0(0);
            }
            this.windowSize = source.windowSize;
            this.targetPercentage = source.targetPercentage;
            this.beforeWritingCompressedClosure = source.beforeWritingCompressedClosure;
            this.beforeWritingUncompressedClosure = source.beforeWritingUncompressedClosure;
        }

        public Config getClone() {
            return new Config(this);
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public void setWindowSize(int windowSize) {
            this.windowSize = windowSize;
        }

        public int getTargetPercentage() {
            return this.targetPercentage;
        }

        public void setTargetPercentage(int targetPercentage) {
            this.targetPercentage = targetPercentage;
        }

        @Nullable
        public Runnable getBeforeWritingCompressedClosure() {
            return this.beforeWritingCompressedClosure;
        }

        public void setBeforeWritingCompressedClosure(@Nullable Runnable beforeWritingCompressedClosure) {
            this.beforeWritingCompressedClosure = beforeWritingCompressedClosure;
        }

        @Nullable
        public Runnable getBeforeWritingUncompressedClosure() {
            return this.beforeWritingUncompressedClosure;
        }

        public void setBeforeWritingUncompressedClosure(@Nullable Runnable beforeWritingUncompressedClosure) {
            this.beforeWritingUncompressedClosure = beforeWritingUncompressedClosure;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/exodus/compress/VcDiff$Config", "<init>"));
        }
    }
}

