/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentLongObjectCache<V>
extends LongObjectCacheBase<V> {
    private static final int DEFAULT_NUMBER_OF_GENERATIONS = 3;
    private final int numberOfGenerations;
    private final int generationSize;
    private final int mask;
    private final CacheEntry<V>[] cache;

    public ConcurrentLongObjectCache() {
        this(8192);
    }

    public ConcurrentLongObjectCache(int size) {
        this(size, 3);
    }

    public ConcurrentLongObjectCache(int size, int numberOfGenerations) {
        super(size);
        this.numberOfGenerations = numberOfGenerations;
        this.generationSize = HashUtil.getFloorPrime(size / numberOfGenerations);
        this.mask = (1 << MathUtil.integerLogarithm(this.generationSize)) - 1;
        this.cache = new CacheEntry[numberOfGenerations * this.generationSize];
        this.clear();
    }

    @Override
    public V tryKeyLocked(long key) {
        return this.tryKey(key);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.cache.length; ++i) {
            this.cache[i] = CacheEntry.NULL_OBJECT;
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V cacheObject(long key, @NotNull V v) {
        void x;
        if (v == null) {
            ConcurrentLongObjectCache.$$$reportNull$$$0(0);
        }
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (((CacheEntry)entry).key == key) {
                this.cache[cacheIndex] = new CacheEntry(key, x);
                return null;
            }
            ++i;
            ++cacheIndex;
        }
        this.cache[cacheIndex - 1] = new CacheEntry(key, x);
        return null;
    }

    @Override
    public V remove(long key) {
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (((CacheEntry)entry).key == key) {
                Object result = ((CacheEntry)entry).value;
                ((CacheEntry)entry).value = null;
                return (V)result;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public V tryKey(long key) {
        this.incAttempts();
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        CacheEntry<V> entry = this.cache[cacheIndex];
        if (((CacheEntry)entry).key == key) {
            this.incHits();
            return (V)((CacheEntry)entry).value;
        }
        for (int i = 1; i < this.numberOfGenerations; ++i) {
            if (((CacheEntry)(entry = this.cache[++cacheIndex])).key != key) continue;
            this.incHits();
            CacheEntry<V> temp = this.cache[cacheIndex - 1];
            this.cache[cacheIndex - 1] = entry;
            this.cache[cacheIndex] = temp;
            return (V)((CacheEntry)entry).value;
        }
        return null;
    }

    @Override
    public V getObject(long key) {
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (((CacheEntry)entry).key == key) {
                return (V)((CacheEntry)entry).value;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "jetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache", "cacheObject"));
    }

    private static class CacheEntry<V> {
        private static final CacheEntry NULL_OBJECT = new CacheEntry<Object>(Long.MIN_VALUE, null);
        private final long key;
        @Nullable
        private V value;

        private CacheEntry(long key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }
    }
}

