/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentObjectCache<K, V>
extends ObjectCacheBase<K, V> {
    private static final int DEFAULT_NUMBER_OF_GENERATIONS = 3;
    private final int numberOfGenerations;
    private final int generationSize;
    private final int mask;
    private final CacheEntry<K, V>[] cache;

    public ConcurrentObjectCache() {
        this(8192);
    }

    public ConcurrentObjectCache(int size) {
        this(size, 3);
    }

    public ConcurrentObjectCache(int size, int numberOfGenerations) {
        super(size);
        this.numberOfGenerations = numberOfGenerations;
        this.generationSize = HashUtil.getFloorPrime(size / numberOfGenerations);
        this.mask = (1 << MathUtil.integerLogarithm(this.generationSize)) - 1;
        this.cache = new CacheEntry[numberOfGenerations * this.generationSize];
    }

    @Override
    public V tryKeyLocked(@NotNull K key) {
        if (key == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(0);
        }
        return this.tryKey(key);
    }

    @Override
    public void clear() {
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V x) {
        if (key == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(1);
        }
        if (x == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(2);
        }
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                this.cache[cacheIndex] = new CacheEntry(key, x);
                return null;
            }
            ++i;
            ++cacheIndex;
        }
        this.cache[cacheIndex - 1] = new CacheEntry(key, x);
        return null;
    }

    @Override
    public V remove(@NotNull K key) {
        if (key == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(3);
        }
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                Object result = ((CacheEntry)entry).value;
                ((CacheEntry)entry).value = null;
                return (V)result;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public V tryKey(@NotNull K key) {
        if (key == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(4);
        }
        this.incAttempts();
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        CacheEntry<K, V> entry = this.cache[cacheIndex];
        if (entry != null && ((CacheEntry)entry).key.equals(key)) {
            this.incHits();
            return (V)((CacheEntry)entry).value;
        }
        for (int i = 1; i < this.numberOfGenerations; ++i) {
            if ((entry = this.cache[++cacheIndex]) == null || !((CacheEntry)entry).key.equals(key)) continue;
            this.incHits();
            CacheEntry<K, V> temp = this.cache[cacheIndex - 1];
            this.cache[cacheIndex - 1] = entry;
            this.cache[cacheIndex] = temp;
            return (V)((CacheEntry)entry).value;
        }
        return null;
    }

    @Override
    public V getObject(@NotNull K key) {
        if (key == null) {
            ConcurrentObjectCache.$$$reportNull$$$0(5);
        }
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                return (V)((CacheEntry)entry).value;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/dataStructures/ConcurrentObjectCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryKeyLocked";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CacheEntry<K, V> {
        @NotNull
        private final K key;
        @Nullable
        private V value;

        private CacheEntry(@NotNull K key, @Nullable V value) {
            if (key == null) {
                CacheEntry.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.value = value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/exodus/core/dataStructures/ConcurrentObjectCache$CacheEntry", "<init>"));
        }
    }
}

