/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.lang.ref.SoftReference;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SoftObjectCacheBase<K, V>
extends ObjectCacheBase<K, V> {
    public static final int MIN_SIZE = 16;
    private final int chunkSize;
    private final SoftReference<ObjectCacheBase<K, V>>[] chunks;

    SoftObjectCacheBase(int cacheSize) {
        super(cacheSize);
        if (cacheSize < 16) {
            cacheSize = 16;
        }
        this.chunks = new SoftReference[SoftObjectCacheBase.computeNumberOfChunks(cacheSize)];
        this.chunkSize = cacheSize / this.chunks.length;
        this.clear();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = null;
        }
    }

    @Override
    public final void lock() {
    }

    @Override
    public final void unlock() {
    }

    @Override
    public V tryKey(@NotNull K key) {
        V result;
        if (key == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(0);
        }
        this.incAttempts();
        ObjectCacheBase<K, V> chunk = this.getChunk(key, false);
        V v = result = chunk == null ? null : (V)chunk.tryKeyLocked(key);
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(@NotNull K key) {
        ObjectCacheBase<K, V> chunk;
        if (key == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(1);
        }
        if ((chunk = this.getChunk(key, false)) == null) {
            return null;
        }
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.getObject(key);
            return v;
        }
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V value) {
        if (key == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(2);
        }
        if (value == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(3);
        }
        ObjectCacheBase<K, V> chunk = this.getChunk(key, true);
        assert (chunk != null);
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.cacheObject(key, value);
            return v;
        }
    }

    @Override
    public V remove(@NotNull K key) {
        ObjectCacheBase<K, V> chunk;
        if (key == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(4);
        }
        if ((chunk = this.getChunk(key, false)) == null) {
            return null;
        }
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.remove(key);
            return v;
        }
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    static int computeNumberOfChunks(int cacheSize) {
        int result = (int)Math.sqrt(cacheSize);
        while (result * result < cacheSize) {
            ++result;
        }
        return HashUtil.getCeilingPrime(result);
    }

    protected abstract ObjectCacheBase<K, V> newChunk(int var1);

    @Nullable
    private ObjectCacheBase<K, V> getChunk(@NotNull K key, boolean create) {
        int hc;
        int chunkIndex;
        SoftReference<ObjectCacheBase<K, V>> ref;
        ObjectCacheBase<K, V> result;
        if (key == null) {
            SoftObjectCacheBase.$$$reportNull$$$0(5);
        }
        ObjectCacheBase<K, V> objectCacheBase = result = (ref = this.chunks[chunkIndex = ((hc = key.hashCode()) + (hc >> 31) & Integer.MAX_VALUE) % this.chunks.length]) == null ? null : ref.get();
        if (result == null && create) {
            result = this.newChunk(this.chunkSize);
            this.chunks[chunkIndex] = new SoftReference<ObjectCacheBase<K, V>>(result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/dataStructures/SoftObjectCacheBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getChunk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

