/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class QueueDecorator<E>
implements Queue<E> {
    private List<E> decorated;

    public QueueDecorator() {
        this.clear();
    }

    public QueueDecorator(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.decorated.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decorated == Collections.emptyList() || this.decorated.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.decorated.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.decorated.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.decorated.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.decorated.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.checkDecorated();
        return this.decorated.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.checkDecorated();
        return this.decorated.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.decorated.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkDecorated();
        return this.decorated.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkDecorated();
        return this.decorated.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkDecorated();
        return this.decorated.retainAll(c);
    }

    @Override
    public void clear() {
        this.decorated = Collections.emptyList();
    }

    @Override
    public boolean offer(E e) {
        this.checkDecorated();
        return this.decorated.add(e);
    }

    @Override
    public E remove() {
        if (this.decorated.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.decorated.remove(0);
    }

    @Override
    public E poll() {
        return this.decorated.size() == 0 ? null : (E)this.decorated.remove(0);
    }

    @Override
    public E element() {
        if (this.decorated.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.decorated.get(0);
    }

    @Override
    public E peek() {
        return this.decorated.size() == 0 ? null : (E)this.decorated.get(0);
    }

    private void checkDecorated() {
        if (this.decorated == Collections.emptyList()) {
            this.decorated = new ArrayList();
        }
    }
}

