/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;

public class LongHashSet
extends AbstractSet<Long>
implements LongSet {
    private Entry[] table;
    private int capacity;
    private int size;
    private final float loadFactor;
    private int mask;

    public LongHashSet() {
        this(0);
    }

    public LongHashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public LongHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public LongHashSet(@NotNull LongSet source) {
        if (source == null) {
            LongHashSet.$$$reportNull$$$0(0);
        }
        this(source.size());
        LongIterator longIterator = source.iterator();
        while (longIterator.hasNext()) {
            long element = (Long)longIterator.next();
            this.add(element);
        }
    }

    public LongHashSet(@NotNull Collection<Long> source) {
        if (source == null) {
            LongHashSet.$$$reportNull$$$0(1);
        }
        this(source.size());
        for (long element : source) {
            this.add(element);
        }
    }

    @Override
    public boolean contains(long key) {
        Entry[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    @Override
    public boolean add(long key) {
        Entry[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            if (e.key == key) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry(key);
        e.hashNext = table[index];
        table[index] = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean add(Long key) {
        return this.add((long)key);
    }

    @Override
    public boolean remove(long key) {
        Entry[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return false;
        }
        if (e.key == key) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while (e.key != key);
            last.hashNext = e.hashNext;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.remove((Long)key);
    }

    @Override
    public LongIterator iterator() {
        return new HashSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long[] toLongArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        long[] result = new long[this.size];
        int i = 0;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            result[i++] = itr.nextLong();
        }
        return result;
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.capacity = capacity;
        this.size = 0;
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            RehashIterator entries = new RehashIterator();
            this.allocateTable(length);
            Entry[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index = HashUtil.indexFor(e.key, length, mask);
                e.hashNext = table[index];
                table[index] = e;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/exodus/core/dataStructures/hash/LongHashSet", "<init>"));
    }

    private class HashSetIterator
    extends AbstractHashSetIterator<Long>
    implements LongIterator {
        private HashSetIterator() {
        }

        @Override
        public Long next() {
            return this.nextEntry().key;
        }

        @Override
        public long nextLong() {
            return this.nextEntry().key;
        }
    }

    private abstract class AbstractHashSetIterator<T>
    implements Iterator<T> {
        private final Entry[] table;
        private int index;
        private Entry e;
        private Entry last;

        AbstractHashSetIterator() {
            this.table = LongHashSet.this.table;
            this.index = 0;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongHashSet.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry nextEntry() {
            Entry result = this.last = this.e;
            this.initNextEntry();
            return result;
        }

        private void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.hashNext;
            }
            Entry[] table = this.table;
            while (result == null && this.index < table.length) {
                result = table[this.index++];
            }
            this.e = result;
        }
    }

    private static class Entry {
        private final long key;
        private Entry hashNext;

        private Entry(long key) {
            this.key = key;
        }
    }

    private final class RehashIterator
    extends AbstractHashSetIterator<Entry> {
        private RehashIterator() {
        }

        @Override
        public Entry next() {
            return this.nextEntry();
        }
    }
}

