/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.Stack;
import jetbrains.exodus.core.dataStructures.persistent.LongComparable;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPersistent23Tree<K extends Comparable<K>>
implements Iterable<K> {
    abstract RootNode<K> getRoot();

    public boolean contains(K key) {
        RootNode<K> root = this.getRoot();
        return root != null && root.get(key) != null;
    }

    public final boolean isEmpty() {
        return this.getRoot() == null;
    }

    public final int size() {
        RootNode<K> root = this.getRoot();
        return root == null ? 0 : root.getSize();
    }

    @Nullable
    public final K getMinimum() {
        Iterator<K> it = this.iterator();
        return (K)(it.hasNext() ? (Comparable)it.next() : null);
    }

    @Nullable
    public final K getMaximum() {
        Iterator<K> it = this.reverseIterator();
        return (K)(it.hasNext() ? (Comparable)it.next() : null);
    }

    @Override
    public final Iterator<K> iterator() {
        RootNode<K> root = this.getRoot();
        if (root == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        final TreePos[] stack = new TreePos[MathUtil.integerLogarithm(root.getSize()) + 1];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = new TreePos<K>(root);
        }
        return new Iterator<K>(){
            private int i = 0;
            private boolean hasNext;
            private boolean hasNextValid;

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                TreePos treePos = stack[this.i];
                if (treePos.node.isLeaf()) {
                    while (treePos.pos >= (treePos.node.isTernary() ? 2 : 1)) {
                        if (--this.i < 0) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = stack[this.i];
                    }
                } else {
                    TreePos newPos = stack[++this.i];
                    newPos.pos = 0;
                    newPos.node = treePos.pos == 0 ? treePos.node.getFirstChild() : (treePos.pos == 1 ? treePos.node.getSecondChild() : treePos.node.getThirdChild());
                    treePos = newPos;
                    while (!treePos.node.isLeaf()) {
                        newPos = stack[++this.i];
                        newPos.pos = 0;
                        newPos.node = treePos.node.getFirstChild();
                        treePos = newPos;
                    }
                }
                ++treePos.pos;
                this.hasNext = true;
                return true;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePos treePos = stack[this.i];
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> tailIterator(K key) {
        return new Iterator<K>((Comparable)key){
            private Stack<TreePos<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;
            final /* synthetic */ Comparable val$key;
            {
                this.val$key = comparable;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode<Comparable> root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.stack = new Stack();
                    if (!root.getLess(this.val$key, this.stack)) {
                        this.stack.push(new TreePos(root));
                    }
                }
                TreePos treePos = this.stack.peek();
                if (treePos.node.isLeaf()) {
                    while (treePos.pos >= (treePos.node.isTernary() ? 2 : 1)) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 0 ? new TreePos(treePos.node.getFirstChild()) : (treePos.pos == 1 ? new TreePos(treePos.node.getSecondChild()) : new TreePos(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePos(treePos.node.getFirstChild());
                        this.stack.push(treePos);
                    }
                }
                ++treePos.pos;
                this.hasNext = true;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePos treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> reverseIterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        RootNode<K> root = this.getRoot();
        final TreePosRev[] stack = new TreePosRev[MathUtil.integerLogarithm(root.getSize()) + 1];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = new TreePosRev<K>(root);
        }
        return new Iterator<K>(){
            private int i = 0;
            private boolean hasNext;
            private boolean hasNextValid;

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                TreePosRev treePos = stack[this.i];
                if (treePos.node.isLeaf()) {
                    while (treePos.pos <= 1) {
                        if (--this.i < 0) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = stack[this.i];
                    }
                } else {
                    TreePosRev newPos = stack[++this.i];
                    if (treePos.pos == 1) {
                        newPos.setNode(treePos.node.getFirstChild());
                    } else if (treePos.pos == 2) {
                        newPos.setNode(treePos.node.getSecondChild());
                    } else {
                        newPos.setNode(treePos.node.getThirdChild());
                    }
                    treePos = newPos;
                    while (!treePos.node.isLeaf()) {
                        newPos = stack[++this.i];
                        newPos.setNode(treePos.node.isTernary() ? treePos.node.getThirdChild() : treePos.node.getSecondChild());
                        treePos = newPos;
                    }
                }
                treePos.pos--;
                this.hasNext = true;
                return true;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePosRev treePos = stack[this.i];
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<K> tailReverseIterator(K key) {
        return new Iterator<K>((Comparable)key){
            private Stack<TreePosRev<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;
            private K bound;
            final /* synthetic */ Comparable val$key;
            {
                this.val$key = comparable;
            }

            @Override
            public boolean hasNext() {
                TreePosRev treePos;
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootNode root = AbstractPersistent23Tree.this.getRoot();
                    if (root == null) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    this.bound = AbstractPersistent23Tree.getLess(root, this.val$key);
                    this.stack = new Stack();
                    this.stack.push(new TreePosRev(root));
                }
                if ((treePos = this.stack.peek()).node.isLeaf()) {
                    while (treePos.pos <= 1) {
                        this.stack.pop();
                        if (this.stack.isEmpty()) {
                            this.hasNext = false;
                            return this.hasNext;
                        }
                        treePos = this.stack.peek();
                    }
                } else {
                    treePos = treePos.pos == 1 ? new TreePosRev(treePos.node.getFirstChild()) : (treePos.pos == 2 ? new TreePosRev(treePos.node.getSecondChild()) : new TreePosRev(treePos.node.getThirdChild()));
                    this.stack.push(treePos);
                    while (!treePos.node.isLeaf()) {
                        treePos = new TreePosRev(treePos.node.isTernary() ? treePos.node.getThirdChild() : treePos.node.getSecondChild());
                        this.stack.push(treePos);
                    }
                }
                treePos.pos--;
                this.hasNext = this.tryNext() != this.bound;
                return this.hasNext;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                return this.tryNext();
            }

            private K tryNext() {
                TreePosRev treePos = this.stack.peek();
                return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <K extends Comparable<K>> Node<K> createNode(@Nullable Node<K> firstChild, @NotNull K key, @Nullable Node<K> secondChild) {
        if (key == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(0);
        }
        if (firstChild == null && secondChild == null) {
            return new BinaryNode<K>(key);
        }
        return new InternalBinaryNode<K>(firstChild, key, secondChild);
    }

    static <K extends Comparable<K>> RootNode<K> createRootNode(@Nullable Node<K> firstChild, @NotNull K key, @Nullable Node<K> secondChild, int size) {
        if (key == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(1);
        }
        if (firstChild == null && secondChild == null) {
            return new RootBinaryNode<K>(key, size);
        }
        return new RootInternalBinaryNode<K>(firstChild, key, secondChild, size);
    }

    static <K extends Comparable<K>> Node<K> createNode(@Nullable Node<K> firstChild, @NotNull K firstKey, @Nullable Node<K> secondChild, @NotNull K secondKey, @Nullable Node<K> thirdChild) {
        if (firstKey == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(2);
        }
        if (secondKey == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(3);
        }
        if (firstChild == null && secondChild == null && thirdChild == null) {
            return new TernaryNode<K>(firstKey, secondKey);
        }
        return new InternalTernaryNode<K>(firstChild, firstKey, secondChild, secondKey, thirdChild);
    }

    static <K extends Comparable<K>> RootNode<K> createRootNode(@Nullable Node<K> firstChild, @NotNull K firstKey, @Nullable Node<K> secondChild, @NotNull K secondKey, @Nullable Node<K> thirdChild, int size) {
        if (firstKey == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(4);
        }
        if (secondKey == null) {
            AbstractPersistent23Tree.$$$reportNull$$$0(5);
        }
        if (firstChild == null && secondChild == null && thirdChild == null) {
            return new RootTernaryNode<K>(firstKey, secondKey, size);
        }
        return new RootInternalTernaryNode<K>(firstChild, firstKey, secondChild, secondKey, thirdChild, size);
    }

    static <K extends Comparable<K>> void checkNode(Node<K> node) {
        node.checkNode(null, null);
    }

    static <K extends Comparable<K>> boolean getLess(Node<K> node, Stack<TreePos<K>> stack) {
        stack.push(new TreePos<K>(node));
        return false;
    }

    static <K extends Comparable<K>> K getLess(Node<K> node, K key) {
        Stack stack = new Stack();
        if (!node.getLess(key, stack)) {
            return null;
        }
        TreePos treePos = stack.peek();
        return treePos.pos == 1 ? treePos.node.getFirstKey() : treePos.node.getSecondKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstKey";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondKey";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNode";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createRootNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class SplitResult<K extends Comparable<K>> {
        private Node<K> firstNode;
        private Node<K> secondNode;
        private K key;
        boolean sizeChanged = false;

        SplitResult() {
        }

        SplitResult<K> fill(@Nullable Node<K> first, @Nullable K key, @Nullable Node<K> second) {
            this.firstNode = first;
            this.key = key;
            this.secondNode = second;
            return this;
        }

        public SplitResult<K> fill(@NotNull Node<K> node) {
            if (node == null) {
                SplitResult.$$$reportNull$$$0(0);
            }
            return this.fill(node, null, null);
        }

        public Node<K> getFirstNode() {
            return this.firstNode;
        }

        public Node<K> getSecondNode() {
            return this.secondNode;
        }

        public K getKey() {
            return this.key;
        }

        public SplitResult<K> setSizeChanged() {
            this.sizeChanged = true;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$SplitResult", "fill"));
        }
    }

    static class RemovedNode<K extends Comparable<K>>
    implements Node<K> {
        private final Node<K> child;

        RemovedNode(Node<K> child) {
            this.child = child;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.child;
        }

        @Override
        public Node<K> getSecondChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTernary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RootNode<K> asRoot(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public SplitResult<K> insert(@NotNull K key) {
            if (key == null) {
                RemovedNode.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException("Can't insert into a temporary tree.");
        }

        @Override
        public Pair<Node<K>, K> remove(@NotNull K key, boolean strict) {
            if (key == null) {
                RemovedNode.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException("Can't remove from a temporary tree.");
        }

        @Override
        public K get(@NotNull K key) {
            if (key == null) {
                RemovedNode.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public K getByWeight(long weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int checkNode(@Nullable K from, @Nullable K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String print() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void count(int[] count) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$RemovedNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InternalTernaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final K secondKey;
        private final Node<K> firstChild;
        private final Node<K> secondChild;
        private final Node<K> thirdChild;

        InternalTernaryNode(@NotNull Node<K> firstChild, @NotNull K firstKey, @NotNull Node<K> secondChild, @NotNull K secondKey, @NotNull Node<K> thirdChild) {
            if (firstChild == null) {
                InternalTernaryNode.$$$reportNull$$$0(0);
            }
            if (firstKey == null) {
                InternalTernaryNode.$$$reportNull$$$0(1);
            }
            if (secondChild == null) {
                InternalTernaryNode.$$$reportNull$$$0(2);
            }
            if (secondKey == null) {
                InternalTernaryNode.$$$reportNull$$$0(3);
            }
            if (thirdChild == null) {
                InternalTernaryNode.$$$reportNull$$$0(4);
            }
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.firstChild = firstChild;
            this.secondChild = secondChild;
            this.thirdChild = thirdChild;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.firstChild;
        }

        @Override
        public Node<K> getSecondChild() {
            return this.secondChild;
        }

        @Override
        public Node<K> getThirdChild() {
            return this.thirdChild;
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            return this.secondKey;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isTernary() {
            return true;
        }

        @Override
        public RootNode<K> asRoot(int size) {
            return new RootInternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, this.secondKey, this.thirdChild, size);
        }

        @Override
        @NotNull
        public SplitResult<K> insert(@NotNull K key) {
            int comp;
            if (key == null) {
                InternalTernaryNode.$$$reportNull$$$0(5);
            }
            if ((comp = key.compareTo(this.firstKey)) < 0) {
                SplitResult<K> splitResult = this.firstChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    SplitResult<K> splitResult2 = splitResult.fill(this.cloneReplacingChild(this.firstChild, firstNode));
                    if (splitResult2 == null) {
                        InternalTernaryNode.$$$reportNull$$$0(6);
                    }
                    return splitResult2;
                }
                SplitResult<K> splitResult3 = splitResult.fill(new InternalBinaryNode<K>(firstNode, splitKey, splitResult.getSecondNode()), this.firstKey, new InternalBinaryNode<K>(this.secondChild, this.secondKey, this.thirdChild));
                if (splitResult3 == null) {
                    InternalTernaryNode.$$$reportNull$$$0(7);
                }
                return splitResult3;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new InternalTernaryNode<K>(this.firstChild, key, this.secondChild, this.secondKey, this.thirdChild));
                if (splitResult == null) {
                    InternalTernaryNode.$$$reportNull$$$0(8);
                }
                return splitResult;
            }
            comp = key.compareTo(this.secondKey);
            if (comp < 0) {
                SplitResult<K> splitResult = this.secondChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    SplitResult<K> splitResult4 = splitResult.fill(this.cloneReplacingChild(this.secondChild, firstNode));
                    if (splitResult4 == null) {
                        InternalTernaryNode.$$$reportNull$$$0(9);
                    }
                    return splitResult4;
                }
                SplitResult<K> splitResult5 = splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, firstNode), splitKey, new InternalBinaryNode<K>(splitResult.getSecondNode(), this.secondKey, this.thirdChild));
                if (splitResult5 == null) {
                    InternalTernaryNode.$$$reportNull$$$0(10);
                }
                return splitResult5;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new InternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, key, this.thirdChild));
                if (splitResult == null) {
                    InternalTernaryNode.$$$reportNull$$$0(11);
                }
                return splitResult;
            }
            SplitResult<K> splitResult = this.thirdChild.insert(key);
            Node<K> firstNode = splitResult.getFirstNode();
            K splitKey = splitResult.getKey();
            if (splitKey == null) {
                SplitResult<K> splitResult6 = splitResult.fill(this.cloneReplacingChild(this.thirdChild, firstNode));
                if (splitResult6 == null) {
                    InternalTernaryNode.$$$reportNull$$$0(12);
                }
                return splitResult6;
            }
            SplitResult<K> splitResult7 = splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, this.secondChild), this.secondKey, new InternalBinaryNode<K>(firstNode, splitKey, splitResult.getSecondNode()));
            if (splitResult7 == null) {
                InternalTernaryNode.$$$reportNull$$$0(13);
            }
            return splitResult7;
        }

        @Override
        public Pair<Node<K>, K> remove(@NotNull K key, boolean strict) {
            Object newNodeKey;
            int compFirst;
            if (key == null) {
                InternalTernaryNode.$$$reportNull$$$0(14);
            }
            int n = compFirst = strict ? key.compareTo(this.firstKey) : -1;
            if (compFirst < 0) {
                Pair<Node<K>, K> removeResult = this.firstChild.remove(key, strict);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Comparable removedKey = (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.secondChild.isTernary()) {
                        return new Pair<InternalBinaryNode<K>, Comparable>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild()), this.secondKey, this.thirdChild), removedKey);
                    }
                    return new Pair<InternalTernaryNode<K>, Comparable>(new InternalTernaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild()), this.secondChild.getFirstKey(), AbstractPersistent23Tree.createNode(this.secondChild.getSecondChild(), this.secondChild.getSecondKey(), this.secondChild.getThirdChild()), this.secondKey, this.thirdChild), removedKey);
                }
                return new Pair<Node<K>, Comparable>(this.cloneReplacingChild(this.firstChild, resultNode), removedKey);
            }
            int compSecond = -1;
            if (compFirst > 0) {
                compSecond = key.compareTo(this.secondKey);
            }
            if (compSecond < 0) {
                Object newNodeKey2;
                Pair<Node<K>, K> removeResult = this.secondChild.remove(key, compFirst != 0);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Object removedKey = compFirst == 0 ? this.firstKey : (Comparable)removeResult.getSecond();
                Object object = newNodeKey2 = compFirst != 0 ? this.firstKey : (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.firstChild.isTernary()) {
                        return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild(), newNodeKey2, removedNodeResult), this.secondKey, this.thirdChild), removedKey);
                    }
                    return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild()), this.firstChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.firstChild.getThirdChild(), newNodeKey2, removedNodeResult), this.secondKey, this.thirdChild), removedKey);
                }
                return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, newNodeKey2, resultNode, this.secondKey, this.thirdChild), removedKey);
            }
            Pair<Node<K>, K> removeResult = this.thirdChild.remove(key, compSecond != 0);
            if (removeResult == null) {
                return null;
            }
            Node<K> resultNode = removeResult.getFirst();
            Object removedKey = compSecond == 0 ? this.secondKey : (Comparable)removeResult.getSecond();
            Object object = newNodeKey = compSecond != 0 ? this.secondKey : (Comparable)removeResult.getSecond();
            if (resultNode instanceof RemovedNode) {
                Node<K> removedNodeResult = resultNode.getFirstChild();
                if (!this.secondChild.isTernary()) {
                    return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(this.firstChild, this.firstKey, AbstractPersistent23Tree.createNode(this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild(), newNodeKey, removedNodeResult)), removedKey);
                }
                return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, this.firstKey, AbstractPersistent23Tree.createNode(this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild()), this.secondChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.secondChild.getThirdChild(), newNodeKey, removedNodeResult)), removedKey);
            }
            return new Pair<InternalTernaryNode<K>, K>(new InternalTernaryNode<K>(this.firstChild, this.firstKey, this.secondChild, newNodeKey, resultNode), removedKey);
        }

        @Override
        public K get(@NotNull K key) {
            int comp;
            if (key == null) {
                InternalTernaryNode.$$$reportNull$$$0(15);
            }
            if ((comp = key.compareTo(this.firstKey)) < 0) {
                return this.firstChild.get(key);
            }
            if (comp == 0) {
                return this.firstKey;
            }
            comp = key.compareTo(this.secondKey);
            if (comp == 0) {
                return this.secondKey;
            }
            return comp < 0 ? this.secondChild.get(key) : this.thirdChild.get(key);
        }

        @Override
        public K getByWeight(long weight) {
            long keyWeight = ((LongComparable)this.firstKey).getWeight();
            if (weight < keyWeight) {
                return this.firstChild.getByWeight(weight);
            }
            if (keyWeight == weight) {
                return this.firstKey;
            }
            keyWeight = ((LongComparable)this.secondKey).getWeight();
            if (keyWeight == weight) {
                return this.secondKey;
            }
            if (weight < keyWeight) {
                return this.secondChild.getByWeight(weight);
            }
            return this.thirdChild.getByWeight(weight);
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            int comp = this.secondKey.compareTo(key);
            if (comp < 0) {
                stack.peek().pos += 2;
                this.thirdChild.getLess(key, stack);
                return true;
            }
            comp = this.firstKey.compareTo(key);
            if (comp < 0) {
                ++stack.peek().pos;
                this.secondChild.getLess(key, stack);
            } else if (!this.firstChild.getLess(key, stack)) {
                stack.pop();
                return false;
            }
            return true;
        }

        Node<K> cloneReplacingChild(@NotNull Node<K> oldChild, @NotNull Node<K> newChild) {
            if (oldChild == null) {
                InternalTernaryNode.$$$reportNull$$$0(16);
            }
            if (newChild == null) {
                InternalTernaryNode.$$$reportNull$$$0(17);
            }
            return new InternalTernaryNode<K>(this.firstChild == oldChild ? newChild : this.firstChild, this.firstKey, this.secondChild == oldChild ? newChild : this.secondChild, this.secondKey, this.thirdChild == oldChild ? newChild : this.thirdChild);
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstKey.compareTo(this.secondKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.secondKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstChild == null || this.secondChild == null || this.thirdChild == null) {
                throw new RuntimeException("The node has not enough children.");
            }
            int depth = this.firstChild.checkNode(from, this.firstKey);
            if (depth != this.secondChild.checkNode(this.firstKey, this.secondKey) || depth != this.thirdChild.checkNode(this.secondKey, to)) {
                throw new RuntimeException("Not a balanced tree.");
            }
            return depth + 1;
        }

        @Override
        public String print() {
            return '(' + this.firstChild.print() + ") " + this.firstKey + " (" + this.secondChild.print() + ") " + this.secondKey + " (" + this.thirdChild.print() + ')';
        }

        @Override
        public void count(int[] count) {
            count[3] = count[3] + 1;
            this.firstChild.count(count);
            this.secondChild.count(count);
            this.thirdChild.count(count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstChild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondChild";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondKey";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thirdChild";
                    break;
                }
                case 5: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$InternalTernaryNode";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldChild";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$InternalTernaryNode";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneReplacingChild";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RootInternalTernaryNode<K extends Comparable<K>>
    extends InternalTernaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootInternalTernaryNode(@NotNull Node<K> firstChild, @NotNull K firstKey, @NotNull Node<K> secondChild, @NotNull K secondKey, @NotNull Node<K> thirdChild, int size) {
            if (firstChild == null) {
                RootInternalTernaryNode.$$$reportNull$$$0(0);
            }
            if (firstKey == null) {
                RootInternalTernaryNode.$$$reportNull$$$0(1);
            }
            if (secondChild == null) {
                RootInternalTernaryNode.$$$reportNull$$$0(2);
            }
            if (secondKey == null) {
                RootInternalTernaryNode.$$$reportNull$$$0(3);
            }
            if (thirdChild == null) {
                RootInternalTernaryNode.$$$reportNull$$$0(4);
            }
            super(firstChild, firstKey, secondChild, secondKey, thirdChild);
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thirdChild";
                    break;
                }
            }
            objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$RootInternalTernaryNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class TernaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final K secondKey;

        TernaryNode(@NotNull K firstKey, @NotNull K secondKey) {
            if (firstKey == null) {
                TernaryNode.$$$reportNull$$$0(0);
            }
            if (secondKey == null) {
                TernaryNode.$$$reportNull$$$0(1);
            }
            this.firstKey = firstKey;
            this.secondKey = secondKey;
        }

        @Override
        public Node<K> getFirstChild() {
            return null;
        }

        @Override
        public Node<K> getSecondChild() {
            return null;
        }

        @Override
        public Node<K> getThirdChild() {
            return null;
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            return this.secondKey;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isTernary() {
            return true;
        }

        @Override
        public RootNode<K> asRoot(int size) {
            return new RootTernaryNode<K>(this.firstKey, this.secondKey, size);
        }

        @Override
        @NotNull
        public SplitResult<K> insert(@NotNull K key) {
            int comp;
            if (key == null) {
                TernaryNode.$$$reportNull$$$0(2);
            }
            if ((comp = key.compareTo(this.firstKey)) < 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new BinaryNode<K>(key), this.firstKey, new BinaryNode<K>(this.secondKey)).setSizeChanged();
                if (splitResult == null) {
                    TernaryNode.$$$reportNull$$$0(3);
                }
                return splitResult;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new TernaryNode<K>(key, this.secondKey));
                if (splitResult == null) {
                    TernaryNode.$$$reportNull$$$0(4);
                }
                return splitResult;
            }
            comp = key.compareTo(this.secondKey);
            if (comp < 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new BinaryNode<K>(this.firstKey), key, new BinaryNode<K>(this.secondKey)).setSizeChanged();
                if (splitResult == null) {
                    TernaryNode.$$$reportNull$$$0(5);
                }
                return splitResult;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new TernaryNode<K>(this.firstKey, key));
                if (splitResult == null) {
                    TernaryNode.$$$reportNull$$$0(6);
                }
                return splitResult;
            }
            SplitResult splitResult = new SplitResult<K>().fill(new BinaryNode<K>(this.firstKey), this.secondKey, new BinaryNode<K>(key)).setSizeChanged();
            if (splitResult == null) {
                TernaryNode.$$$reportNull$$$0(7);
            }
            return splitResult;
        }

        @Override
        public Pair<Node<K>, K> remove(@NotNull K key, boolean strict) {
            int compFirst;
            if (key == null) {
                TernaryNode.$$$reportNull$$$0(8);
            }
            int n = compFirst = strict ? key.compareTo(this.firstKey) : -1;
            if (compFirst < 0 && strict) {
                return null;
            }
            if (compFirst <= 0) {
                return new Pair<BinaryNode<K>, K>(new BinaryNode<K>(this.secondKey), this.firstKey);
            }
            int compSecond = -1;
            if (compFirst > 0) {
                compSecond = key.compareTo(this.secondKey);
            }
            if (compSecond != 0) {
                return null;
            }
            return new Pair<BinaryNode<K>, K>(new BinaryNode<K>(this.firstKey), this.secondKey);
        }

        @Override
        public K get(@NotNull K key) {
            int comp;
            if (key == null) {
                TernaryNode.$$$reportNull$$$0(9);
            }
            if ((comp = key.compareTo(this.firstKey)) == 0) {
                return this.firstKey;
            }
            if (comp > 0 && key.compareTo(this.secondKey) == 0) {
                return this.secondKey;
            }
            return null;
        }

        @Override
        public K getByWeight(long weight) {
            long keyWeight = ((LongComparable)this.firstKey).getWeight();
            if (keyWeight == weight) {
                return this.firstKey;
            }
            if (weight > keyWeight && weight == ((LongComparable)this.secondKey).getWeight()) {
                return this.secondKey;
            }
            return null;
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            if (this.firstKey.compareTo(key) >= 0) {
                stack.pop();
                return false;
            }
            stack.peek().pos = this.secondKey.compareTo(key) < 0 ? (stack.peek().pos += 2) : ++stack.peek().pos;
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstKey.compareTo(this.secondKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.secondKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            return 1;
        }

        @Override
        public String print() {
            return this.firstKey + ", " + this.secondKey;
        }

        @Override
        public void count(int[] count) {
            count[2] = count[2] + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondKey";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$TernaryNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$TernaryNode";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RootTernaryNode<K extends Comparable<K>>
    extends TernaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootTernaryNode(@NotNull K firstKey, @NotNull K secondKey, int size) {
            if (firstKey == null) {
                RootTernaryNode.$$$reportNull$$$0(0);
            }
            if (secondKey == null) {
                RootTernaryNode.$$$reportNull$$$0(1);
            }
            super(firstKey, secondKey);
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondKey";
                    break;
                }
            }
            objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$RootTernaryNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InternalBinaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;
        private final Node<K> firstChild;
        private final Node<K> secondChild;

        InternalBinaryNode(@NotNull Node<K> firstChild, @NotNull K firstKey, @NotNull Node<K> secondChild) {
            if (firstChild == null) {
                InternalBinaryNode.$$$reportNull$$$0(0);
            }
            if (firstKey == null) {
                InternalBinaryNode.$$$reportNull$$$0(1);
            }
            if (secondChild == null) {
                InternalBinaryNode.$$$reportNull$$$0(2);
            }
            this.firstKey = firstKey;
            this.firstChild = firstChild;
            this.secondChild = secondChild;
        }

        @Override
        public Node<K> getFirstChild() {
            return this.firstChild;
        }

        @Override
        public Node<K> getSecondChild() {
            return this.secondChild;
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isTernary() {
            return false;
        }

        @Override
        public RootNode<K> asRoot(int size) {
            return new RootInternalBinaryNode<K>(this.firstChild, this.firstKey, this.secondChild, size);
        }

        @Override
        @NotNull
        public SplitResult<K> insert(@NotNull K key) {
            int comp;
            if (key == null) {
                InternalBinaryNode.$$$reportNull$$$0(3);
            }
            if ((comp = key.compareTo(this.firstKey)) < 0) {
                SplitResult<K> splitResult = this.firstChild.insert(key);
                Node<K> firstNode = splitResult.getFirstNode();
                K splitKey = splitResult.getKey();
                if (splitKey == null) {
                    SplitResult<K> splitResult2 = splitResult.fill(new InternalBinaryNode<K>(firstNode, this.firstKey, this.secondChild));
                    if (splitResult2 == null) {
                        InternalBinaryNode.$$$reportNull$$$0(4);
                    }
                    return splitResult2;
                }
                SplitResult<K> splitResult3 = splitResult.fill(new InternalTernaryNode<K>(firstNode, splitKey, splitResult.getSecondNode(), this.firstKey, this.secondChild));
                if (splitResult3 == null) {
                    InternalBinaryNode.$$$reportNull$$$0(5);
                }
                return splitResult3;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new InternalBinaryNode<K>(this.firstChild, key, this.secondChild));
                if (splitResult == null) {
                    InternalBinaryNode.$$$reportNull$$$0(6);
                }
                return splitResult;
            }
            SplitResult<K> splitResult = this.secondChild.insert(key);
            Node<K> firstNode = splitResult.getFirstNode();
            K splitKey = splitResult.getKey();
            if (splitKey == null) {
                SplitResult<K> splitResult4 = splitResult.fill(new InternalBinaryNode<K>(this.firstChild, this.firstKey, firstNode));
                if (splitResult4 == null) {
                    InternalBinaryNode.$$$reportNull$$$0(7);
                }
                return splitResult4;
            }
            SplitResult<K> splitResult5 = splitResult.fill(new InternalTernaryNode<K>(this.firstChild, this.firstKey, firstNode, splitKey, splitResult.getSecondNode()));
            if (splitResult5 == null) {
                InternalBinaryNode.$$$reportNull$$$0(8);
            }
            return splitResult5;
        }

        @Override
        public Pair<Node<K>, K> remove(@NotNull K key, boolean strict) {
            Object newNodeKey;
            int comp;
            if (key == null) {
                InternalBinaryNode.$$$reportNull$$$0(9);
            }
            int n = comp = strict ? key.compareTo(this.firstKey) : -1;
            if (comp < 0) {
                Pair<Node<K>, K> removeResult = this.firstChild.remove(key, strict);
                if (removeResult == null) {
                    return null;
                }
                Node<K> resultNode = removeResult.getFirst();
                Comparable removedKey = (Comparable)removeResult.getSecond();
                if (resultNode instanceof RemovedNode) {
                    Node<K> removedNodeResult = resultNode.getFirstChild();
                    if (!this.secondChild.isTernary()) {
                        Node<K> node = AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild(), this.secondChild.getFirstKey(), this.secondChild.getSecondChild());
                        return new Pair<RemovedNode<K>, Comparable>(new RemovedNode<K>(node), removedKey);
                    }
                    return new Pair<InternalBinaryNode<K>, Comparable>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(removedNodeResult, this.firstKey, this.secondChild.getFirstChild()), this.secondChild.getFirstKey(), AbstractPersistent23Tree.createNode(this.secondChild.getSecondChild(), this.secondChild.getSecondKey(), this.secondChild.getThirdChild())), removedKey);
                }
                return new Pair<Node<K>, Comparable>(AbstractPersistent23Tree.createNode(resultNode, this.firstKey, this.secondChild), removedKey);
            }
            Pair<Node<K>, K> removeResult = this.secondChild.remove(key, comp != 0);
            if (removeResult == null) {
                return null;
            }
            Node<K> resultNode = removeResult.getFirst();
            Object removedKey = comp == 0 ? this.firstKey : (Comparable)removeResult.getSecond();
            Object object = newNodeKey = comp != 0 ? this.firstKey : (Comparable)removeResult.getSecond();
            if (resultNode instanceof RemovedNode) {
                Node<K> removedNodeResult = resultNode.getFirstChild();
                if (!this.firstChild.isTernary()) {
                    return new Pair<RemovedNode<K>, K>(new RemovedNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild(), newNodeKey, removedNodeResult)), removedKey);
                }
                return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(AbstractPersistent23Tree.createNode(this.firstChild.getFirstChild(), this.firstChild.getFirstKey(), this.firstChild.getSecondChild()), this.firstChild.getSecondKey(), AbstractPersistent23Tree.createNode(this.firstChild.getThirdChild(), newNodeKey, removedNodeResult)), removedKey);
            }
            return new Pair<InternalBinaryNode<K>, K>(new InternalBinaryNode<K>(this.firstChild, newNodeKey, resultNode), removedKey);
        }

        @Override
        public K get(@NotNull K key) {
            int comp;
            if (key == null) {
                InternalBinaryNode.$$$reportNull$$$0(10);
            }
            if ((comp = key.compareTo(this.firstKey)) == 0) {
                return this.firstKey;
            }
            if (comp < 0) {
                return this.firstChild.get(key);
            }
            return this.secondChild.get(key);
        }

        @Override
        public K getByWeight(long weight) {
            long firstKeyWeight = ((LongComparable)this.firstKey).getWeight();
            if (firstKeyWeight == weight) {
                return this.firstKey;
            }
            if (weight < firstKeyWeight) {
                return this.firstChild.getByWeight(weight);
            }
            return this.secondChild.getByWeight(weight);
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            int comp = this.firstKey.compareTo(key);
            if (comp < 0) {
                ++stack.peek().pos;
                this.secondChild.getLess(key, stack);
            } else if (!this.firstChild.getLess(key, stack)) {
                stack.pop();
                return false;
            }
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            int secondDepth;
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.firstKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (this.firstChild == null || this.secondChild == null) {
                throw new RuntimeException("Not an inner node.");
            }
            int firstDepth = this.firstChild.checkNode(from, this.firstKey);
            if (firstDepth != (secondDepth = this.secondChild.checkNode(this.firstKey, to))) {
                throw new RuntimeException("Not balanced tree.");
            }
            return firstDepth + 1;
        }

        @Override
        public String print() {
            return '(' + this.firstChild.print() + ") " + this.firstKey + " (" + this.secondChild.print() + ')';
        }

        @Override
        public void count(int[] count) {
            count[1] = count[1] + 1;
            this.firstChild.count(count);
            this.secondChild.count(count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstChild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondChild";
                    break;
                }
                case 3: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$InternalBinaryNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$InternalBinaryNode";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RootInternalBinaryNode<K extends Comparable<K>>
    extends InternalBinaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootInternalBinaryNode(@NotNull Node<K> firstChild, @NotNull K firstKey, @NotNull Node<K> secondChild, int size) {
            if (firstChild == null) {
                RootInternalBinaryNode.$$$reportNull$$$0(0);
            }
            if (firstKey == null) {
                RootInternalBinaryNode.$$$reportNull$$$0(1);
            }
            if (secondChild == null) {
                RootInternalBinaryNode.$$$reportNull$$$0(2);
            }
            super(firstChild, firstKey, secondChild);
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondChild";
                    break;
                }
            }
            objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$RootInternalBinaryNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class BinaryNode<K extends Comparable<K>>
    implements Node<K> {
        private final K firstKey;

        BinaryNode(@NotNull K firstKey) {
            if (firstKey == null) {
                BinaryNode.$$$reportNull$$$0(0);
            }
            this.firstKey = firstKey;
        }

        @Override
        public Node<K> getFirstChild() {
            return null;
        }

        @Override
        public Node<K> getSecondChild() {
            return null;
        }

        @Override
        public Node<K> getThirdChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirstKey() {
            return this.firstKey;
        }

        @Override
        public K getSecondKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isTernary() {
            return false;
        }

        @Override
        public RootNode<K> asRoot(int size) {
            return new RootBinaryNode<K>(this.firstKey, size);
        }

        @Override
        @NotNull
        public SplitResult<K> insert(@NotNull K key) {
            int comp;
            if (key == null) {
                BinaryNode.$$$reportNull$$$0(1);
            }
            if ((comp = key.compareTo(this.firstKey)) < 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new TernaryNode<K>(key, this.firstKey)).setSizeChanged();
                if (splitResult == null) {
                    BinaryNode.$$$reportNull$$$0(2);
                }
                return splitResult;
            }
            if (comp == 0) {
                SplitResult splitResult = new SplitResult<K>().fill(new BinaryNode<K>(key));
                if (splitResult == null) {
                    BinaryNode.$$$reportNull$$$0(3);
                }
                return splitResult;
            }
            SplitResult splitResult = new SplitResult<K>().fill(new TernaryNode<K>(this.firstKey, key)).setSizeChanged();
            if (splitResult == null) {
                BinaryNode.$$$reportNull$$$0(4);
            }
            return splitResult;
        }

        @Override
        public Pair<Node<K>, K> remove(@NotNull K key, boolean strict) {
            int comp;
            if (key == null) {
                BinaryNode.$$$reportNull$$$0(5);
            }
            int n = comp = strict ? key.compareTo(this.firstKey) : -1;
            if (strict && comp != 0) {
                return null;
            }
            return new Pair(new RemovedNode(null), this.firstKey);
        }

        @Override
        public K get(@NotNull K key) {
            if (key == null) {
                BinaryNode.$$$reportNull$$$0(6);
            }
            return key.compareTo(this.firstKey) == 0 ? (K)this.firstKey : null;
        }

        @Override
        public K getByWeight(long weight) {
            long firstKeyWeight = ((LongComparable)this.firstKey).getWeight();
            return firstKeyWeight == weight ? (K)this.firstKey : null;
        }

        @Override
        public boolean getLess(K key, Stack<TreePos<K>> stack) {
            AbstractPersistent23Tree.getLess(this, stack);
            if (this.firstKey.compareTo(key) >= 0) {
                stack.pop();
                return false;
            }
            ++stack.peek().pos;
            return true;
        }

        @Override
        public int checkNode(K from, K to) {
            if (from != null && from.compareTo(this.firstKey) >= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            if (to != null && to.compareTo(this.firstKey) <= 0) {
                throw new RuntimeException("Not a search tree.");
            }
            return 1;
        }

        @Override
        public String print() {
            return String.valueOf(this.firstKey);
        }

        @Override
        public void count(int[] count) {
            count[0] = count[0] + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKey";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$BinaryNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$BinaryNode";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RootBinaryNode<K extends Comparable<K>>
    extends BinaryNode<K>
    implements RootNode<K> {
        private final int size;

        RootBinaryNode(@NotNull K firstKey, int size) {
            if (firstKey == null) {
                RootBinaryNode.$$$reportNull$$$0(0);
            }
            super(firstKey);
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstKey", "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree$RootBinaryNode", "<init>"));
        }
    }

    static interface RootNode<K extends Comparable<K>>
    extends Node<K> {
        public int getSize();
    }

    static interface Node<K extends Comparable<K>> {
        public Node<K> getFirstChild();

        public Node<K> getSecondChild();

        public Node<K> getThirdChild();

        public K getFirstKey();

        public K getSecondKey();

        public boolean isLeaf();

        public boolean isTernary();

        public RootNode<K> asRoot(int var1);

        @NotNull
        public SplitResult<K> insert(@NotNull K var1);

        public Pair<Node<K>, K> remove(@NotNull K var1, boolean var2);

        public K get(@NotNull K var1);

        public K getByWeight(long var1);

        public boolean getLess(K var1, Stack<TreePos<K>> var2);

        public int checkNode(@Nullable K var1, @Nullable K var2);

        public String print();

        public void count(int[] var1);
    }

    private static class TreePosRev<K extends Comparable<K>> {
        private Node<K> node;
        private int pos;

        TreePosRev(Node<K> node) {
            this.setNode(node);
        }

        private void setNode(Node<K> node) {
            this.node = node;
            this.pos = 2;
            if (node.isTernary()) {
                this.pos = 3;
            }
        }
    }

    private static class TreePos<K extends Comparable<K>> {
        Node<K> node;
        int pos;

        TreePos(Node<K> node) {
            this.node = node;
        }
    }
}

