/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.Stack;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.Flag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPersistentHashSet<K>
implements Iterable<K> {
    static final Object[] EMPTY_TABLE = new Object[0];
    static final RootTableNode EMPTY_ROOT = new RootTableNode(0, EMPTY_TABLE, 0);
    static final int BITS_PER_TABLE = 5;
    static final int BITS_IN_HASH = 32;

    AbstractPersistentHashSet() {
    }

    @NotNull
    abstract RootTableNode<K> getRoot();

    public final boolean contains(K key) {
        return this.getKey(key) != null;
    }

    @Nullable
    public final K getKey(K key) {
        return this.getRoot().getKey(key, key.hashCode(), 0);
    }

    public final boolean isEmpty() {
        return this.getRoot().getMask() == 0;
    }

    public final int size() {
        return this.getRoot().getSize();
    }

    @Override
    public final Iterator<K> iterator() {
        RootTableNode<K> root = this.getRoot();
        return root.getMask() == 0 ? Collections.EMPTY_LIST.iterator() : new Itr<K>(root);
    }

    static class HashCollisionNode<K>
    implements Node<K> {
        private final K[] keys;

        HashCollisionNode(K ... keys) {
            this.keys = keys;
        }

        @Override
        @NotNull
        public Node<K> insert(@NotNull K key, int hash, int offset, Flag flag) {
            if (key == null) {
                HashCollisionNode.$$$reportNull$$$0(0);
            }
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                Object[] newKeys = (Object[])this.keys.clone();
                newKeys[i] = key;
                HashCollisionNode<Object> hashCollisionNode = new HashCollisionNode<Object>(newKeys);
                if (hashCollisionNode == null) {
                    HashCollisionNode.$$$reportNull$$$0(1);
                }
                return hashCollisionNode;
            }
            K[] newKeys = Arrays.copyOf(this.keys, keysLength + 1);
            newKeys[keysLength] = key;
            flag.flag();
            HashCollisionNode<K> hashCollisionNode = new HashCollisionNode<K>(newKeys);
            if (hashCollisionNode == null) {
                HashCollisionNode.$$$reportNull$$$0(2);
            }
            return hashCollisionNode;
        }

        @Override
        @Nullable
        public Object remove(@NotNull K key, int hash, int offset) {
            if (key == null) {
                HashCollisionNode.$$$reportNull$$$0(3);
            }
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                if (keysLength == 2) {
                    return this.keys[1 - i];
                }
                Object[] newKeys = new Object[keysLength - 1];
                int k = 0;
                for (int j = 0; j < keysLength; ++j) {
                    if (j == i) continue;
                    newKeys[k++] = this.keys[j];
                }
                return new HashCollisionNode<Object>(newKeys);
            }
            return null;
        }

        @Override
        public K getKey(@NotNull K key, int hash, int offset) {
            if (key == null) {
                HashCollisionNode.$$$reportNull$$$0(4);
            }
            for (K k : this.keys) {
                if (!k.equals(key)) continue;
                return k;
            }
            return null;
        }

        @Override
        public void checkNode(int offset) {
            int keysLength = this.keys.length;
            if (keysLength < 2) {
                throw new RuntimeException("Unnecessary hash collision node of cardinality " + keysLength);
            }
            for (K key : this.keys) {
                if (key != null) continue;
                throw new RuntimeException("Null in collision list");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size) {
            throw new UnsupportedOperationException("Unexpected as root!");
        }

        @Override
        public Object get(int index) {
            return this.keys[index];
        }

        @Override
        public boolean isOut(int index) {
            return index + 1 > this.keys.length;
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (K k : this.keys) {
                procedure.execute(k);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistentHashSet$HashCollisionNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistentHashSet$HashCollisionNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TableNode<K>
    implements Node<K> {
        private final int mask;
        private final Object[] table;

        TableNode(int mask, Object[] table) {
            this.mask = mask;
            this.table = table;
        }

        private TableNode(@NotNull K key1, int hash1, @NotNull K key2, int hash2, int offset) {
            if (key1 == null) {
                TableNode.$$$reportNull$$$0(0);
            }
            if (key2 == null) {
                TableNode.$$$reportNull$$$0(1);
            }
            int subhash2 = TableNode.getSubhash(hash2, offset);
            int subhash1 = TableNode.getSubhash(hash1, offset);
            if (subhash1 == subhash2) {
                this.mask = 1 << subhash1;
                this.table = new Object[]{TableNode.createNode(key1, hash1, key2, hash2, offset + 5)};
            } else {
                this.mask = (1 << subhash2) + (1 << subhash1);
                this.table = subhash1 < subhash2 ? new Object[]{key1, key2} : new Object[]{key2, key1};
            }
        }

        public int getMask() {
            return this.mask;
        }

        @Override
        @NotNull
        public Node<K> insert(@NotNull K key, int hash, int offset, Flag flag) {
            Object result;
            int subhash;
            if (key == null) {
                TableNode.$$$reportNull$$$0(2);
            }
            if ((this.mask & 1 << (subhash = TableNode.getSubhash(hash, offset))) == 0) {
                flag.flag();
                TableNode<K> tableNode = this.cloneAndAdd(key, subhash);
                if (tableNode == null) {
                    TableNode.$$$reportNull$$$0(3);
                }
                return tableNode;
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                result = ((Node)target).insert(key, hash, offset + 5, flag);
            } else if (target.equals(key)) {
                result = key;
            } else {
                flag.flag();
                result = TableNode.createNode(target, key, hash, offset + 5);
            }
            Node node = (Node)this.cloneAndReplace(result, index, offset);
            if (node == null) {
                TableNode.$$$reportNull$$$0(4);
            }
            return node;
        }

        @Override
        @Nullable
        public Object remove(@NotNull K key, int hash, int offset) {
            int subhash;
            if (key == null) {
                TableNode.$$$reportNull$$$0(5);
            }
            if ((this.mask & 1 << (subhash = TableNode.getSubhash(hash, offset))) == 0) {
                return null;
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                Object removed = ((Node)target).remove(key, hash, offset + 5);
                if (removed == null) {
                    return null;
                }
                return this.cloneAndReplace(removed, index, offset);
            }
            return target.equals(key) ? this.cloneAndRemove(subhash, index, offset) : null;
        }

        @Override
        public K getKey(@NotNull K key, int hash, int offset) {
            int subhash;
            if (key == null) {
                TableNode.$$$reportNull$$$0(6);
            }
            if ((this.mask & 1 << (subhash = TableNode.getSubhash(hash, offset))) == 0) {
                return null;
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                return ((Node)target).getKey(key, hash, offset + 5);
            }
            return (K)(target.equals(key) ? target : null);
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (Object target : this.table) {
                if (target instanceof Node) {
                    ((Node)target).forEachKey(procedure);
                    continue;
                }
                procedure.execute(target);
            }
        }

        private TableNode<K> cloneAndAdd(K key, int subhash) {
            int index = this.getPosition(subhash);
            int tableLength = this.table.length;
            Object[] newTable = new Object[tableLength + 1];
            System.arraycopy(this.table, 0, newTable, 0, index);
            System.arraycopy(this.table, index, newTable, index + 1, tableLength - index);
            newTable[index] = key;
            return new TableNode<K>(this.mask + (1 << subhash), newTable);
        }

        @NotNull
        private Object cloneAndReplace(@NotNull Object newChild, int index, int offset) {
            if (newChild == null) {
                TableNode.$$$reportNull$$$0(7);
            }
            int tableLength = this.table.length;
            if (offset != 0 && tableLength == 1 && !(newChild instanceof Node)) {
                Object object = newChild;
                if (object == null) {
                    TableNode.$$$reportNull$$$0(8);
                }
                return object;
            }
            Object[] newTable = Arrays.copyOf(this.table, tableLength);
            newTable[index] = newChild;
            TableNode<K> tableNode = new TableNode<K>(this.mask, newTable);
            if (tableNode == null) {
                TableNode.$$$reportNull$$$0(9);
            }
            return tableNode;
        }

        private Object cloneAndRemove(int subhash, int index, int offset) {
            int size = this.getPosition(32);
            if (size == 1) {
                return new TableNode<K>(0, EMPTY_TABLE);
            }
            if (size == 2) {
                if (offset == 0 || this.table[1 - index] instanceof Node) {
                    return new TableNode<K>(this.mask - (1 << subhash), new Object[]{this.table[1 - index]});
                }
                return this.table[1 - index];
            }
            Object[] newTable = new Object[this.table.length - 1];
            System.arraycopy(this.table, 0, newTable, 0, index);
            System.arraycopy(this.table, index + 1, newTable, index, newTable.length - index);
            return new TableNode<K>(this.mask - (1 << subhash), newTable);
        }

        private int getPosition(int subhash) {
            int m = this.mask & (subhash == 32 ? -1 : (1 << subhash) - 1);
            m -= m >>> 1 & 0x55555555;
            m = (m & 0x33333333) + (m >>> 2 & 0x33333333);
            m = m + (m >>> 4) & 0xF0F0F0F;
            m += m >>> 8;
            return m + (m >>> 16) & 0xFF;
        }

        private static <K> Node<K> createNode(K notHashedKey, K hashedKey, int hash, int offset) {
            return TableNode.createNode(notHashedKey, notHashedKey.hashCode(), hashedKey, hash, offset);
        }

        private static <K> Node<K> createNode(K key1, int hash1, K key2, int hash2, int offset) {
            Object[] table;
            int subhash1 = TableNode.getSubhash(hash1, offset);
            int subhash2 = TableNode.getSubhash(hash2, offset);
            if (subhash2 == subhash1) {
                table = new Object[]{offset + 5 >= 32 ? new HashCollisionNode<Object>(key1, key2) : new TableNode<K>(key1, hash1, key2, hash2, offset + 5)};
            } else {
                Object[] objectArray;
                if (subhash2 < subhash1) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = key2;
                    objectArray = objectArray2;
                    objectArray2[1] = key1;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = key1;
                    objectArray = objectArray3;
                    objectArray3[1] = key2;
                }
                table = objectArray;
            }
            return new TableNode<K>(1 << subhash2 | 1 << subhash1, table);
        }

        private static int getSubhash(int hash, int offset) {
            return hash >>> offset & 0x1F;
        }

        @Override
        public void checkNode(int offset) {
            int tableLength;
            if (offset > 0 && ((tableLength = this.table.length) == 0 || tableLength == 1 && !(this.table[0] instanceof Node))) {
                throw new RuntimeException("unnecessary use of table node");
            }
            int m = this.mask;
            for (Object o : this.table) {
                if (m == 0) {
                    throw new RuntimeException("Inconsistent mask and table");
                }
                m &= m - 1;
                if (o == null) {
                    throw new RuntimeException("Null in table");
                }
                if (!(o instanceof Node)) continue;
                ((Node)o).checkNode(offset + 5);
            }
            if (m != 0) {
                throw new RuntimeException("Inconsistent mask and table");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size) {
            return new RootTableNode(this.mask, this.table, size);
        }

        @Override
        public Object get(int index) {
            return this.table[index];
        }

        @Override
        public boolean isOut(int index) {
            return index + 1 > this.table.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key2";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistentHashSet$TableNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/AbstractPersistentHashSet$TableNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneAndReplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getKey";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneAndReplace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RootTableNode<K>
    extends TableNode<K> {
        private final int size;

        RootTableNode(int mask, Object[] table, int size) {
            super(mask, table);
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class TreePos<K> {
        private final Node<K> node;
        private int index;

        TreePos(Node<K> node) {
            this.node = node;
            this.index = 0;
        }
    }

    static interface Node<K> {
        @NotNull
        public Node<K> insert(@NotNull K var1, int var2, int var3, Flag var4);

        @Nullable
        public Object remove(@NotNull K var1, int var2, int var3);

        @Nullable
        public K getKey(@NotNull K var1, int var2, int var3);

        public void checkNode(int var1);

        public RootTableNode<K> asRoot(int var1);

        public Object get(int var1);

        public boolean isOut(int var1);

        public void forEachKey(ObjectProcedure<K> var1);
    }

    static class Itr<K>
    implements Iterator<K> {
        private final Node<K> startingRoot;
        private Stack<TreePos<K>> stack;
        private boolean hasNext;
        private boolean hasNextValid;

        public Itr(Node<K> startingRoot) {
            this.startingRoot = startingRoot;
        }

        @Override
        public boolean hasNext() {
            TreePos<K> treePos;
            if (this.hasNextValid) {
                return this.hasNext;
            }
            this.hasNextValid = true;
            if (this.stack == null) {
                this.stack = new Stack();
                treePos = new TreePos<K>(this.startingRoot);
                ((TreePos)treePos).index = -1;
                this.stack.push(treePos);
            }
            treePos = this.stack.peek();
            ((TreePos)treePos).index++;
            while (((TreePos)treePos).node.isOut(((TreePos)treePos).index)) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.hasNext = false;
                    return this.hasNext;
                }
                treePos = this.stack.peek();
                ((TreePos)treePos).index++;
            }
            while (true) {
                Object o;
                if (!((o = ((TreePos)treePos).node.get(((TreePos)treePos).index)) instanceof Node)) {
                    this.hasNext = true;
                    return this.hasNext;
                }
                treePos = new TreePos((Node)o);
                this.stack.push(treePos);
            }
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNextValid = false;
            TreePos<K> treePos = this.stack.peek();
            return (K)((TreePos)treePos).node.get(((TreePos)treePos).index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

