/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.LongComparable;
import jetbrains.exodus.core.dataStructures.persistent.LongMapEntry;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.core.dataStructures.persistent.RootHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBitTreeLongMap<V>
implements PersistentLongMap<V> {
    private static final int BITS_PER_ENTRY = 10;
    private static final int ELEMENTS_PER_ENTRY = 1024;
    private static final int MASK = 1023;
    private static final BitSet FAKE_BITS = new BitSet();
    private static final Object[] FAKE_DATA = new Object[0];
    private final Root<V> root;

    public PersistentBitTreeLongMap() {
        this.root = new Root(new Persistent23Tree<Entry>(), 0);
    }

    private PersistentBitTreeLongMap(Root<V> root) {
        this.root = root;
    }

    @Override
    public PersistentLongMap.ImmutableMap<V> beginRead() {
        return new ImmutableMap(((Root)this.root).map.beginRead(), ((Root)this.root).size);
    }

    @Override
    public PersistentLongMap<V> getClone() {
        return new PersistentBitTreeLongMap<V>(this.root.getClone());
    }

    @Override
    public PersistentLongMap.MutableMap<V> beginWrite() {
        return new MutableMap(((Root)this.root).map.beginWrite(), ((Root)this.root).size, this);
    }

    private static long getEntryIndex(long value) {
        return value >> 10;
    }

    @NotNull
    private static Entry makeIndexEntry(long index) {
        Entry entry = new Entry(index, null);
        if (entry == null) {
            PersistentBitTreeLongMap.$$$reportNull$$$0(0);
        }
        return entry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap", "makeIndexEntry"));
    }

    private static final class ReverseItemTailIterator<V>
    implements Iterator<PersistentLongMap.Entry<V>> {
        @NotNull
        private final Iterator<Entry> iterator;
        private final long finishingEntryIndex;
        private final int finishingIndex;
        private Entry currentEntry = null;
        private long currentEntryBase = 0L;
        private int next = -1;

        ReverseItemTailIterator(AbstractPersistent23Tree<Entry> tree, long minKey) {
            this.finishingEntryIndex = PersistentBitTreeLongMap.getEntryIndex(minKey);
            this.iterator = tree.tailReverseIterator(PersistentBitTreeLongMap.makeIndexEntry(this.finishingEntryIndex));
            this.finishingIndex = (int)(minKey & 0x3FFL);
        }

        @Override
        public PersistentLongMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            long key = (long)index + this.currentEntryBase;
            Entry entry = this.currentEntry;
            Object result = entry.data[index];
            int prevIndex = entry.bits.previousSetBit(index - 1);
            this.next = entry.index == this.finishingEntryIndex && prevIndex < this.finishingIndex ? -1 : prevIndex;
            return new LongMapEntry<Object>(key, result);
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                Entry entry = this.iterator.next();
                if (entry.index < this.finishingEntryIndex) {
                    return false;
                }
                int prevIndex = entry.bits.length() - 1;
                if (entry.index == this.finishingEntryIndex && prevIndex < this.finishingIndex) {
                    return false;
                }
                if (prevIndex == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.index << 10;
                this.next = prevIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReverseItemIterator<V>
    implements Iterator<PersistentLongMap.Entry<V>> {
        @NotNull
        private final Iterator<Entry> iterator;
        private Entry currentEntry = null;
        private long currentEntryBase = 0L;
        private int next = -1;

        ReverseItemIterator(AbstractPersistent23Tree<Entry> tree) {
            this.iterator = tree.reverseIterator();
        }

        @Override
        public PersistentLongMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            long key = (long)index + this.currentEntryBase;
            Object result = this.currentEntry.data[index];
            this.next = this.currentEntry.bits.previousSetBit(index - 1);
            return new LongMapEntry<Object>(key, result);
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                Entry entry = this.iterator.next();
                int prevIndex = entry.bits.length() - 1;
                if (prevIndex == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.index << 10;
                this.next = prevIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ItemTailIterator<V>
    implements Iterator<PersistentLongMap.Entry<V>> {
        @NotNull
        private final Iterator<Entry> iterator;
        private final long startingEntryIndex;
        private int startingIndex;
        private Entry currentEntry = null;
        private long currentEntryBase = 0L;
        private int next = -1;

        ItemTailIterator(AbstractPersistent23Tree<Entry> tree, long startingKey) {
            this.startingEntryIndex = PersistentBitTreeLongMap.getEntryIndex(startingKey);
            this.iterator = tree.tailIterator(PersistentBitTreeLongMap.makeIndexEntry(this.startingEntryIndex));
            this.startingIndex = (int)(startingKey & 0x3FFL);
        }

        @Override
        public PersistentLongMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            long key = (long)index + this.currentEntryBase;
            Object result = this.currentEntry.data[index];
            this.next = this.currentEntry.bits.nextSetBit(index + 1);
            return new LongMapEntry<Object>(key, result);
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                int nextIndex;
                Entry entry = this.iterator.next();
                int fromIndex = this.startingIndex;
                if (fromIndex != 0) {
                    if (this.startingEntryIndex != entry.index) {
                        fromIndex = 0;
                    }
                    this.startingIndex = 0;
                }
                if ((nextIndex = entry.bits.nextSetBit(fromIndex)) == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.index << 10;
                this.next = nextIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ItemIterator<V>
    implements Iterator<PersistentLongMap.Entry<V>> {
        @NotNull
        private final Iterator<Entry> iterator;
        private Entry currentEntry = null;
        private long currentEntryBase = 0L;
        private int next = -1;

        ItemIterator(AbstractPersistent23Tree<Entry> tree) {
            this.iterator = tree.iterator();
        }

        @Override
        public PersistentLongMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            long key = (long)index + this.currentEntryBase;
            Object result = this.currentEntry.data[index];
            this.next = this.currentEntry.bits.nextSetBit(index + 1);
            return new LongMapEntry<Object>(key, result);
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                Entry entry = this.iterator.next();
                int nextIndex = entry.bits.nextSetBit(0);
                if (nextIndex == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.index << 10;
                this.next = nextIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Root<V> {
        @NotNull
        private final Persistent23Tree<Entry> map;
        private int size;

        Root(@NotNull Persistent23Tree<Entry> map, int size) {
            if (map == null) {
                Root.$$$reportNull$$$0(0);
            }
            this.map = map;
            this.size = size;
        }

        public Root<V> getClone() {
            return new Root<V>(this.map.getClone(), this.size);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$Root", "<init>"));
        }
    }

    protected static class Entry
    implements LongComparable<Entry> {
        private final long index;
        @NotNull
        private final BitSet bits;
        private final Object[] data;

        public Entry(long min) {
            this.index = min;
            this.data = new Object[1024];
            this.bits = new BitSet(1024);
        }

        public Entry(long min, Entry other) {
            this.index = min;
            if (other != null) {
                this.bits = new BitSet(1024);
                this.bits.or(other.bits);
                this.data = new Object[1024];
                System.arraycopy(other.data, 0, this.data, 0, 1024);
            } else {
                this.bits = FAKE_BITS;
                this.data = FAKE_DATA;
            }
        }

        @Override
        public long getWeight() {
            return this.index;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            long otherMin;
            if (o == null) {
                Entry.$$$reportNull$$$0(0);
            }
            return this.index > (otherMin = o.index) ? 1 : (this.index == otherMin ? 0 : -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$Entry", "compareTo"));
        }
    }

    protected static class MutableMap<V>
    implements PersistentLongMap.MutableMap<V>,
    RootHolder {
        @NotNull
        private Persistent23Tree.MutableTree<Entry> mutableMap;
        private int size;
        private final PersistentBitTreeLongMap baseMap;

        MutableMap(@NotNull Persistent23Tree.MutableTree<Entry> mutableMap, int size, PersistentBitTreeLongMap baseMap) {
            if (mutableMap == null) {
                MutableMap.$$$reportNull$$$0(0);
            }
            this.mutableMap = mutableMap;
            this.size = size;
            this.baseMap = baseMap;
        }

        @Override
        public AbstractPersistent23Tree.RootNode<Entry> getRoot() {
            return this.mutableMap.getRoot();
        }

        @Nullable
        private Entry getEntryByIndex(long index) {
            Object root = this.getRoot();
            if (root == null) {
                return null;
            }
            return (Entry)root.getByWeight(index);
        }

        @Override
        public V get(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongMap.getEntryIndex(key));
            if (entry == null) {
                return null;
            }
            return (V)entry.data[(int)(key & 0x3FFL)];
        }

        @Override
        public boolean containsKey(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongMap.getEntryIndex(key));
            return entry != null && entry.data[(int)(key & 0x3FFL)] != null;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public PersistentLongMap.Entry<V> getMinimum() {
            Entry entry = (Entry)this.mutableMap.getMinimum();
            if (entry == null) {
                return null;
            }
            int index = entry.bits.nextSetBit(0);
            if (index == -1) {
                throw new IllegalStateException("unexpected empty entry");
            }
            return new LongMapEntry<Object>((long)index + (entry.index << 10), entry.data[index]);
        }

        @Override
        @NotNull
        public Iterator<PersistentLongMap.Entry<V>> iterator() {
            ItemIterator itemIterator = new ItemIterator(this.mutableMap);
            if (itemIterator == null) {
                MutableMap.$$$reportNull$$$0(1);
            }
            return itemIterator;
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> reverseIterator() {
            return new ReverseItemIterator(this.mutableMap);
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailEntryIterator(long startingKey) {
            return new ItemTailIterator(this.mutableMap, startingKey);
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailReverseEntryIterator(long startingKey) {
            return new ReverseItemTailIterator(this.mutableMap, startingKey);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void put(long key, @NotNull V v) {
            void value;
            if (v == null) {
                MutableMap.$$$reportNull$$$0(2);
            }
            long index = PersistentBitTreeLongMap.getEntryIndex(key);
            Entry entry = this.getEntryByIndex(index);
            int bitIndex = (int)(key & 0x3FFL);
            if (entry == null) {
                entry = new Entry(index);
                this.mutableMap.add(entry);
                ++this.size;
            } else {
                Entry copy = new Entry(index, entry);
                this.mutableMap.add(copy);
                entry = copy;
                if (!entry.bits.get(bitIndex)) {
                    ++this.size;
                }
            }
            entry.bits.set(bitIndex);
            ((Entry)entry).data[bitIndex] = value;
        }

        @Override
        public V remove(long key) {
            long index = PersistentBitTreeLongMap.getEntryIndex(key);
            Entry entry = this.getEntryByIndex(index);
            if (entry == null) {
                return null;
            }
            int bitIndex = (int)(key & 0x3FFL);
            if (entry.bits.get(bitIndex)) {
                --this.size;
            } else {
                return null;
            }
            Object result = entry.data[bitIndex];
            Entry copy = new Entry(index, entry);
            copy.bits.clear(bitIndex);
            if (copy.bits.isEmpty()) {
                this.mutableMap.exclude(entry);
            } else {
                ((Entry)copy).data[bitIndex] = null;
                this.mutableMap.add(copy);
            }
            return (V)result;
        }

        @Override
        public boolean endWrite() {
            if (!this.mutableMap.endWrite()) {
                return false;
            }
            this.baseMap.root.size = this.size;
            return true;
        }

        @Override
        public void testConsistency() {
            this.mutableMap.testConsistency();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutableMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$MutableMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$MutableMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ImmutableMap<V>
    implements PersistentLongMap.ImmutableMap<V> {
        @NotNull
        protected final AbstractPersistent23Tree<Entry> map;
        protected final int size;

        ImmutableMap(@NotNull AbstractPersistent23Tree<Entry> map, int size) {
            if (map == null) {
                ImmutableMap.$$$reportNull$$$0(0);
            }
            this.map = map;
            this.size = size;
        }

        @Nullable
        private Entry getEntryByIndex(long index) {
            AbstractPersistent23Tree.RootNode<Entry> root = this.map.getRoot();
            if (root == null) {
                return null;
            }
            return (Entry)root.getByWeight(index);
        }

        @Override
        public V get(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongMap.getEntryIndex(key));
            if (entry == null) {
                return null;
            }
            return (V)entry.data[(int)(key & 0x3FFL)];
        }

        @Override
        public boolean containsKey(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongMap.getEntryIndex(key));
            return entry != null && entry.data[(int)(key & 0x3FFL)] != null;
        }

        @Override
        public PersistentLongMap.Entry<V> getMinimum() {
            Entry entry = this.map.getMinimum();
            if (entry == null) {
                return null;
            }
            int index = entry.bits.nextSetBit(0);
            if (index == -1) {
                throw new IllegalStateException("unexpected empty entry");
            }
            return new LongMapEntry<Object>((long)index + (entry.index << 10), entry.data[index]);
        }

        @Override
        @NotNull
        public Iterator<PersistentLongMap.Entry<V>> iterator() {
            ItemIterator itemIterator = new ItemIterator(this.map);
            if (itemIterator == null) {
                ImmutableMap.$$$reportNull$$$0(1);
            }
            return itemIterator;
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> reverseIterator() {
            return new ReverseItemIterator(this.map);
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailEntryIterator(long startingKey) {
            return new ItemTailIterator(this.map, startingKey);
        }

        @Override
        public Iterator<PersistentLongMap.Entry<V>> tailReverseEntryIterator(long startingKey) {
            return new ReverseItemTailIterator(this.map, startingKey);
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$ImmutableMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongMap$ImmutableMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

