/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.LongComparable;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBitTreeLongSet
implements PersistentLongSet {
    private static final int BITS_PER_ENTRY = 10;
    private static final int ELEMENTS_PER_ENTRY = 1024;
    private static final int MASK = 1023;
    @NotNull
    private final Root root;

    public PersistentBitTreeLongSet() {
        this.root = new Root(new Persistent23Tree<Entry>(), 0);
    }

    private PersistentBitTreeLongSet(@NotNull Root root) {
        if (root == null) {
            PersistentBitTreeLongSet.$$$reportNull$$$0(0);
        }
        this.root = root;
    }

    @Override
    public PersistentLongSet.ImmutableSet beginRead() {
        return new ImmutableSet(this.root.map.beginRead(), this.root.size);
    }

    @Override
    public PersistentLongSet getClone() {
        return new PersistentBitTreeLongSet(this.root.getClone());
    }

    @Override
    public PersistentLongSet.MutableSet beginWrite() {
        return new MutableSet(this.root.map.beginWrite(), this.root.size, this);
    }

    private static long getEntryIndex(long value) {
        return value >> 10;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet", "<init>"));
    }

    private static final class ItemIterator
    implements LongIterator {
        @NotNull
        private final Iterator<Entry> iterator;
        private Entry currentEntry = null;
        private long currentEntryBase = 0L;
        private int next = -1;

        ItemIterator(AbstractPersistent23Tree<Entry> tree) {
            this.iterator = tree.iterator();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            long result = (long)index + this.currentEntryBase;
            this.next = this.currentEntry.bits.nextSetBit(index + 1);
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                Entry entry = this.iterator.next();
                int nextIndex = entry.bits.nextSetBit(0);
                if (nextIndex == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.index << 10;
                this.next = nextIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Root {
        @NotNull
        private final Persistent23Tree<Entry> map;
        private int size;

        Root(@NotNull Persistent23Tree<Entry> map, int size) {
            if (map == null) {
                Root.$$$reportNull$$$0(0);
            }
            this.map = map;
            this.size = size;
        }

        public Root getClone() {
            return new Root(this.map.getClone(), this.size);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Root", "<init>"));
        }
    }

    protected static class Entry
    implements LongComparable<Entry> {
        private final long index;
        @NotNull
        private final BitSet bits;

        public Entry(long index) {
            this.index = index;
            this.bits = new BitSet(1024);
        }

        private Entry(long index, Entry other) {
            this.index = index;
            this.bits = new BitSet(1024);
            this.bits.or(other.bits);
        }

        @Override
        public long getWeight() {
            return this.index;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            long otherMin;
            if (o == null) {
                Entry.$$$reportNull$$$0(0);
            }
            return this.index > (otherMin = o.index) ? 1 : (this.index == otherMin ? 0 : -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry", "compareTo"));
        }
    }

    protected static class MutableSet
    implements PersistentLongSet.MutableSet {
        @NotNull
        private final Persistent23Tree.MutableTree<Entry> mutableSet;
        private int size;
        private final PersistentBitTreeLongSet baseSet;

        MutableSet(@NotNull Persistent23Tree.MutableTree<Entry> mutableSet, int size, PersistentBitTreeLongSet baseSet) {
            if (mutableSet == null) {
                MutableSet.$$$reportNull$$$0(0);
            }
            this.mutableSet = mutableSet;
            this.size = size;
            this.baseSet = baseSet;
        }

        AbstractPersistent23Tree.RootNode<Entry> getRoot() {
            return this.mutableSet.getRoot();
        }

        @Nullable
        private Entry getEntryByIndex(long index) {
            AbstractPersistent23Tree.RootNode<Entry> root = this.getRoot();
            if (root == null) {
                return null;
            }
            return (Entry)root.getByWeight(index);
        }

        @Override
        public boolean contains(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongSet.getEntryIndex(key));
            return entry != null && entry.bits.get((int)(key & 0x3FFL));
        }

        @Override
        public LongIterator longIterator() {
            return new ItemIterator(this.mutableSet);
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(long key) {
            long index = PersistentBitTreeLongSet.getEntryIndex(key);
            Entry entry = this.getEntryByIndex(index);
            int bitIndex = (int)(key & 0x3FFL);
            if (entry == null) {
                entry = new Entry(index);
                this.mutableSet.add(entry);
                ++this.size;
            } else {
                if (entry.bits.get(bitIndex)) {
                    return;
                }
                Entry copy = new Entry(index, entry);
                this.mutableSet.add(copy);
                entry = copy;
                ++this.size;
            }
            entry.bits.set(bitIndex);
        }

        @Override
        public boolean remove(long key) {
            long index = PersistentBitTreeLongSet.getEntryIndex(key);
            Entry entry = this.getEntryByIndex(index);
            if (entry == null) {
                return false;
            }
            int bitIndex = (int)(key & 0x3FFL);
            if (entry.bits.get(bitIndex)) {
                --this.size;
            } else {
                return false;
            }
            Entry copy = new Entry(index, entry);
            copy.bits.clear(bitIndex);
            if (copy.bits.isEmpty()) {
                this.mutableSet.exclude(entry);
            } else {
                this.mutableSet.add(copy);
            }
            return true;
        }

        @Override
        public boolean endWrite() {
            if (!this.mutableSet.endWrite()) {
                return false;
            }
            this.baseSet.root.size = this.size;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableSet", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$MutableSet", "<init>"));
        }
    }

    protected static class ImmutableSet
    implements PersistentLongSet.ImmutableSet {
        @NotNull
        protected final AbstractPersistent23Tree<Entry> map;
        protected final int size;

        ImmutableSet(@NotNull AbstractPersistent23Tree<Entry> map, int size) {
            if (map == null) {
                ImmutableSet.$$$reportNull$$$0(0);
            }
            this.map = map;
            this.size = size;
        }

        @Nullable
        private Entry getEntryByIndex(long index) {
            AbstractPersistent23Tree.RootNode<Entry> root = this.map.getRoot();
            if (root == null) {
                return null;
            }
            return (Entry)root.getByWeight(index);
        }

        @Override
        public boolean contains(long key) {
            Entry entry = this.getEntryByIndex(PersistentBitTreeLongSet.getEntryIndex(key));
            return entry != null && entry.bits.get((int)(key & 0x3FFL));
        }

        @Override
        public LongIterator longIterator() {
            return new ItemIterator(this.map);
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$ImmutableSet", "<init>"));
        }
    }
}

