/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.hash.PairProcedure;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentLinkedHashMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentLinkedHashMap.class);
    @Nullable
    private volatile Root<K, V> root;
    @Nullable
    private final RemoveEldestFunction<K, V> removeEldest;

    public PersistentLinkedHashMap() {
        this.root = null;
        this.removeEldest = null;
    }

    public PersistentLinkedHashMap(@Nullable RemoveEldestFunction<K, V> removeEldest) {
        this.root = null;
        this.removeEldest = removeEldest;
    }

    private PersistentLinkedHashMap(@NotNull PersistentLinkedHashMap<K, V> source, @Nullable RemoveEldestFunction<K, V> removeEldest) {
        if (source == null) {
            PersistentLinkedHashMap.$$$reportNull$$$0(0);
        }
        Root<K, V> sourceRoot = source.root;
        this.root = sourceRoot == null ? new Root() : new Root(sourceRoot);
        this.removeEldest = removeEldest;
    }

    public int size() {
        Root<K, V> root = this.root;
        return root == null ? 0 : ((Root)root).map.getCurrent().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public PersistentLinkedHashMap<K, V> getClone() {
        return new PersistentLinkedHashMap<K, V>(this, this.removeEldest);
    }

    public PersistentLinkedHashMap<K, V> getClone(@Nullable RemoveEldestFunction<K, V> removeEldestFunction) {
        return new PersistentLinkedHashMap<K, V>(this, removeEldestFunction);
    }

    public PersistentLinkedHashMapMutable<K, V> beginWrite() {
        return new PersistentLinkedHashMapMutable(this);
    }

    public boolean endWrite(@NotNull PersistentLinkedHashMapMutable<K, V> mutableMap) {
        if (mutableMap == null) {
            PersistentLinkedHashMap.$$$reportNull$$$0(1);
        }
        if (!mutableMap.isDirty() || this.root != null && ((PersistentLinkedHashMapMutable)mutableMap).root != this.root) {
            return false;
        }
        boolean result = mutableMap.endWrite();
        this.root = new Root(((PersistentLinkedHashMapMutable)mutableMap).root.map, ((PersistentLinkedHashMapMutable)mutableMap).root.queue, ((PersistentLinkedHashMapMutable)mutableMap).order);
        return result;
    }

    static void logMapIsInconsistent() {
        logger.error("PersistentLinkedHashMap is inconsistent", new Throwable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutableMap";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentLinkedHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "endWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InternalValue<V> {
        private final long order;
        private final V value;

        InternalValue(long order, V value) {
            this.order = order;
            this.value = value;
        }

        public long getOrder() {
            return this.order;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static class Root<K, V> {
        @NotNull
        private final PersistentHashMap<K, InternalValue<V>> map;
        @NotNull
        private final PersistentLongMap<K> queue;
        private final long order;

        private Root() {
            this(new PersistentHashMap(), new PersistentLong23TreeMap(), 0L);
        }

        private Root(@NotNull Root<K, V> source) {
            if (source == null) {
                Root.$$$reportNull$$$0(0);
            }
            this(source.map.getClone(), source.queue.getClone(), source.order);
        }

        private Root(@NotNull PersistentHashMap<K, InternalValue<V>> map, @NotNull PersistentLongMap<K> queue, long order) {
            if (map == null) {
                Root.$$$reportNull$$$0(1);
            }
            if (queue == null) {
                Root.$$$reportNull$$$0(2);
            }
            this.map = map;
            this.queue = queue;
            this.order = order;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "map";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "queue";
                    break;
                }
            }
            objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentLinkedHashMap$Root";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RemoveEldestFunction<K, V> {
        public boolean removeEldest(@NotNull PersistentLinkedHashMapMutable<K, V> var1, @NotNull K var2, @Nullable V var3);
    }

    public static class PersistentLinkedHashMapMutable<K, V>
    implements Iterable<Pair<K, V>> {
        @NotNull
        private final Root<K, V> root;
        private long order;
        @Nullable
        private final RemoveEldestFunction<K, V> removeEldest;
        @NotNull
        private final PersistentHashMap.MutablePersistentHashMap mapMutable;
        @NotNull
        private final PersistentLongMap.MutableMap<K> queueMutable;
        private boolean isDirty;

        public PersistentLinkedHashMapMutable(@NotNull PersistentLinkedHashMap<K, V> source) {
            if (source == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(0);
            }
            Root sourceRoot = ((PersistentLinkedHashMap)source).root;
            if (sourceRoot == null) {
                this.root = new Root();
                this.order = 0L;
            } else {
                this.root = sourceRoot;
                this.order = sourceRoot.order;
            }
            this.removeEldest = ((PersistentLinkedHashMap)source).removeEldest;
            this.mapMutable = ((Root)this.root).map.beginWrite();
            this.queueMutable = ((Root)this.root).queue.beginWrite();
            this.isDirty = false;
        }

        @Nullable
        public V get(@NotNull K key) {
            InternalValue internalValue;
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(1);
            }
            if ((internalValue = (InternalValue)this.mapMutable.get(key)) == null) {
                return null;
            }
            Object result = internalValue.getValue();
            long currentOrder = internalValue.getOrder();
            if (((Root)this.root).order > currentOrder + (long)(this.mapMutable.size() >> 1)) {
                this.isDirty = true;
                long newOrder = ++this.order;
                this.mapMutable.put(key, new InternalValue(newOrder, result));
                this.queueMutable.put(newOrder, key);
                this.removeKeyAndCheckConsistency(key, currentOrder);
            }
            return result;
        }

        @Nullable
        public V getValue(@NotNull K key) {
            InternalValue internalValue;
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(2);
            }
            return (internalValue = (InternalValue)this.mapMutable.get(key)) == null ? null : (V)internalValue.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(3);
            }
            return this.mapMutable.get(key) != null;
        }

        public void put(@NotNull K key, @Nullable V value) {
            InternalValue internalValue;
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(4);
            }
            if ((internalValue = (InternalValue)this.mapMutable.get(key)) != null) {
                this.removeKeyAndCheckConsistency(key, internalValue.getOrder());
            }
            this.isDirty = true;
            long newOrder = ++this.order;
            this.mapMutable.put(key, new InternalValue<V>(newOrder, value));
            this.queueMutable.put(newOrder, key);
            if (this.removeEldest != null) {
                Object eldestKey;
                PersistentLongMap.Entry min;
                int removed;
                for (removed = 0; (min = this.queueMutable.getMinimum()) != null && removed < 50 && this.removeEldest.removeEldest(this, eldestKey = min.getValue(), this.getValue(eldestKey)); ++removed) {
                    this.isDirty = true;
                    this.mapMutable.removeKey(eldestKey);
                    this.queueMutable.remove(min.getKey());
                }
                if (removed >= 35 && logger.isWarnEnabled()) {
                    logger.warn("PersistentLinkedHashMap evicted " + removed + " keys during a single put().", new Throwable());
                }
            }
        }

        public V remove(@NotNull K key) {
            InternalValue internalValue;
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(5);
            }
            if ((internalValue = (InternalValue)this.mapMutable.removeKey(key)) != null) {
                this.isDirty = true;
                this.removeKeyAndCheckConsistency(key, internalValue.getOrder());
                return internalValue.getValue();
            }
            return null;
        }

        public int size() {
            return this.mapMutable.size();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void forEachKey(final ObjectProcedure<K> procedure) {
            this.mapMutable.forEachKey(new ObjectProcedure<PersistentHashMap.Entry<K, InternalValue<V>>>(){

                @Override
                public boolean execute(PersistentHashMap.Entry<K, InternalValue<V>> object) {
                    return procedure.execute(object.getKey());
                }
            });
        }

        public void forEachEntry(final PairProcedure<K, V> procedure) {
            this.mapMutable.forEachKey(new ObjectProcedure<PersistentHashMap.Entry<K, InternalValue<V>>>(){

                @Override
                public boolean execute(PersistentHashMap.Entry<K, InternalValue<V>> object) {
                    return procedure.execute(object.getKey(), object.getValue().getValue());
                }
            });
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        @Override
        public Iterator<Pair<K, V>> iterator() {
            final Iterator sourceIt = this.mapMutable.iterator();
            return new Iterator<Pair<K, V>>(){

                @Override
                public boolean hasNext() {
                    return sourceIt.hasNext();
                }

                @Override
                public Pair<K, V> next() {
                    PersistentHashMap.Entry next = (PersistentHashMap.Entry)sourceIt.next();
                    return new Pair(next.getKey(), ((InternalValue)next.getValue()).getValue());
                }

                @Override
                public void remove() {
                    sourceIt.remove();
                }
            };
        }

        boolean endWrite() {
            return this.mapMutable.endWrite() && this.queueMutable.endWrite();
        }

        void checkTip() {
            this.mapMutable.checkTip();
            this.queueMutable.testConsistency();
        }

        private void removeKeyAndCheckConsistency(@NotNull K key, long prevOrder) {
            K keyByOrder;
            if (key == null) {
                PersistentLinkedHashMapMutable.$$$reportNull$$$0(6);
            }
            if (!key.equals(keyByOrder = this.queueMutable.remove(prevOrder))) {
                logger.error("PersistentLinkedHashMap is inconsistent, key = " + key + ", keyByOrder = " + keyByOrder + ", prevOrder = " + prevOrder, new Throwable());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentLinkedHashMap$PersistentLinkedHashMapMutable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeKeyAndCheckConsistency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

