/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.CacheHitRateable;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.hash.PairProcedure;
import jetbrains.exodus.core.dataStructures.persistent.EvictListener;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentObjectCache<K, V>
extends CacheHitRateable {
    private final int size;
    private final int firstGenSizeBound;
    private final int secondGenSizeBound;
    private final AtomicReference<Root<K, V>> root;

    public PersistentObjectCache() {
        this(8192);
    }

    public PersistentObjectCache(int size) {
        this(size, 0.5f);
    }

    public PersistentObjectCache(int size, float secondGenSizeRatio) {
        int n = this.size = size < 4 ? 4 : size;
        if (secondGenSizeRatio < 0.05f) {
            secondGenSizeRatio = 0.05f;
        } else if (secondGenSizeRatio > 0.95f) {
            secondGenSizeRatio = 0.95f;
        }
        this.secondGenSizeBound = (int)((float)size * secondGenSizeRatio);
        this.firstGenSizeBound = size - this.secondGenSizeBound;
        this.root = new AtomicReference();
    }

    protected PersistentObjectCache(@NotNull PersistentObjectCache<K, V> source, @Nullable EvictListener<K, V> listener) {
        if (source == null) {
            PersistentObjectCache.$$$reportNull$$$0(0);
        }
        this.size = source.size;
        this.firstGenSizeBound = source.firstGenSizeBound;
        this.secondGenSizeBound = source.secondGenSizeBound;
        this.root = new AtomicReference<Root<K, Root<K, V>>>(Root.getClone(source.root.get(), listener, this.firstGenSizeBound, this.secondGenSizeBound));
        this.setAttempts(source.getAttempts());
        this.setHits(source.getHits());
    }

    public void clear() {
        this.root.set(null);
    }

    public int size() {
        return this.size;
    }

    public int count() {
        Root<K, V> root = this.getCurrent();
        return root == null ? 0 : root.getFirstGen().size() + root.getSecondGen().size();
    }

    public V get(@NotNull K key) {
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(1);
        }
        return this.tryKey(key);
    }

    public void put(@NotNull K key, @NotNull V x) {
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(2);
        }
        if (x == null) {
            PersistentObjectCache.$$$reportNull$$$0(3);
        }
        this.cacheObject(key, x);
    }

    public V tryKey(@NotNull K key) {
        Object result;
        Root next;
        Root<K, V> current;
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(4);
        }
        this.incAttempts();
        do {
            current = this.getCurrent();
            next = new Root(current, this.firstGenSizeBound, this.secondGenSizeBound);
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable secondGenMutable = secondGen.beginWrite();
            result = secondGenMutable.get(key);
            boolean wereMutations = secondGenMutable.isDirty();
            if (result == null) {
                PersistentLinkedHashMap firstGen = next.getFirstGen();
                PersistentLinkedHashMap.PersistentLinkedHashMapMutable firstGenMutable = firstGen.beginWrite();
                result = firstGenMutable.get(key);
                if (!firstGenMutable.isDirty() && firstGenMutable.size() >= this.firstGenSizeBound >> 1 && result != null) {
                    firstGenMutable.remove(key);
                    secondGenMutable.put(key, result);
                }
                if (firstGenMutable.isDirty()) {
                    wereMutations = true;
                    if (!firstGen.endWrite(firstGenMutable)) {
                        PersistentLinkedHashMap.logMapIsInconsistent();
                    }
                }
            }
            if (!wereMutations) break;
            if (!secondGenMutable.isDirty() || secondGen.endWrite(secondGenMutable)) continue;
            PersistentLinkedHashMap.logMapIsInconsistent();
        } while (!this.root.compareAndSet(current, next));
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    public V getObject(@NotNull K key) {
        Root<K, V> current;
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(5);
        }
        if ((current = this.getCurrent()) == null) {
            return null;
        }
        V result = current.getFirstGen().beginWrite().getValue(key);
        if (result == null) {
            result = current.getSecondGen().beginWrite().getValue(key);
        }
        return result;
    }

    public void cacheObject(@NotNull K key, @NotNull V x) {
        Root next;
        Root<K, V> current;
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(6);
        }
        if (x == null) {
            PersistentObjectCache.$$$reportNull$$$0(7);
        }
        do {
            current = this.getCurrent();
            next = new Root(current, this.firstGenSizeBound, this.secondGenSizeBound);
            PersistentLinkedHashMap firstGen = next.getFirstGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> firstGenMutable = firstGen.beginWrite();
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> secondGenMutable = secondGen.beginWrite();
            if (firstGenMutable.remove(key) == null) {
                secondGenMutable.remove(key);
            }
            if (secondGenMutable.size() < this.secondGenSizeBound >> 1) {
                secondGenMutable.put(key, x);
            } else {
                firstGenMutable.put(key, x);
            }
            if (firstGenMutable.isDirty() && !firstGen.endWrite(firstGenMutable)) {
                PersistentLinkedHashMap.logMapIsInconsistent();
            }
            if (!secondGenMutable.isDirty() || secondGen.endWrite(secondGenMutable)) continue;
            PersistentLinkedHashMap.logMapIsInconsistent();
        } while (!this.root.compareAndSet(current, next));
    }

    public V remove(@NotNull K key) {
        Object result;
        Root next;
        Root<K, V> current;
        if (key == null) {
            PersistentObjectCache.$$$reportNull$$$0(8);
        }
        do {
            PersistentLinkedHashMap firstGen;
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable firstGenMutable;
            if ((result = (firstGenMutable = (firstGen = (next = new Root(current = this.getCurrent(), this.firstGenSizeBound, this.secondGenSizeBound)).getFirstGen()).beginWrite()).remove(key)) != null) {
                if (firstGen.endWrite(firstGenMutable)) continue;
                PersistentLinkedHashMap.logMapIsInconsistent();
                continue;
            }
            PersistentLinkedHashMap secondGen = next.getSecondGen();
            PersistentLinkedHashMap.PersistentLinkedHashMapMutable secondGenMutable = secondGen.beginWrite();
            result = secondGenMutable.remove(key);
            if (result == null) break;
            if (secondGen.endWrite(secondGenMutable)) continue;
            PersistentLinkedHashMap.logMapIsInconsistent();
        } while (!this.root.compareAndSet(current, next));
        return result;
    }

    public void forEachKey(ObjectProcedure<K> procedure) {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.getFirstGen().beginWrite().forEachKey(procedure);
        current.getSecondGen().beginWrite().forEachKey(procedure);
    }

    public void forEachEntry(PairProcedure<K, V> procedure) {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.getFirstGen().beginWrite().forEachEntry(procedure);
        current.getSecondGen().beginWrite().forEachEntry(procedure);
    }

    public Iterator<K> keys() {
        final Root<K, V> current = this.getCurrent();
        if (current == null) {
            return new ArrayList(1).iterator();
        }
        return new Iterator<K>(){
            private Iterator<Pair<K, V>> firstGenIt;
            private Iterator<Pair<K, V>> secondGenIt;
            private K next;
            {
                this.firstGenIt = current.getFirstGen().beginWrite().iterator();
                this.secondGenIt = null;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                this.checkNext();
                return this.next != null;
            }

            @Override
            public K next() {
                this.checkNext();
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("PersistentObjectCache.keys iterator is immutable");
            }

            private void checkNext() {
                if (this.next == null) {
                    if (this.firstGenIt != null) {
                        if (this.firstGenIt.hasNext()) {
                            this.next = this.firstGenIt.next().getFirst();
                            return;
                        }
                        this.firstGenIt = null;
                        this.secondGenIt = current.getSecondGen().beginWrite().iterator();
                    }
                    if (this.secondGenIt != null) {
                        if (this.secondGenIt.hasNext()) {
                            this.next = this.secondGenIt.next().getFirst();
                            return;
                        }
                        this.secondGenIt = null;
                    }
                }
            }
        };
    }

    public Iterator<V> values() {
        Root<K, V> current = this.getCurrent();
        if (current == null) {
            return new ArrayList(1).iterator();
        }
        ArrayList<V> result = new ArrayList<V>();
        for (Pair<K, V> pair : current.getFirstGen().beginWrite()) {
            result.add(pair.getSecond());
        }
        for (Pair<K, V> pair : current.getSecondGen().beginWrite()) {
            result.add(pair.getSecond());
        }
        return result.iterator();
    }

    public PersistentObjectCache<K, V> getClone(@Nullable EvictListener<K, V> listener) {
        return new PersistentObjectCache<K, V>(this, listener);
    }

    private Root<K, V> getCurrent() {
        return this.root.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Root<K, V> {
        @NotNull
        private final PersistentLinkedHashMap<K, V> firstGen;
        @NotNull
        private final PersistentLinkedHashMap<K, V> secondGen;

        private Root(@Nullable Root<K, V> sourceRoot, final int firstGenSizeBound, final int secondGenSizeBound) {
            if (sourceRoot != null) {
                this.firstGen = sourceRoot.firstGen.getClone();
                this.secondGen = sourceRoot.secondGen.getClone();
            } else {
                this.firstGen = new PersistentLinkedHashMap(new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        if (map == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (key == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return map.size() > firstGenSizeBound;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "map";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "key";
                                break;
                            }
                        }
                        objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$1";
                        objectArray[2] = "removeEldest";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.secondGen = new PersistentLinkedHashMap(new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        if (map == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (key == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return map.size() > secondGenSizeBound;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "map";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "key";
                                break;
                            }
                        }
                        objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$2";
                        objectArray[2] = "removeEldest";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }

        public Root(@NotNull PersistentLinkedHashMap<K, V> firstGen, @NotNull PersistentLinkedHashMap<K, V> secondGen) {
            if (firstGen == null) {
                Root.$$$reportNull$$$0(0);
            }
            if (secondGen == null) {
                Root.$$$reportNull$$$0(1);
            }
            this.firstGen = firstGen;
            this.secondGen = secondGen;
        }

        @NotNull
        public PersistentLinkedHashMap<K, V> getFirstGen() {
            PersistentLinkedHashMap<K, V> persistentLinkedHashMap = this.firstGen;
            if (persistentLinkedHashMap == null) {
                Root.$$$reportNull$$$0(2);
            }
            return persistentLinkedHashMap;
        }

        @NotNull
        public PersistentLinkedHashMap<K, V> getSecondGen() {
            PersistentLinkedHashMap<K, V> persistentLinkedHashMap = this.secondGen;
            if (persistentLinkedHashMap == null) {
                Root.$$$reportNull$$$0(3);
            }
            return persistentLinkedHashMap;
        }

        static <K, V> Root<K, V> getClone(@Nullable Root<K, V> sourceRoot, final @Nullable EvictListener<K, V> listener, final int firstGenSizeBound, final int secondGenSizeBound) {
            if (listener == null) {
                PersistentLinkedHashMap.RemoveEldestFunction firstGenEvict = new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        if (map == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (key == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return map.size() > firstGenSizeBound;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "map";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "key";
                                break;
                            }
                        }
                        objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$3";
                        objectArray[2] = "removeEldest";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                PersistentLinkedHashMap.RemoveEldestFunction secondGenEvict = new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                    @Override
                    public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                        if (map == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (key == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return map.size() > secondGenSizeBound;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "map";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "key";
                                break;
                            }
                        }
                        objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$4";
                        objectArray[2] = "removeEldest";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (sourceRoot != null) {
                    return new Root<K, V>(sourceRoot.firstGen.getClone(firstGenEvict), sourceRoot.secondGen.getClone(secondGenEvict));
                }
                return new Root(new PersistentLinkedHashMap(firstGenEvict), new PersistentLinkedHashMap(secondGenEvict));
            }
            PersistentLinkedHashMap.RemoveEldestFunction firstGenEvict = new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                @Override
                public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                    if (map == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (key == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (map.size() > firstGenSizeBound) {
                        listener.onEvict(key, value);
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "map";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "key";
                            break;
                        }
                    }
                    objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$5";
                    objectArray[2] = "removeEldest";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PersistentLinkedHashMap.RemoveEldestFunction secondGenEvict = new PersistentLinkedHashMap.RemoveEldestFunction<K, V>(){

                @Override
                public boolean removeEldest(@NotNull PersistentLinkedHashMap.PersistentLinkedHashMapMutable<K, V> map, @NotNull K key, @Nullable V value) {
                    if (map == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (key == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (map.size() > secondGenSizeBound) {
                        listener.onEvict(key, value);
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "map";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "key";
                            break;
                        }
                    }
                    objectArray[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root$6";
                    objectArray[2] = "removeEldest";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (sourceRoot != null) {
                return new Root<K, V>(sourceRoot.firstGen.getClone(firstGenEvict), sourceRoot.secondGen.getClone(secondGenEvict));
            }
            return new Root(new PersistentLinkedHashMap(firstGenEvict), new PersistentLinkedHashMap(secondGenEvict));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstGen";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondGen";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache$Root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstGen";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondGen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

