/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.skiplists;

import jetbrains.exodus.core.dataStructures.skiplists.SkipListBase;
import org.jetbrains.annotations.Nullable;

public class LongSkipList
extends SkipListBase {
    private final SkipListInternalNode root = new SkipListInternalNode(Long.MIN_VALUE);
    private SkipListNode[] prevList;

    public LongSkipList() {
        this.clear();
    }

    public void clear() {
        this.root.setNext(null);
        this.root.setNexts(new SkipListNode[]{null, null, null});
        this.prevList = new SkipListNode[]{this.root, this.root, this.root, this.root};
        this.size = 0;
    }

    public void add(long key) {
        SkipListNode newNode;
        SkipListNode temp;
        SkipListNode next = this.root;
        int level = next.getLevels() - 1;
        SkipListNode[] prevs = this.prevList;
        while (level > 0) {
            while ((temp = next.getNext(level)) != null && key >= temp.getKey()) {
                next = temp;
            }
            prevs[level--] = next;
        }
        while ((temp = next.getNext()) != null && key >= temp.getKey()) {
            next = temp;
        }
        prevs[0] = next;
        SkipListNode prev = prevs[0];
        level = prev != this.root && prev.getLevels() > 1 ? 1 : this.generateQuasiRandomLevel();
        next = prev.getNext();
        switch (level) {
            case 1: {
                newNode = new SkipListBottomNode(key);
                break;
            }
            case 2: {
                newNode = new SkipListLevel2Node(key);
                SkipListNode prev1 = prevs[1];
                newNode.setNext(prev1.getNext(1), 1);
                prev1.setNext(newNode, 1);
                break;
            }
            case 3: {
                newNode = new SkipListLevel3Node(key);
                SkipListNode prev1 = prevs[1];
                newNode.setNext(prev1.getNext(1), 1);
                prev1.setNext(newNode, 1);
                SkipListNode prev2 = prevs[2];
                newNode.setNext(prev2.getNext(2), 2);
                prev2.setNext(newNode, 2);
                break;
            }
            default: {
                SkipListInternalNode internalNode = new SkipListInternalNode(key);
                newNode = internalNode;
                int rootLevels = this.root.getLevels();
                SkipListNode[] nexts = new SkipListNode[level - 1];
                for (int i = 1; i < level && i < rootLevels; ++i) {
                    nexts[i - 1] = prevs[i].getNext(i);
                    prevs[i].setNext(newNode, i);
                }
                internalNode.setNexts(nexts);
                break;
            }
        }
        newNode.setNext(next);
        newNode.setPrev(prev);
        prev.setNext(newNode);
        if (next != null) {
            next.setPrev(newNode);
        }
        this.adjustRootNode(newNode, level);
        ++this.size;
    }

    @Nullable
    public Long getMinimum() {
        SkipListNode node = this.getMinimumNode();
        return node == null ? null : Long.valueOf(node.getKey());
    }

    @Nullable
    public SkipListNode getMinimumNode() {
        return this.size == 0 ? null : this.root.getNext();
    }

    @Nullable
    public Long getMaximum() {
        SkipListNode node = this.getMaximumNode();
        return node == null ? null : Long.valueOf(node.getKey());
    }

    @Nullable
    public SkipListNode getMaximumNode() {
        SkipListInternalNode result = null;
        SkipListNode next = this.root;
        for (int level = ((SkipListNode)next).getLevels() - 1; level >= 0; --level) {
            SkipListNode temp;
            while ((temp = ((SkipListNode)next).getNext(level)) != null) {
                next = temp;
            }
            result = next;
        }
        return result == this.root ? null : result;
    }

    public SkipListNode getNext(SkipListNode node) {
        return node.getNext();
    }

    public SkipListNode getPrevious(SkipListNode node) {
        SkipListNode prev = node.getPrev();
        return prev == this.root ? null : prev;
    }

    @Nullable
    public SkipListNode search(long key) {
        long tempKey;
        SkipListNode temp;
        SkipListNode next = this.root;
        block0: for (int level = ((SkipListNode)next).getLevels() - 1; level > 0; --level) {
            while ((temp = ((SkipListNode)next).getNext(level)) != null) {
                tempKey = temp.getKey();
                if (key == tempKey) {
                    return temp;
                }
                if (key < tempKey) continue block0;
                next = temp;
            }
        }
        while ((temp = next.getNext()) != null) {
            tempKey = temp.getKey();
            if (key == tempKey) {
                return temp;
            }
            if (key < tempKey) break;
            next = temp;
        }
        return null;
    }

    public boolean remove(long key) {
        long tempKey;
        SkipListNode temp;
        int level;
        SkipListNode next = this.root;
        SkipListNode[] prevs = this.prevList;
        SkipListNode foundNode = null;
        block0: for (level = next.getLevels() - 1; level > 0; --level) {
            while (true) {
                prevs[level] = next;
                temp = next.getNext(level);
                if (temp == null) continue block0;
                tempKey = temp.getKey();
                if (key <= tempKey) {
                    if (key != tempKey) continue block0;
                    foundNode = temp;
                    continue block0;
                }
                next = temp;
            }
        }
        while (true) {
            prevs[0] = next;
            temp = next.getNext();
            if (temp == null) break;
            tempKey = temp.getKey();
            if (key <= tempKey) {
                if (key != tempKey) break;
                foundNode = temp;
                break;
            }
            next = temp;
        }
        if (foundNode != null) {
            level = foundNode.getLevels();
            for (int i = 1; i < level; ++i) {
                prevs[i].setNext(foundNode.getNext(i), i);
            }
            next = foundNode.getNext();
            SkipListNode prev = prevs[0];
            prev.setNext(next);
            if (next != null) {
                next.setPrev(prev);
            }
            if (--this.size == 0) {
                this.clear();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public SkipListNode getGreaterOrEqual(long key) {
        long tempKey;
        SkipListNode temp;
        SkipListNode next = this.root;
        block0: for (int level = ((SkipListNode)next).getLevels() - 1; level > 0; --level) {
            while ((temp = ((SkipListNode)next).getNext(level)) != null) {
                tempKey = temp.getKey();
                if (key == tempKey) {
                    return this.getMostLeftEqualNode(temp);
                }
                if (key < tempKey) continue block0;
                next = temp;
            }
        }
        while ((temp = next.getNext()) != null) {
            tempKey = temp.getKey();
            if (key == tempKey) {
                return this.getMostLeftEqualNode(temp);
            }
            if (key < tempKey) break;
            next = temp;
        }
        return next.getNext();
    }

    @Nullable
    public SkipListNode getLessOrEqual(long key) {
        long tempKey;
        SkipListNode temp;
        SkipListNode next = this.root;
        block0: for (int level = ((SkipListNode)next).getLevels() - 1; level >= 0; --level) {
            while ((temp = ((SkipListNode)next).getNext(level)) != null) {
                tempKey = temp.getKey();
                if (key == tempKey) {
                    return this.getMostLeftEqualNode(temp);
                }
                if (key < tempKey) continue block0;
                next = temp;
            }
        }
        while ((temp = next.getNext()) != null) {
            tempKey = temp.getKey();
            if (key == tempKey) {
                return this.getMostLeftEqualNode(temp);
            }
            if (key < tempKey) break;
            next = temp;
        }
        return next == this.root ? null : next;
    }

    private void adjustRootNode(SkipListNode node, int level) {
        SkipListInternalNode root = this.root;
        int rootLevels = root.getLevels();
        if (rootLevels < level) {
            int i;
            this.prevList = new SkipListNode[level];
            SkipListNode[] newRootNexts = new SkipListNode[level - 1];
            for (i = 1; i < rootLevels; ++i) {
                newRootNexts[i - 1] = root.getNext(i);
            }
            while (i < newRootNexts.length + 1) {
                newRootNexts[i - 1] = node;
                ++i;
            }
            root.setNexts(newRootNexts);
        }
    }

    private SkipListNode getMostLeftEqualNode(SkipListNode node) {
        SkipListNode result;
        SkipListNode prev = node;
        long key = node.getKey();
        do {
            result = prev;
        } while ((prev = prev.getPrev()) != this.root && prev.getKey() == key);
        return result;
    }

    private static final class SkipListLevel3Node
    extends SkipListNode {
        private SkipListNode next2;
        private SkipListNode next3;

        private SkipListLevel3Node(long key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 3;
        }

        @Override
        protected SkipListNode getNext(int level) {
            switch (level) {
                case 2: {
                    return this.next3;
                }
                case 1: {
                    return this.next2;
                }
                case 0: {
                    return this.getNext();
                }
            }
            SkipListLevel3Node.throwBadLevel();
            return null;
        }

        @Override
        protected void setNext(SkipListNode next, int level) {
            switch (level) {
                case 2: {
                    this.next3 = next;
                    break;
                }
                case 1: {
                    this.next2 = next;
                    break;
                }
                case 0: {
                    this.setNext(next);
                    break;
                }
                default: {
                    SkipListLevel3Node.throwBadLevel();
                }
            }
        }

        private static void throwBadLevel() {
            throw new IllegalArgumentException("SkipListLevel3Node: level can only be equal to 0, 1 or 2.");
        }
    }

    private static final class SkipListLevel2Node
    extends SkipListNode {
        private SkipListNode next2;

        private SkipListLevel2Node(long key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 2;
        }

        @Override
        protected SkipListNode getNext(int level) {
            if (level == 1) {
                return this.next2;
            }
            if (level == 0) {
                return this.getNext();
            }
            SkipListLevel2Node.throwBadLevel();
            return null;
        }

        @Override
        protected void setNext(SkipListNode next, int level) {
            if (level == 1) {
                this.next2 = next;
            } else if (level == 0) {
                this.setNext(next);
            } else {
                SkipListLevel2Node.throwBadLevel();
            }
        }

        private static void throwBadLevel() {
            throw new IllegalArgumentException("SkipListLevel2Node: level can only be equal to 0 or 1.");
        }
    }

    private static final class SkipListBottomNode
    extends SkipListNode {
        private SkipListBottomNode(long key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return 1;
        }

        @Override
        protected SkipListNode getNext(int level) {
            SkipListBottomNode.checkLevel(level);
            return this.getNext();
        }

        @Override
        protected void setNext(SkipListNode next, int level) {
            SkipListBottomNode.checkLevel(level);
            this.setNext(next);
        }

        private static void checkLevel(int level) {
            if (level != 0) {
                throw new IllegalArgumentException("SkipListBottomNode: level can only be equal to 0.");
            }
        }
    }

    private static final class SkipListInternalNode
    extends SkipListNode {
        private SkipListNode[] nexts;

        private SkipListInternalNode(long key) {
            super(key);
        }

        @Override
        protected int getLevels() {
            return this.nexts.length + 1;
        }

        @Override
        protected SkipListNode getNext(int level) {
            return level == 0 ? this.getNext() : this.nexts[level - 1];
        }

        @Override
        protected void setNext(SkipListNode next, int level) {
            if (level == 0) {
                this.setNext(next);
            } else {
                this.nexts[level - 1] = next;
            }
        }

        private void setNexts(SkipListNode[] nexts) {
            this.nexts = nexts;
        }
    }

    public static abstract class SkipListNode {
        private final long key;
        private SkipListNode prev;
        private SkipListNode next;

        protected SkipListNode(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        protected abstract int getLevels();

        protected abstract SkipListNode getNext(int var1);

        protected abstract void setNext(SkipListNode var1, int var2);

        protected final SkipListNode getPrev() {
            return this.prev;
        }

        protected final void setPrev(SkipListNode prev) {
            this.prev = prev;
        }

        protected final SkipListNode getNext() {
            return this.next;
        }

        protected final void setNext(@Nullable SkipListNode next) {
            this.next = next;
        }
    }
}

