/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingJobProcessor<T extends JobProcessorAdapter>
extends JobProcessorAdapter {
    protected final T delegate;

    public DelegatingJobProcessor(@NotNull T delegate) {
        if (delegate == null) {
            DelegatingJobProcessor.$$$reportNull$$$0(0);
        }
        this.delegate = delegate;
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.delegate.start();
            this.finished.set(false);
            Job startJob = new Job(){

                @Override
                protected void execute() throws Throwable {
                    DelegatingJobProcessor.this.processorStarted();
                }
            };
            startJob.setProcessor(this);
            ((JobProcessorAdapter)this.delegate).queue(startJob, Priority.highest);
        }
    }

    @Override
    public void finish() {
        if (this.started.get() && !this.finished.getAndSet(true)) {
            ((JobProcessorAdapter)this.delegate).waitForLatchJob(new LatchJob(){

                @Override
                protected void execute() throws Throwable {
                    try {
                        DelegatingJobProcessor.this.processorFinished();
                    }
                    catch (Throwable t) {
                        JobProcessorExceptionHandler exceptionHandler = DelegatingJobProcessor.this.getExceptionHandler();
                        if (exceptionHandler != null) {
                            exceptionHandler.handle(DelegatingJobProcessor.this, this, t);
                        }
                    }
                    finally {
                        this.release();
                    }
                }
            }, 100L);
            this.setExceptionHandler(null);
            this.started.set(false);
        }
    }

    @Override
    public int pendingJobs() {
        return this.delegate.pendingJobs();
    }

    @Override
    public void waitForJobs(long spinTimeout) {
        ((JobProcessorAdapter)this.delegate).waitForJobs(spinTimeout);
    }

    @Override
    public void waitForTimedJobs(long spinTimeout) {
        ((JobProcessorAdapter)this.delegate).waitForTimedJobs(spinTimeout);
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return this.delegate.getCurrentJob();
    }

    @Override
    public long getCurrentJobStartedAt() {
        return this.delegate.getCurrentJobStartedAt();
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        Iterable<Job> iterable = this.delegate.getPendingJobs();
        if (iterable == null) {
            DelegatingJobProcessor.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    @Override
    public int pendingTimedJobs() {
        return this.delegate.pendingTimedJobs();
    }

    public String toString() {
        return "delegating -> " + this.delegate;
    }

    @Override
    protected boolean queueLowest(@NotNull Job job) {
        if (job == null) {
            DelegatingJobProcessor.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        if (job == null) {
            DelegatingJobProcessor.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean push(Job job, Priority priority) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        return ((JobProcessorAdapter)this.delegate).push(job, priority);
    }

    @Override
    protected Job pushAt(Job job, long millis) {
        if (this.isFinished()) {
            return null;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        return ((JobProcessorAdapter)this.delegate).pushAt(job, millis);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/exodus/core/execution/DelegatingJobProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/exodus/core/execution/DelegatingJobProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingJobs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queueLowest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "queueLowestTimed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

