/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Job {
    private JobProcessor processor;
    private boolean wasQueued;
    @Nullable
    private JobHandler[] jobStartingHandlers;
    @Nullable
    private JobHandler[] jobFinishedHandlers;

    protected Job() {
        this.processor = null;
        this.wasQueued = false;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
    }

    protected Job(@NotNull JobProcessor processor) {
        if (processor == null) {
            Job.$$$reportNull$$$0(0);
        }
        this(processor, Priority.normal);
    }

    protected Job(@NotNull JobProcessor processor, @NotNull Priority priority) {
        if (processor == null) {
            Job.$$$reportNull$$$0(1);
        }
        if (priority == null) {
            Job.$$$reportNull$$$0(2);
        }
        this.processor = processor;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
        this.queue(priority);
    }

    public boolean queue(Priority priority) {
        this.wasQueued = this.processor.queue(this, priority);
        return this.wasQueued;
    }

    public JobProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(JobProcessor processor) {
        this.processor = processor;
    }

    public boolean wasQueued() {
        return this.wasQueued;
    }

    public String getName() {
        String name = this.getClass().getSimpleName();
        return name.isEmpty() ? "<anonymous>" : name;
    }

    public String getGroup() {
        return this.getClass().getName();
    }

    public void registerJobStartingHandler(@NotNull JobHandler handler) {
        if (handler == null) {
            Job.$$$reportNull$$$0(3);
        }
        this.jobStartingHandlers = JobHandler.append(this.jobStartingHandlers, handler);
    }

    public void registerJobFinishedHandler(@NotNull JobHandler handler) {
        if (handler == null) {
            Job.$$$reportNull$$$0(4);
        }
        this.jobFinishedHandlers = JobHandler.append(this.jobFinishedHandlers, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run(@Nullable JobProcessorExceptionHandler handler) {
        Throwable exception = null;
        JobHandler.invokeHandlers(this.jobStartingHandlers, this);
        try {
            this.execute();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            JobHandler.invokeHandlers(this.jobFinishedHandlers, this);
        }
        if (exception != null && handler != null) {
            handler.handle(this.processor, this, exception);
        }
    }

    public final boolean equals(Object job) {
        if (job == this) {
            return true;
        }
        return job != null && this.getClass() == job.getClass() && this.isEqualTo((Job)job);
    }

    public boolean isEqualTo(Job job) {
        return super.equals(job);
    }

    protected abstract void execute() throws Throwable;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/execution/Job";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerJobStartingHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerJobFinishedHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

