/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobProcessorAdapter
implements JobProcessor {
    protected final AtomicBoolean started;
    protected final AtomicBoolean finished;
    @Nullable
    protected JobProcessorExceptionHandler exceptionHandler;
    @Nullable
    protected JobHandler[] jobStartingHandlers;
    @Nullable
    protected JobHandler[] jobFinishedHandlers;
    @NotNull
    private final Semaphore suspendSemaphore;
    @NotNull
    private final SuspendLatchJob suspendLatchJob = new SuspendLatchJob();
    @NotNull
    private final ResumeLatchJob resumeLatchJob = new ResumeLatchJob();
    @NotNull
    private final WaitJob waitJob = new WaitJob();
    @NotNull
    private final WaitJob timedWaitJob = new WaitJob();
    private boolean isSuspended = false;

    protected JobProcessorAdapter() {
        this.started = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(true);
        this.suspendSemaphore = new Semaphore(1, true);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Override
    public void setExceptionHandler(@Nullable JobProcessorExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    @Override
    @Nullable
    public JobProcessorExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public final boolean queue(Job job) {
        return this.push(job, Priority.normal);
    }

    @Override
    public final boolean queue(Job job, Priority priority) {
        return this.push(job, priority);
    }

    @Override
    public final Job queueAt(Job job, long millis) {
        return this.pushAt(job, millis);
    }

    @Override
    public final Job queueIn(Job job, long millis) {
        return this.pushAt(job, System.currentTimeMillis() + millis);
    }

    @Override
    public void finish() {
        this.waitJob.release();
        this.timedWaitJob.release();
    }

    @Override
    public void waitForJobs(long spinTimeout) {
        this.waitForJobs(this.waitJob, false, spinTimeout);
    }

    @Override
    public void waitForTimedJobs(long spinTimeout) {
        this.waitForJobs(this.timedWaitJob, true, spinTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws InterruptedException {
        SuspendLatchJob suspendLatchJob = this.suspendLatchJob;
        synchronized (suspendLatchJob) {
            if (!this.isSuspended) {
                if (this.suspendSemaphore.tryAcquire(0L, TimeUnit.SECONDS)) {
                    if (this.waitForLatchJob(this.suspendLatchJob, 100L)) {
                        this.suspendLatchJob.release();
                    }
                } else {
                    throw new IllegalStateException("Can't acquire suspend semaphore!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws InterruptedException {
        SuspendLatchJob suspendLatchJob = this.suspendLatchJob;
        synchronized (suspendLatchJob) {
            if (this.isSuspended) {
                this.suspendSemaphore.release();
                if (this.waitForLatchJob(this.resumeLatchJob, 100L)) {
                    this.resumeLatchJob.release();
                }
            }
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public void beforeProcessingJob(@NotNull Job job) {
        if (job == null) {
            JobProcessorAdapter.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void afterProcessingJob(@NotNull Job job) {
        if (job == null) {
            JobProcessorAdapter.$$$reportNull$$$0(1);
        }
    }

    protected abstract boolean queueLowest(@NotNull Job var1);

    protected abstract boolean queueLowestTimed(@NotNull Job var1);

    public boolean waitForLatchJob(LatchJob latchJob, long spinTimeout, Priority priority) {
        if (!this.acquireLatchJob(latchJob, spinTimeout)) {
            return false;
        }
        return this.queue(latchJob, priority) && this.acquireLatchJob(latchJob, spinTimeout);
    }

    public boolean waitForLatchJob(LatchJob latchJob, long spinTimeout) {
        return this.waitForLatchJob(latchJob, spinTimeout, Priority.highest);
    }

    protected abstract boolean push(Job var1, Priority var2);

    protected abstract Job pushAt(Job var1, long var2);

    protected void processorStarted() {
    }

    protected void processorFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(@Nullable Job job) {
        JobProcessor processor;
        if (job != null && (processor = job.getProcessor()) != null && !processor.isFinished()) {
            JobProcessorExceptionHandler exceptionHandler = processor.getExceptionHandler();
            try {
                processor.beforeProcessingJob(job);
                JobHandler.invokeHandlers(this.jobStartingHandlers, job);
                try {
                    job.run(exceptionHandler);
                }
                finally {
                    JobHandler.invokeHandlers(this.jobFinishedHandlers, job);
                }
                processor.afterProcessingJob(job);
            }
            catch (Throwable t) {
                if (exceptionHandler != null) {
                    try {
                        exceptionHandler.handle(this, job, t);
                    }
                    catch (Throwable tt) {
                        t.printStackTrace();
                    }
                }
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForJobs(@NotNull LatchJob waitJob, boolean timed, long spinTimeout) {
        if (waitJob == null) {
            JobProcessorAdapter.$$$reportNull$$$0(2);
        }
        LatchJob latchJob = waitJob;
        synchronized (latchJob) {
            try {
                if (!this.acquireLatchJob(waitJob, spinTimeout)) {
                    return;
                }
                if (timed ? this.queueLowestTimed(waitJob) : this.queueLowest(waitJob)) {
                    this.acquireLatchJob(waitJob, spinTimeout);
                }
            }
            finally {
                waitJob.release();
            }
        }
    }

    private boolean acquireLatchJob(@NotNull LatchJob waitJob, long spinTimeout) {
        if (waitJob == null) {
            JobProcessorAdapter.$$$reportNull$$$0(3);
        }
        while (!this.isFinished()) {
            try {
                if (!waitJob.acquire(spinTimeout)) continue;
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitJob";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/execution/JobProcessorAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeProcessingJob";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "afterProcessingJob";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForJobs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "acquireLatchJob";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ResumeLatchJob
    extends LatchJob {
        private ResumeLatchJob() {
        }

        @Override
        protected void execute() {
            JobProcessorAdapter.this.isSuspended = false;
            this.release();
        }

        @Override
        public boolean isEqualTo(Job job) {
            return true;
        }

        public int hashCode() {
            return 239;
        }
    }

    private final class SuspendLatchJob
    extends LatchJob {
        private SuspendLatchJob() {
        }

        @Override
        protected void execute() throws InterruptedException {
            JobProcessorAdapter.this.isSuspended = true;
            this.release();
            JobProcessorAdapter.this.suspendSemaphore.acquire();
            JobProcessorAdapter.this.suspendSemaphore.release();
        }

        @Override
        public boolean isEqualTo(Job job) {
            return true;
        }

        public int hashCode() {
            return 239;
        }
    }

    private static final class WaitJob
    extends LatchJob {
        private WaitJob() {
        }

        @Override
        protected void execute() throws Throwable {
            this.release();
        }
    }
}

