/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.core.dataStructures.ConcurrentStablePriorityQueue;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.PriorityQueue;
import jetbrains.exodus.core.dataStructures.StablePriorityQueue;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.locks.Guard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobProcessorQueueAdapter
extends JobProcessorAdapter {
    public static final String CONCURRENT_QUEUE_PROPERTY = "jetbrains.exodus.core.execution.concurrentQueue";
    private final PriorityQueue<Priority, Job> queue = JobProcessorQueueAdapter.createQueue();
    private final PriorityQueue<Long, Job> timeQueue = JobProcessorQueueAdapter.createQueue();
    private volatile int outdatedJobsCount;
    private volatile Job currentJob;
    private volatile long currentJobStartedAt;
    protected final Semaphore awake = new Semaphore(0);

    protected JobProcessorQueueAdapter() {
    }

    @Override
    protected boolean queueLowest(@NotNull Job job) {
        if (job == null) {
            JobProcessorQueueAdapter.$$$reportNull$$$0(0);
        }
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        try (Guard ignored = this.queue.lock();){
            Priority priority;
            Pair<Priority, Job> pair = this.queue.floorPair();
            Priority priority2 = priority = pair == null ? Priority.highest : pair.getFirst();
            if (this.queue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        this.awake.release();
        return true;
    }

    @Override
    protected boolean push(Job job, Priority priority) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        try (Guard ignored = this.queue.lock();){
            if (this.queue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        this.awake.release();
        return true;
    }

    @Override
    protected Job pushAt(Job job, long millis) {
        Pair<Long, Job> pair;
        Job oldJob;
        if (this.isFinished()) {
            return null;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        long priority = Long.MAX_VALUE - millis;
        try (Guard ignored = this.timeQueue.lock();){
            oldJob = this.timeQueue.push(priority, job);
            pair = this.timeQueue.peekPair();
        }
        if (pair != null && pair.getFirst() != priority) {
            return oldJob;
        }
        this.awake.release();
        return oldJob;
    }

    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        if (job == null) {
            JobProcessorQueueAdapter.$$$reportNull$$$0(1);
        }
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        try (Guard ignored = this.timeQueue.lock();){
            long priority;
            Pair<Long, Job> pair = this.timeQueue.floorPair();
            long l = priority = pair == null ? Long.MAX_VALUE - System.currentTimeMillis() : pair.getFirst();
            if (this.timeQueue.push(priority, job) != null) {
                boolean bl = false;
                return bl;
            }
        }
        this.awake.release();
        return true;
    }

    @Override
    public int pendingJobs() {
        return this.queue.size() + (this.currentJob == null ? 0 : 1);
    }

    @Override
    public int pendingTimedJobs() {
        return this.timeQueue.size() + this.outdatedJobsCount;
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return this.currentJob;
    }

    @Override
    public long getCurrentJobStartedAt() {
        return this.currentJobStartedAt;
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        PriorityQueue<Priority, Job> priorityQueue = this.queue;
        if (priorityQueue == null) {
            JobProcessorQueueAdapter.$$$reportNull$$$0(2);
        }
        return priorityQueue;
    }

    protected void doJobs() {
        boolean jobsQueued;
        try {
            jobsQueued = this.waitForJobs();
        }
        catch (InterruptedException e) {
            return;
        }
        if (!this.isFinished()) {
            if (jobsQueued) {
                Job job;
                try (Guard ignored = this.queue.lock();){
                    job = this.queue.pop();
                }
                this.doExecuteJob(job);
            } else {
                this.doTimedJobs();
            }
        }
    }

    protected void clearQueues() {
        this.queue.clear();
        this.timeQueue.clear();
    }

    protected void doTimedJobs() {
        int count;
        ArrayList<Job> outdatedJobs = new ArrayList<Job>();
        long currentTimePriority = Long.MAX_VALUE - System.currentTimeMillis();
        try (Guard ignored = this.timeQueue.lock();){
            Pair<Long, Job> pair = this.timeQueue.peekPair();
            while (pair != null && pair.getFirst() >= currentTimePriority) {
                outdatedJobs.add(this.timeQueue.pop());
                pair = this.timeQueue.peekPair();
            }
            count = outdatedJobs.size();
        }
        this.outdatedJobsCount = count;
        for (Job job : outdatedJobs) {
            this.executeImmediateJobsIfAny();
            if (this.isFinished()) break;
            this.doExecuteJob(job);
            --this.outdatedJobsCount;
        }
    }

    private void executeImmediateJobsIfAny() {
        while (!this.isFinished() && this.executeImmediateJobIfAny() != null) {
        }
    }

    private Job executeImmediateJobIfAny() {
        Job urgentImmediateJob = null;
        try (Guard ignored = this.queue.lock();){
            Pair<Priority, Job> peekPair = this.queue.peekPair();
            if (peekPair != null && peekPair.getFirst() == Priority.highest) {
                urgentImmediateJob = this.queue.pop();
            }
        }
        if (urgentImmediateJob != null) {
            this.doExecuteJob(urgentImmediateJob);
        }
        return urgentImmediateJob;
    }

    protected boolean waitForJobs() throws InterruptedException {
        Pair<Long, Job> peekPair;
        try (Guard ignored = this.timeQueue.lock();){
            peekPair = this.timeQueue.peekPair();
        }
        if (peekPair == null) {
            this.awake.acquire();
            return true;
        }
        long timeout = Long.MAX_VALUE - peekPair.getFirst() - System.currentTimeMillis();
        if (timeout < 0L) {
            return false;
        }
        return this.awake.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    private void doExecuteJob(Job job) {
        this.currentJob = job;
        this.currentJobStartedAt = System.currentTimeMillis();
        try {
            this.executeJob(job);
        }
        finally {
            this.currentJob = null;
            this.currentJobStartedAt = 0L;
        }
    }

    private static PriorityQueue createQueue() {
        return Boolean.getBoolean(CONCURRENT_QUEUE_PROPERTY) ? new ConcurrentStablePriorityQueue() : new StablePriorityQueue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/exodus/core/execution/JobProcessorQueueAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/exodus/core/execution/JobProcessorQueueAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingJobs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queueLowest";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queueLowestTimed";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

