/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.decorators.QueueDecorator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import org.jetbrains.annotations.NotNull;

public class SharedTimer {
    private static int PERIOD = 1000;
    private static final JobProcessor processor = ThreadJobProcessorPool.getOrCreateJobProcessor("Exodus shared timer thread");
    private static final AtomicReference<PersistentHashSet<ExpirablePeriodicTask>> registeredTasks = new AtomicReference(new PersistentHashSet());

    private SharedTimer() {
    }

    public static void registerPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        if (task == null) {
            SharedTimer.$$$reportNull$$$0(0);
        }
        SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

            @Override
            public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                if (mutableTasks == null) {
                    1.$$$reportNull$$$0(0);
                }
                mutableTasks.add(task);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableTasks", "jetbrains/exodus/core/execution/SharedTimer$1", "update"));
            }
        });
    }

    public static void unregisterPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        if (task == null) {
            SharedTimer.$$$reportNull$$$0(1);
        }
        SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

            @Override
            public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                if (mutableTasks == null) {
                    2.$$$reportNull$$$0(0);
                }
                mutableTasks.remove(task);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableTasks", "jetbrains/exodus/core/execution/SharedTimer$2", "update"));
            }
        });
    }

    private static void optimisticUpdateOfTasks(@NotNull TasksUpdater updater) {
        PersistentHashSet<ExpirablePeriodicTask> copy;
        PersistentHashSet<ExpirablePeriodicTask> current;
        if (updater == null) {
            SharedTimer.$$$reportNull$$$0(2);
        }
        do {
            current = registeredTasks.get();
            copy = current.getClone();
            PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks = copy.beginWrite();
            updater.update(mutableTasks);
            mutableTasks.endWrite();
        } while (!registeredTasks.compareAndSet(current, copy));
    }

    static {
        processor.queueIn(new Ticker(), PERIOD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/core/execution/SharedTimer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPeriodicTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterPeriodicTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "optimisticUpdateOfTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Ticker
    extends Job {
        private Ticker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() throws Throwable {
            long nextTick = System.currentTimeMillis() + (long)PERIOD;
            final QueueDecorator<ExpirablePeriodicTask> expiredTasks = new QueueDecorator<ExpirablePeriodicTask>();
            try {
                for (ExpirablePeriodicTask task : (PersistentHashSet)registeredTasks.get()) {
                    if (task.isExpired()) {
                        expiredTasks.add(task);
                        continue;
                    }
                    task.run();
                }
                if (!expiredTasks.isEmpty()) {
                    SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

                        @Override
                        public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                            if (mutableTasks == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            for (ExpirablePeriodicTask expiredTask : expiredTasks) {
                                mutableTasks.remove(expiredTask);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableTasks", "jetbrains/exodus/core/execution/SharedTimer$Ticker$1", "update"));
                        }
                    });
                }
            }
            finally {
                processor.queueAt(this, nextTick);
            }
        }
    }

    private static interface TasksUpdater {
        public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> var1);
    }

    public static interface ExpirablePeriodicTask
    extends Runnable {
        public boolean isExpired();
    }
}

