/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.execution.DefaultExceptionHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import org.jetbrains.annotations.NotNull;

public class ThreadJobProcessorPool {
    private static final Map<String, ThreadJobProcessor> PROCESSORS = new HashMap<String, ThreadJobProcessor>();
    private static final ThreadJobProcessor SPAWNER = new ThreadJobProcessor("threadJobProcessorPoolSpawner");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ThreadJobProcessor getOrCreateJobProcessor(String processorName) {
        ThreadJobProcessor result = PROCESSORS.get(processorName);
        if (result == null) {
            Map<String, ThreadJobProcessor> map = PROCESSORS;
            synchronized (map) {
                result = PROCESSORS.get(processorName);
                if (result == null) {
                    SPAWNER.start();
                    result = new ThreadJobProcessor(processorName, new ThreadJobProcessor.ThreadCreator(){

                        @Override
                        public Thread createThread(final Runnable body, final String name) {
                            final ThreadContainer resultContainer = new ThreadContainer();
                            SPAWNER.waitForLatchJob(new LatchJob(){

                                @Override
                                protected void execute() {
                                    resultContainer.thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                                        @Override
                                        public Thread run() {
                                            return new Thread(body, name);
                                        }
                                    });
                                    this.release();
                                }
                            }, 100L);
                            Thread thread = resultContainer.thread;
                            resultContainer.thread = null;
                            if (thread == null) {
                                throw new IllegalStateException("Can't create JobProcessor thread!");
                            }
                            return thread;
                        }
                    });
                    PROCESSORS.put(processorName, result);
                }
                result.setExceptionHandler(new DefaultExceptionHandler());
                result.start();
            }
        }
        ThreadJobProcessor threadJobProcessor = result;
        if (threadJobProcessor == null) {
            ThreadJobProcessorPool.$$$reportNull$$$0(0);
        }
        return threadJobProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<JobProcessor> getProcessors() {
        Map<String, ThreadJobProcessor> map = PROCESSORS;
        synchronized (map) {
            return new ArrayList<JobProcessor>(PROCESSORS.values());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/exodus/core/execution/ThreadJobProcessorPool", "getOrCreateJobProcessor"));
    }

    private static class ThreadContainer {
        private Thread thread;

        private ThreadContainer() {
        }
    }
}

