/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    public static final int READ_BUFFER_SIZE = 16384;
    public static final ByteArraySpinAllocator BUFFER_ALLOCATOR = new ByteArraySpinAllocator(16384);
    private static final String BLOCK_SIZE = "exodus.io.blockSize";
    private static final File[] NO_FILES = new File[0];

    private IOUtil() {
    }

    public static long getBlockSize() {
        return Long.getLong(BLOCK_SIZE, 4096L);
    }

    public static long getAdjustedFileLength(File file) {
        long blockSize = IOUtil.getBlockSize();
        return (file.length() + blockSize - 1L) / blockSize * blockSize;
    }

    public static long getDirectorySize(File dir, final String extension, boolean recursive) {
        long sum = 0L;
        if (recursive) {
            for (File childDir : IOUtil.listFiles(dir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                sum += IOUtil.getDirectorySize(childDir, extension, recursive);
            }
        }
        for (File file : IOUtil.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        })) {
            sum += IOUtil.getAdjustedFileLength(file);
        }
        return sum;
    }

    public static void copyStreams(@NotNull InputStream source, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator bufferAllocator) throws IOException {
        if (source == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        if (target == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        if (bufferAllocator == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        IOUtil.copyStreams(source, Long.MAX_VALUE, target, bufferAllocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void copyStreams(@NotNull InputStream source, long sourceLen, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator byteArraySpinAllocator) throws IOException {
        void bufferAllocator;
        if (source == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (target == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (byteArraySpinAllocator == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        byte[] buffer = (byte[])bufferAllocator.alloc();
        try {
            int read;
            long totalRead = 0L;
            while (totalRead < sourceLen && (read = source.read(buffer)) >= 0) {
                if (read <= 0) continue;
                read = (int)Math.min(sourceLen - totalRead, (long)read);
                target.write(buffer, 0, read);
                totalRead += (long)read;
            }
        }
        finally {
            bufferAllocator.dispose(buffer);
        }
    }

    public static void deleteRecursively(File dir) {
        for (File file : IOUtil.listFiles(dir)) {
            if (file.isDirectory()) {
                IOUtil.deleteRecursively(file);
            }
            IOUtil.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory) {
        File[] result;
        if (directory == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        File[] fileArray = (result = directory.listFiles()) == null ? NO_FILES : result;
        if (fileArray == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        return fileArray;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FilenameFilter filter) {
        File[] result;
        if (directory == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        File[] fileArray = (result = directory.listFiles(filter)) == null ? NO_FILES : result;
        if (fileArray == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        return fileArray;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FileFilter filter) {
        File[] result;
        if (directory == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        File[] fileArray = (result = directory.listFiles(filter)) == null ? NO_FILES : result;
        if (fileArray == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        return fileArray;
    }

    public static int readFully(@NotNull InputStream input, @NotNull byte[] bytes) throws IOException {
        if (input == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        if (bytes == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        return IOUtil.readFully(input, bytes, bytes.length);
    }

    public static int readFully(@NotNull InputStream input, @NotNull byte[] bytes, int len) throws IOException {
        int off;
        int read;
        if (input == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        if (bytes == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        for (off = 0; off < len && (read = input.read(bytes, off, len - off)) >= 0; off += read) {
        }
        return off;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bufferAllocator";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/exodus/util/IOUtil";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/exodus/util/IOUtil";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "listFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyStreams";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readFully";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

