/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UTFUtil {
    public static final int NULL_STRING_UTF_VALUE = 255;
    private static final int SINGLE_UTF_CHUNK_SIZE = 21845;

    private UTFUtil() {
    }

    public static void writeUTF(@NotNull OutputStream stream, @NotNull String str) throws IOException {
        if (stream == null) {
            UTFUtil.$$$reportNull$$$0(0);
        }
        if (str == null) {
            UTFUtil.$$$reportNull$$$0(1);
        }
        try (DataOutputStream dataStream = new DataOutputStream(stream);){
            int len = str.length();
            if (len < 21845) {
                dataStream.writeUTF(str);
            } else {
                int endIndex;
                int startIndex = 0;
                do {
                    if ((endIndex = startIndex + 21845) > len) {
                        endIndex = len;
                    }
                    dataStream.writeUTF(str.substring(startIndex, endIndex));
                    startIndex += 21845;
                } while (endIndex < len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readUTF(@NotNull InputStream stream) throws IOException {
        ByteArraySizedInputStream sizedStream;
        int streamSize;
        if (stream == null) {
            UTFUtil.$$$reportNull$$$0(2);
        }
        DataInputStream dataInput = new DataInputStream(stream);
        if (stream instanceof ByteArraySizedInputStream && (streamSize = (sizedStream = (ByteArraySizedInputStream)stream).size()) >= 2) {
            sizedStream.mark(Integer.MAX_VALUE);
            int utfLen = dataInput.readUnsignedShort();
            if (utfLen == streamSize - 2) {
                boolean isAscii = true;
                byte[] bytes = sizedStream.toByteArray();
                for (int i = 0; i < utfLen; ++i) {
                    if ((bytes[i + 2] & 0xFF) <= 127) continue;
                    isAscii = false;
                    break;
                }
                if (isAscii) {
                    return UTFUtil.fromAsciiByteArray(bytes, 2, utfLen);
                }
            }
            sizedStream.reset();
        }
        try {
            String result = null;
            StringBuilder builder = null;
            while (true) {
                String temp;
                try {
                    temp = dataInput.readUTF();
                    if (result != null && result.length() == 0 && builder != null && builder.length() == 0 && temp.length() == 0) {
                    }
                }
                catch (EOFException e) {}
                break;
                if (result == null) {
                    result = temp;
                    continue;
                }
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(result);
                }
                builder.append(temp);
            }
            String string = builder != null ? builder.toString() : result;
            return string;
        }
        finally {
            dataInput.close();
        }
    }

    public static String fromAsciiByteArray(@NotNull byte[] bytes, int off, int len) {
        if (bytes == null) {
            UTFUtil.$$$reportNull$$$0(3);
        }
        return new String(bytes, 0, off, len);
    }

    public static int getUtfByteLength(@NotNull String value) {
        if (value == null) {
            UTFUtil.$$$reportNull$$$0(4);
        }
        int len = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++len;
                continue;
            }
            if (c > '\u07ff') {
                len += 3;
                continue;
            }
            len += 2;
        }
        return len;
    }

    public static void utfCharsToBytes(@NotNull String value, byte[] bytes, int offset) {
        if (value == null) {
            UTFUtil.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[offset++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[offset++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[offset++] = (byte)(0x80 | c & 0x3F);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "jetbrains/exodus/util/UTFUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUTF";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readUTF";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fromAsciiByteArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUtfByteLength";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "utfCharsToBytes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

