/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.testutils.container;

import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.globus.gsi.jsse.SSLConfigurator;
import org.globus.gsi.provider.GlobusProvider;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.junit.Assert;
import org.junit.Test;

public abstract class ClientTest {
    public static int getPort() {
        return 5082;
    }

    @Test
    public void testInvalid() throws Exception {
        SSLConfigurator config = this.getConfig("classpath:/invalidkeystore.properties");
        SSLSocketFactory fac = new SSLSocketFactory(config.getSSLContext());
        fac.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        Scheme scheme = new Scheme("https", (SocketFactory)fac, ClientTest.getPort());
        httpclient.getConnectionManager().getSchemeRegistry().register(scheme);
        HttpGet httpget = new HttpGet("https://localhost/");
        System.out.println("executing request" + httpget.getRequestLine());
        try {
            httpclient.execute((HttpUriRequest)httpget);
            Assert.fail();
        }
        catch (SSLPeerUnverifiedException ex) {
            // empty catch block
        }
    }

    private SSLConfigurator getConfig(String credStoreLocation) throws Exception {
        SSLConfigurator config = new SSLConfigurator();
        config.setCrlLocationPattern(null);
        config.setCrlStoreType("PEMFilebasedCertStore");
        config.setCredentialStoreLocation(credStoreLocation);
        config.setCredentialStorePassword("password");
        config.setCredentialStoreType("PEMFilebasedKeyStore");
        config.setTrustAnchorStoreLocation("classpath:/mytruststore.properties");
        config.setTrustAnchorStorePassword("password");
        config.setTrustAnchorStoreType("PEMFilebasedKeyStore");
        ResourceSigningPolicyStoreParameters policyParams = new ResourceSigningPolicyStoreParameters("classpath:/globus_ca.signing_policy");
        ResourceSigningPolicyStore policyStore = new ResourceSigningPolicyStore((SigningPolicyStoreParameters)policyParams);
        config.setPolicyStore((SigningPolicyStore)policyStore);
        return config;
    }

    @Test
    public void testValid() throws Exception {
        SSLConfigurator config = this.getConfig("classpath:/mykeystore.properties");
        SSLSocketFactory fac = new SSLSocketFactory(config.getSSLContext());
        fac.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        Scheme scheme = new Scheme("https", (SocketFactory)fac, ClientTest.getPort());
        httpclient.getConnectionManager().getSchemeRegistry().register(scheme);
        HttpGet httpget = new HttpGet("https://localhost/");
        System.out.println("executing request" + httpget.getRequestLine());
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        System.out.println("----------------------------------------");
        System.out.println(response.getStatusLine());
        if (entity != null) {
            System.out.println("Response content length: " + entity.getContentLength());
        }
        if (entity != null) {
            entity.consumeContent();
        }
        httpclient.getConnectionManager().shutdown();
    }

    static {
        Security.addProvider((Provider)new GlobusProvider());
    }
}

