/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.HostPortList;
import org.globus.ftp.Session;
import org.globus.ftp.exception.ClientException;
import org.ietf.jgss.GSSCredential;

public class GridFTPSession
extends Session {
    public static final int MODE_EBLOCK = 3;
    public static final int SERVER_EPAS = 3;
    public static final int SERVER_EACT = 4;
    public static final int PROTECTION_CLEAR = 1;
    public static final int PROTECTION_SAFE = 2;
    public static final int PROTECTION_CONFIDENTIAL = 3;
    public static final int PROTECTION_PRIVATE = 4;
    public DataChannelAuthentication dataChannelAuthentication = DataChannelAuthentication.SELF;
    public int dataChannelProtection = 1;
    public GSSCredential credential = null;
    public int parallel = 1;
    public int TCPBufferSize = -1;
    public HostPortList serverAddressList = null;

    public GridFTPSession() {
        this.maxWait = 60000;
    }

    public void matches(Session other) throws ClientException {
        this.compareTransferParams(other);
        this.compareServerMode(other);
        if (this.needsGridFTP() && this.transferMode != 3) {
            throw new ClientException(8, "Extended block mode necessary");
        }
        if (other instanceof GridFTPSession && ((GridFTPSession)other).needsGridFTP() && this.transferMode != 3) {
            throw new ClientException(8, "Extended block mode necessary");
        }
    }

    protected void compareServerMode(Session other) throws ClientException {
        if (this.transferMode != 3) {
            super.compareServerMode(other);
        } else if (!(this.serverMode == -1 && other.serverMode == -1 || this.serverMode == 4 && other.serverMode == 3 || this.serverMode == 3 && other.serverMode == 4 || this.serverMode == 2 && other.serverMode == 1 || this.serverMode == 1 && other.serverMode == 2)) {
            throw new ClientException(5, "One server must be active and other must be passive");
        }
    }

    public boolean needsGridFTP() {
        return this.parallel > 1 || this.transferMode == 3 || this.serverMode == 3 || this.serverMode == 4;
    }
}

