/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelReader;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.EBlockAware;
import org.globus.ftp.dc.EBlockImageDCReader;
import org.globus.ftp.dc.EBlockImageDCWriter;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.StreamAsciiDCReader;
import org.globus.ftp.dc.StreamAsciiDCWriter;
import org.globus.ftp.dc.StreamImageDCReader;
import org.globus.ftp.dc.StreamImageDCWriter;
import org.globus.ftp.dc.TransferContext;

public abstract class AbstractDataChannel
implements DataChannel {
    private static Log logger = LogFactory.getLog((String)AbstractDataChannel.class.getName());
    protected Session session;
    protected static Map dataHandlers;
    private static final int SOURCE = 1;
    private static final int SINK = 2;

    public AbstractDataChannel(Session session) {
        this.session = session;
    }

    public static void registerHandler(int transferMode, int transferType, int type, Class clazz) throws Exception {
        switch (type) {
            case 1: {
                if (DataChannelReader.class.isAssignableFrom(clazz)) break;
                throw new Exception("Incorrect type");
            }
            case 2: {
                if (DataChannelWriter.class.isAssignableFrom(clazz)) break;
                throw new Exception("Incorrect type");
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
        String id = AbstractDataChannel.getHandlerID(transferMode, transferType, type);
        if (dataHandlers == null) {
            dataHandlers = new HashMap();
        }
        logger.debug((Object)("registering handler for class " + clazz.toString() + "; id = " + id));
        dataHandlers.put(id, clazz);
    }

    public boolean isDataSourceModeSupported() {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 1);
        return dataHandlers.get(id) != null;
    }

    public boolean isDataSinkModeSupported() {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 2);
        return dataHandlers.get(id) != null;
    }

    public DataChannelReader getDataChannelSource(TransferContext context) throws Exception {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 1);
        logger.debug((Object)("type/mode: " + id));
        Class clazz = (Class)dataHandlers.get(id);
        if (clazz == null) {
            throw new Exception("No data reader for type/mode" + id);
        }
        DataChannelReader reader = (DataChannelReader)clazz.newInstance();
        if (reader instanceof EBlockAware) {
            ((EBlockAware)((Object)reader)).setTransferContext((EBlockParallelTransferContext)context);
        }
        return reader;
    }

    public DataChannelWriter getDataChannelSink(TransferContext context) throws Exception {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 2);
        Class clazz = (Class)dataHandlers.get(id);
        if (clazz == null) {
            throw new Exception("No data reader for type/mode");
        }
        DataChannelWriter writer = (DataChannelWriter)clazz.newInstance();
        if (writer instanceof EBlockAware) {
            ((EBlockAware)((Object)writer)).setTransferContext((EBlockParallelTransferContext)context);
        }
        return writer;
    }

    private static String getHandlerID(int transferMode, int transferType, int type) {
        String id = "";
        switch (transferMode) {
            case 1: {
                id = id + "S-";
                break;
            }
            case 3: {
                id = id + "E-";
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode not supported: " + transferMode);
            }
        }
        switch (transferType) {
            case 1: {
                id = id + "I-";
                break;
            }
            case 2: {
                id = id + "A-";
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + transferType);
            }
        }
        switch (type) {
            case 1: {
                id = id + "R";
                break;
            }
            case 2: {
                id = id + "W";
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
        if (id.equals("")) {
            return null;
        }
        return id;
    }

    static {
        try {
            AbstractDataChannel.registerHandler(1, 1, 1, StreamImageDCReader.class);
            AbstractDataChannel.registerHandler(1, 2, 1, StreamAsciiDCReader.class);
            AbstractDataChannel.registerHandler(1, 1, 2, StreamImageDCWriter.class);
            AbstractDataChannel.registerHandler(1, 2, 2, StreamAsciiDCWriter.class);
            AbstractDataChannel.registerHandler(3, 1, 1, EBlockImageDCReader.class);
            AbstractDataChannel.registerHandler(3, 1, 2, EBlockImageDCWriter.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to install default data channel handlers: " + e.getMessage());
        }
    }
}

