/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import java.net.Socket;
import org.globus.common.ChainedIOException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.io.gass.client.GassException;
import org.globus.io.streams.HTTPInputStream;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GassInputStream
extends HTTPInputStream {
    private GSSCredential cred;
    private Authorization auth;

    public GassInputStream(String host, int port, String file) throws GassException, GSSException, IOException {
        this(null, (Authorization)SelfAuthorization.getInstance(), host, port, file);
    }

    public GassInputStream(GSSCredential cred, Authorization auth, String host, int port, String file) throws GassException, GSSException, IOException {
        this.cred = cred;
        this.auth = auth;
        this.get(host, port, file);
    }

    protected Socket openSocket(String host, int port) throws IOException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = null;
        try {
            context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, this.cred, 0);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
        }
        catch (GSSException e) {
            throw new ChainedIOException("Security error", (Throwable)e);
        }
        GssSocketFactory factory = GssSocketFactory.getDefault();
        this.socket = factory.createSocket(host, port, (GSSContext)context);
        ((GssSocket)this.socket).setAuthorization(this.auth);
        return this.socket;
    }
}

