/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.globus.gsi.tomcat.GlobusSSLInputStream;

public class GlobusSSLSocket
extends SSLSocket {
    private SSLSocket socket;

    public GlobusSSLSocket(SSLSocket socket) {
        this.socket = socket;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.addHandshakeCompletedListener(listener);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.socket.bind(bindpoint);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.socket.connect(endpoint, timeout);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.socket.connect(endpoint);
    }

    public boolean equals(Object obj) {
        return this.socket.equals(obj);
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return new GlobusSSLInputStream(this.socket.getInputStream(), this.socket);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public SSLSession getSession() {
        return this.socket.getSession();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public SSLParameters getSSLParameters() {
        return this.socket.getSSLParameters();
    }

    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    public int hashCode() {
        return this.socket.hashCode();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.removeHandshakeCompletedListener(listener);
    }

    public void sendUrgentData(int data) throws IOException {
        this.socket.sendUrgentData(data);
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.socket.setEnabledCipherSuites(suites);
    }

    public void setEnabledProtocols(String[] protocols) {
        this.socket.setEnabledProtocols(protocols);
    }

    public void setEnableSessionCreation(boolean flag) {
        this.socket.setEnableSessionCreation(flag);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setNeedClientAuth(boolean need) {
        this.socket.setNeedClientAuth(need);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setSSLParameters(SSLParameters params) {
        this.socket.setSSLParameters(params);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public void setUseClientMode(boolean mode) {
        this.socket.setUseClientMode(mode);
    }

    public void setWantClientAuth(boolean want) {
        this.socket.setWantClientAuth(want);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public void startHandshake() throws IOException {
        this.socket.startHandshake();
    }
}

