/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.tomcat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.jsse.GlobusSSLHelper;
import org.globus.gsi.provider.GlobusProvider;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.tomcat.GlobusSSLSocketWrapper;
import org.globus.gsi.trustmanager.PKITrustManager;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;

public class GlobusSSLSocketFactory
extends JSSESocketFactory {
    protected TrustManager[] getTrustManagers(String keystoreType, String keystoreProvider, String algorithm) throws Exception {
        Object rejectLimitedProxyEntry;
        KeyStore trustStore = this.getTrustStore(keystoreType, keystoreProvider);
        CertStore crlStore = null;
        Object crlLocation = this.attributes.get("crlLocation");
        if (crlLocation != null) {
            crlStore = GlobusSSLHelper.findCRLStore((String)((String)this.attributes.get("crlLocation")));
        }
        Object signingPolicyLocation = this.attributes.get("signingPolicyLocation");
        ResourceSigningPolicyStore policyStore = null;
        if (signingPolicyLocation != null) {
            policyStore = new ResourceSigningPolicyStore((SigningPolicyStoreParameters)new ResourceSigningPolicyStoreParameters(this.attributes.get("signingPolicyLocation").toString()));
        }
        boolean rejectLimitedProxy = (rejectLimitedProxyEntry = this.attributes.get("rejectLimitedProxy")) != null && Boolean.parseBoolean(this.attributes.get("rejectLimitedProxy").toString());
        X509ProxyCertPathParameters parameters = new X509ProxyCertPathParameters(trustStore, crlStore, (SigningPolicyStore)policyStore, rejectLimitedProxy);
        PKITrustManager trustManager = new PKITrustManager((CertPathValidatorSpi)new X509ProxyCertPathValidator(), parameters);
        return new TrustManager[]{trustManager};
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return new GlobusSSLSocketWrapper((SSLServerSocket)super.createSocket(port, backlog, ifAddress));
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        return this.createSocket(port, backlog, null);
    }

    public ServerSocket createSocket(int port) throws IOException {
        return this.createSocket(port, 50);
    }

    static {
        Security.addProvider((Provider)new GlobusProvider());
    }
}

