/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.globus.gsi.util.FileUtil;
import org.globus.gsi.util.PEMUtil;

public abstract class OpenSSLKey
implements Serializable {
    private static final String HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private String keyAlg;
    private boolean isEncrypted;
    private byte[] encodedKey;
    private PrivateKey intKey;
    private byte[] ivData;
    private transient IvParameterSpec initializationVector;
    private String encAlgStr;
    private String encAlg;
    private int keyLength = -1;
    private int ivLength = -1;
    private byte[] keyData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSLKey(InputStream is) throws IOException, GeneralSecurityException {
        InputStreamReader isr = new InputStreamReader(is);
        try {
            this.readPEM(isr);
        }
        finally {
            isr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSLKey(String file) throws IOException, GeneralSecurityException {
        FileReader f = new FileReader(file);
        try {
            this.readPEM(f);
        }
        finally {
            f.close();
        }
    }

    public OpenSSLKey(PrivateKey key) {
        this.intKey = key;
        this.isEncrypted = false;
        this.keyData = this.getEncoded(key);
        this.encodedKey = null;
    }

    public OpenSSLKey(String algorithm, byte[] data) throws GeneralSecurityException {
        if (data == null) {
            throw new IllegalArgumentException("Data is null");
        }
        this.keyData = new byte[data.length];
        System.arraycopy(data, 0, this.keyData, 0, data.length);
        this.isEncrypted = false;
        this.intKey = this.getKey(algorithm, data);
    }

    protected byte[] getEncoded() {
        return this.keyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPEM(Reader rd) throws IOException, GeneralSecurityException {
        StringBuilder builder = new StringBuilder();
        BufferedReader in = new BufferedReader(rd);
        try {
            this.parseKeyAlgorithm(in);
            builder.append(this.extractEncryptionInfo(in));
            builder.append(this.extractKey(in));
        }
        finally {
            in.close();
        }
        this.encodedKey = builder.toString().getBytes();
        if (this.isEncrypted()) {
            this.keyData = null;
        } else {
            this.keyData = Base64.decode((byte[])this.encodedKey);
            this.intKey = this.getKey(this.keyAlg, this.keyData);
        }
    }

    private String extractKey(BufferedReader in) throws IOException {
        StringBuilder builder = new StringBuilder();
        String next = in.readLine();
        while (next != null && !next.startsWith("-----END")) {
            builder.append(next);
            next = in.readLine();
        }
        return builder.toString();
    }

    private String extractEncryptionInfo(BufferedReader in) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        String next = in.readLine();
        if (next != null && next.startsWith("Proc-Type: 4,ENCRYPTED")) {
            this.isEncrypted = true;
            next = in.readLine();
            if (next != null) {
                this.parseEncryptionInfo(next);
            }
            in.readLine();
        } else {
            this.isEncrypted = false;
            sb.append(next);
        }
        return sb.toString();
    }

    private void parseKeyAlgorithm(BufferedReader in) throws IOException, InvalidKeyException {
        String next = in.readLine();
        while (next != null) {
            if (next.indexOf("PRIVATE KEY") != -1) {
                this.keyAlg = this.getKeyAlgorithm(next);
                break;
            }
            next = in.readLine();
        }
        if (next == null) {
            throw new InvalidKeyException("noPrivateKey");
        }
        if (this.keyAlg == null) {
            throw new InvalidKeyException("algNotSup");
        }
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void decrypt(String password) throws GeneralSecurityException {
        this.decrypt(password.getBytes());
    }

    public void decrypt(byte[] password) throws GeneralSecurityException {
        if (!this.isEncrypted()) {
            return;
        }
        byte[] enc = Base64.decode((byte[])this.encodedKey);
        SecretKeySpec key = this.getSecretKey(password, this.initializationVector.getIV());
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)key, this.initializationVector);
        enc = cipher.doFinal(enc);
        this.intKey = this.getKey(this.keyAlg, enc);
        this.keyData = enc;
        this.isEncrypted = false;
        this.encodedKey = null;
    }

    public void encrypt(String password) throws GeneralSecurityException {
        this.encrypt(password.getBytes());
    }

    public void encrypt(byte[] password) throws GeneralSecurityException {
        if (this.isEncrypted()) {
            return;
        }
        if (this.encAlg == null) {
            this.setEncryptionAlgorithm("DES-EDE3-CBC");
        }
        if (this.ivData == null) {
            this.generateIV();
        }
        SecretKeySpec key = this.getSecretKey(password, this.initializationVector.getIV());
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)key, this.initializationVector);
        this.keyData = cipher.doFinal(this.getEncoded(this.intKey));
        this.isEncrypted = true;
        this.encodedKey = null;
    }

    public void setEncryptionAlgorithm(String alg) throws GeneralSecurityException {
        this.setAlgorithmSettings(alg);
    }

    public PrivateKey getPrivateKey() {
        return this.intKey;
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.toPEM().getBytes());
    }

    public void writeTo(Writer w) throws IOException {
        w.write(this.toPEM());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(String file) throws IOException {
        File privateKey = FileUtil.createFile(file);
        try {
            privateKey.setReadable(false, true);
            privateKey.setWritable(false, true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        PrintWriter p = new PrintWriter(new FileOutputStream(privateKey));
        try {
            p.write(this.toPEM());
        }
        finally {
            p.close();
        }
    }

    protected abstract byte[] getEncoded(PrivateKey var1);

    protected abstract PrivateKey getKey(String var1, byte[] var2) throws GeneralSecurityException;

    protected String getProvider() {
        return null;
    }

    private Cipher getCipher() throws GeneralSecurityException {
        String provider = this.getProvider();
        if (provider == null) {
            return Cipher.getInstance(this.encAlg + "/CBC/PKCS5Padding");
        }
        return Cipher.getInstance(this.encAlg + "/CBC/PKCS5Padding", provider);
    }

    private String getKeyAlgorithm(String line) {
        if (line.contains("RSA")) {
            return "RSA";
        }
        if (line.contains("DSA")) {
            return "DSA";
        }
        return null;
    }

    private void parseEncryptionInfo(String line) throws GeneralSecurityException {
        String keyInfo = line.substring(10);
        StringTokenizer tknz = new StringTokenizer(keyInfo, ",", false);
        this.setAlgorithmSettings(tknz.nextToken());
        this.setIV(tknz.nextToken());
    }

    private void setAlgorithmSettings(String alg) throws GeneralSecurityException {
        if (alg.equals("DES-EDE3-CBC")) {
            this.encAlg = "DESede";
            this.keyLength = 24;
            this.ivLength = 8;
        } else if (alg.equals("AES-128-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 16;
            this.ivLength = 16;
        } else if (alg.equals("AES-192-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 24;
            this.ivLength = 16;
        } else if (alg.equals("AES-256-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 32;
            this.ivLength = 16;
        } else if (alg.equals("DES-CBC")) {
            this.encAlg = "DES";
            this.keyLength = 8;
            this.ivLength = 8;
        } else {
            throw new GeneralSecurityException("unsupported Enc algorithm " + alg);
        }
        this.encAlgStr = alg;
    }

    private void setIV(String s) throws GeneralSecurityException {
        int len = s.length() / 2;
        if (len != this.ivLength) {
            String err = "ivLength";
            throw new GeneralSecurityException(err);
        }
        byte[] ivBytes = new byte[len];
        for (int j = 0; j < len; ++j) {
            ivBytes[j] = (byte)Integer.parseInt(s.substring(j * 2, j * 2 + 2), 16);
        }
        this.setIV(ivBytes);
    }

    private void generateIV() {
        byte[] b = new byte[this.ivLength];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        this.setIV(b);
    }

    private void setIV(byte[] data) {
        this.ivData = data;
        this.initializationVector = new IvParameterSpec(data);
    }

    private SecretKeySpec getSecretKey(byte[] pwd, byte[] keyInitializationVector) throws GeneralSecurityException {
        byte[] key = new byte[this.keyLength];
        int offset = 0;
        int bytesNeeded = this.keyLength;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while (true) {
            md5.update(pwd);
            md5.update(keyInitializationVector, 0, 8);
            byte[] b = md5.digest();
            int len = bytesNeeded > b.length ? b.length : bytesNeeded;
            System.arraycopy(b, 0, key, offset, len);
            bytesNeeded = key.length - (offset += len);
            if (bytesNeeded == 0) break;
            md5.reset();
            md5.update(b);
        }
        return new SecretKeySpec(key, this.encAlg);
    }

    private String toPEM() {
        byte[] data = this.keyData == null ? this.encodedKey : Base64.encode((byte[])this.keyData);
        String header = HEADER;
        if (this.isEncrypted()) {
            StringBuffer buf = new StringBuffer(header);
            buf.append(PEMUtil.LINE_SEP);
            buf.append("Proc-Type: 4,ENCRYPTED");
            buf.append(PEMUtil.LINE_SEP);
            buf.append("DEK-Info: ").append(this.encAlgStr);
            buf.append(",").append(PEMUtil.toHex(this.initializationVector.getIV()));
            buf.append(PEMUtil.LINE_SEP);
            header = buf.toString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PEMUtil.writeBase64(out, header, data, "-----END RSA PRIVATE KEY-----");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error", e);
        }
        return new String(out.toByteArray());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.ivData != null) {
            this.initializationVector = new IvParameterSpec(this.ivData);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenSSLKey)) {
            return false;
        }
        OpenSSLKey otherKey = (OpenSSLKey)other;
        return this.isEncrypted == otherKey.isEncrypted && Objects.equals(this.keyAlg, otherKey.keyAlg) && Arrays.areEqual((byte[])this.encodedKey, (byte[])otherKey.encodedKey) && Objects.equals(this.intKey, otherKey.intKey) && Arrays.areEqual((byte[])this.ivData, (byte[])otherKey.ivData) && Objects.equals(this.encAlgStr, otherKey.encAlgStr) && Objects.equals(this.encAlg, otherKey.encAlg) && Arrays.areEqual((byte[])this.keyData, (byte[])otherKey.keyData);
    }

    public int hashCode() {
        return this.isEncrypted ^ (this.keyAlg == null ? 0 : this.keyAlg.hashCode()) ^ (this.encodedKey == null ? 0 : this.encodedKey.hashCode()) ^ (this.intKey == null ? 0 : this.intKey.hashCode()) ^ (this.ivData == null ? 0 : this.ivData.hashCode()) ^ (this.encAlgStr == null ? 0 : this.encAlgStr.hashCode()) ^ (this.encAlg == null ? 0 : this.encAlg.hashCode()) ^ (this.keyData == null ? 0 : this.keyData.hashCode());
    }
}

