/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.SigningPolicyException;
import org.globus.gsi.util.CertificateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningPolicyParser {
    public static final String ACCESS_ID_PREFIX = "access_id_";
    public static final String ACCESS_ID_CA = "access_id_CA";
    public static final String DEF_AUTH_X509 = "X509";
    public static final String DEF_AUTH_GLOBUS = "globus";
    public static final String POS_RIGHTS = "pos_rights";
    public static final String NEG_RIGHTS = "neg_rights";
    public static final String CONDITION_PREFIX = "cond_";
    public static final String CONDITION_SUBJECT = "cond_subjects";
    public static final String VALUE_CA_SIGN = "CA:sign";
    public static final String SINGLE_CHAR = "?";
    public static final String WILDCARD = "*";
    public static final String SINGLE_PATTERN = "[\\p{Print}\\p{Blank}]";
    public static final String WILDCARD_PATTERN = "[\\p{Print}\\p{Blank}]*";
    private static final int MIN_TOKENS_PER_LINE = 3;
    static final String[] ALLOWED_LINE_START = new String[]{"access_id_", "pos_rights", "neg_rights", "cond_"};
    private Log logger = LogFactory.getLog((String)SigningPolicyParser.class.getName());

    public Map<X500Principal, SigningPolicy> parse(String fileName) throws FileNotFoundException, SigningPolicyException {
        if (fileName == null || fileName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.logger.debug((Object)("Signing policy file name " + fileName));
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(fileName);
            Map<X500Principal, SigningPolicy> map = this.parse(fileReader);
            return map;
        }
        catch (Exception e) {
            throw new SigningPolicyException(e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exp) {
                    this.logger.debug((Object)"Error closing file reader", (Throwable)exp);
                }
            }
        }
    }

    public Map<X500Principal, SigningPolicy> parse(Reader reader) throws SigningPolicyException {
        HashMap<X500Principal, SigningPolicy> policies = new HashMap<X500Principal, SigningPolicy>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!this.isValidLine(line = line.trim())) continue;
                this.logger.debug((Object)("Line to parse: " + line));
                String caDN = null;
                if (!line.startsWith(ACCESS_ID_PREFIX)) continue;
                this.logger.debug((Object)("Check if it is CA and get the DN " + line));
                caDN = this.getCaDN(line, caDN);
                boolean usefulEntry = true;
                Boolean posNegRights = null;
                this.checkRights(policies, bufferedReader, caDN, usefulEntry, posNegRights);
            }
        }
        catch (IOException exp) {
            throw new SigningPolicyException("", exp);
        }
        finally {
            this.cleanupReaders(reader, bufferedReader);
        }
        return policies;
    }

    private void checkRights(Map<X500Principal, SigningPolicy> policies, BufferedReader bufferedReader, String caDN, boolean usefulEntry, Boolean posNegRights) throws IOException, SigningPolicyException {
        boolean tmpUsefulEntry = usefulEntry;
        Boolean tmpPosNegRights = posNegRights;
        String line = bufferedReader.readLine();
        while (line != null) {
            if (!this.isValidLine(line)) {
                line = bufferedReader.readLine();
                continue;
            }
            line = line.trim();
            this.logger.debug((Object)("Line is " + line));
            if (line.startsWith(POS_RIGHTS)) {
                this.validatePositiveRights(tmpPosNegRights);
                if (tmpUsefulEntry) {
                    tmpUsefulEntry = this.isUsefulEntry(line);
                }
                tmpPosNegRights = Boolean.TRUE;
            } else if (line.startsWith(NEG_RIGHTS)) {
                tmpPosNegRights = this.handleNegativeRights(tmpPosNegRights);
            } else if (line.startsWith(CONDITION_PREFIX)) {
                if (this.handleConditionalLine(policies, line, caDN, tmpUsefulEntry, tmpPosNegRights)) {
                    break;
                }
            } else {
                String err = "invalidLine";
                throw new SigningPolicyException(err + line);
            }
            line = bufferedReader.readLine();
        }
    }

    private boolean handleConditionalLine(Map<X500Principal, SigningPolicy> policies, String line, String caDN, boolean usefulEntry, Boolean posNegRights) throws SigningPolicyException {
        if (!Boolean.TRUE.equals(posNegRights)) {
            String err = "invalidRestrictions";
            throw new SigningPolicyException(err);
        }
        if (usefulEntry && line.startsWith(CONDITION_SUBJECT)) {
            this.logger.debug((Object)"Read in subject condition.");
            int startIndex = CONDITION_SUBJECT.length();
            int endIndex = line.length();
            Vector<Pattern> allowedDNs = this.getAllowedDNs(line.substring(startIndex, endIndex));
            try {
                X500Principal caPrincipal = CertificateUtil.toPrincipal(caDN);
                SigningPolicy policy = new SigningPolicy(caPrincipal, allowedDNs);
                policies.put(caPrincipal, policy);
            }
            catch (IllegalArgumentException e) {
                if (caDN == null) {
                    throw e;
                }
                String[] components = caDN.split("/");
                boolean hasE = false;
                for (int i = 0; i < components.length; ++i) {
                    String attribute = components[i].split("=")[0];
                    if (!attribute.equals("E")) continue;
                    hasE = true;
                    break;
                }
                if (hasE) {
                    this.logger.warn((Object)("Invalid DN (" + caDN + ") in the CA policy"));
                    this.logger.debug((Object)"Invalid DN in the CA policy", (Throwable)e);
                    return true;
                }
                throw e;
            }
            return true;
        }
        return false;
    }

    private String getCaDN(String line, String caDN) throws SigningPolicyException {
        String outCaDN = caDN;
        if (line.startsWith(ACCESS_ID_CA)) {
            outCaDN = this.getCA(line.substring(ACCESS_ID_CA.length(), line.length()));
            this.logger.debug((Object)("CA DN is " + caDN));
        }
        return outCaDN;
    }

    private void validatePositiveRights(Boolean posNegRights) throws SigningPolicyException {
        if (Boolean.FALSE.equals(posNegRights)) {
            String err = "invalidPosRights";
            throw new SigningPolicyException(err);
        }
    }

    private boolean isUsefulEntry(String line) throws SigningPolicyException {
        this.logger.debug((Object)"Parse pos_rights here");
        int startIndex = POS_RIGHTS.length();
        int endIndex = line.length();
        boolean usefulEntry = this.isCASignRight(line.substring(startIndex, endIndex));
        return usefulEntry;
    }

    private Boolean handleNegativeRights(Boolean posNegRights) throws SigningPolicyException {
        if (Boolean.TRUE.equals(posNegRights)) {
            String err = "invalidNegRights";
            throw new SigningPolicyException(err);
        }
        this.logger.debug((Object)"Ignore neg_rights");
        return Boolean.FALSE;
    }

    private void cleanupReaders(Reader reader, BufferedReader bufferedReader) {
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exp) {
                this.logger.debug((Object)"Unable to close bufferedReader", (Throwable)exp);
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                this.logger.debug((Object)"Unable to close reader", (Throwable)e);
            }
        }
    }

    private boolean isValidLine(String line) throws SigningPolicyException {
        String trimmedLine = line.trim();
        if (trimmedLine.equals("") || trimmedLine.startsWith("#")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(trimmedLine);
        if (tokenizer.countTokens() < 3) {
            String err = "invalidTokens";
            throw new SigningPolicyException(err + " on line \"" + trimmedLine + "\"");
        }
        for (String allowedLineStart : ALLOWED_LINE_START) {
            if (!trimmedLine.startsWith(allowedLineStart)) continue;
            return true;
        }
        throw new SigningPolicyException("Line starts incorrectly");
    }

    private Vector<Pattern> getAllowedDNs(String line) throws SigningPolicyException {
        String trimmedLine = line.trim();
        int index = this.findIndex(trimmedLine);
        if (index == -1) {
            String err = "invalid tokens";
            throw new SigningPolicyException(err);
        }
        String defAuth = trimmedLine.substring(0, index);
        if (DEF_AUTH_GLOBUS.equals(defAuth)) {
            String value = trimmedLine.substring(index + 1, trimmedLine.length());
            value = value.trim();
            int startIndex = 0;
            int endIndex = value.length();
            if (value.charAt(startIndex) == '\'') {
                int endOfDNIndex;
                if ((endOfDNIndex = value.indexOf(39, ++startIndex)) == -1) {
                    String err = "invlaid subjects";
                    throw new SigningPolicyException(err);
                }
                endIndex = endOfDNIndex;
            }
            value = value.substring(startIndex, endIndex);
            if ((value = value.trim()).equals("")) {
                String err = "empty subjects";
                throw new SigningPolicyException(err);
            }
            Vector<Pattern> vector = new Vector<Pattern>();
            startIndex = 0;
            endIndex = value.length();
            if (value.indexOf("\"") == -1) {
                vector.add(SigningPolicyParser.getPattern(value));
            } else {
                while (startIndex < endIndex) {
                    int quot1 = value.indexOf("\"", startIndex);
                    int quot2 = value.indexOf("\"", quot1 + 1);
                    if (quot2 == -1) {
                        String err = "unmatched quotes";
                        throw new SigningPolicyException(err);
                    }
                    String token = value.substring(quot1 + 1, quot2);
                    vector.add(SigningPolicyParser.getPattern(token));
                    startIndex = quot2 + 1;
                }
            }
            return vector;
        }
        return null;
    }

    private boolean isCASignRight(String line) throws SigningPolicyException {
        String trimmedLine = line.trim();
        int index = this.findIndex(trimmedLine);
        if (index == -1) {
            String err = "invalid tokens";
            throw new SigningPolicyException(err);
        }
        String defAuth = trimmedLine.substring(0, index);
        if (DEF_AUTH_GLOBUS.equals(defAuth)) {
            trimmedLine = trimmedLine.substring(index + 1, trimmedLine.length());
            String value = (trimmedLine = trimmedLine.trim()).substring(0, trimmedLine.length());
            if (VALUE_CA_SIGN.equals(value)) {
                return true;
            }
        }
        return false;
    }

    private String getCA(String inputLine) throws SigningPolicyException {
        String line = inputLine.trim();
        int index = this.findIndex(line);
        if (index == -1) {
            String err = "invalid tokens";
            throw new SigningPolicyException(err);
        }
        String defAuth = line.substring(0, index);
        if (DEF_AUTH_X509.equals(defAuth)) {
            String caDN;
            int caDNLocation;
            line = line.substring(index + 1, line.length());
            if ((line = line.trim()).charAt(caDNLocation = 0) == '\'') {
                int endofDNIndex;
                if ((endofDNIndex = line.indexOf(39, ++caDNLocation + 1)) == -1) {
                    String err = "invalid ca dn";
                    throw new SigningPolicyException(err);
                }
                caDN = line.substring(caDNLocation, endofDNIndex);
            } else {
                caDN = line.substring(caDNLocation, line.length() - 1);
            }
            caDN = caDN.trim();
            return caDN;
        }
        return null;
    }

    public static Pattern getPattern(String patternStr) {
        if (patternStr == null) {
            throw new IllegalArgumentException();
        }
        int startIndex = 0;
        int endIndex = patternStr.length();
        StringBuffer buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            String preStr;
            int star = patternStr.indexOf(WILDCARD, startIndex);
            if (star == -1) {
                star = endIndex;
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr);
            } else {
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr).append(WILDCARD_PATTERN);
            }
            startIndex = star + 1;
        }
        String tmpPatternStr = buffer.toString();
        startIndex = 0;
        endIndex = tmpPatternStr.length();
        buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            String preStr;
            int qMark = tmpPatternStr.indexOf(SINGLE_CHAR, startIndex);
            if (qMark == -1) {
                qMark = endIndex;
                preStr = tmpPatternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr);
            } else {
                preStr = tmpPatternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr).append(SINGLE_PATTERN);
            }
            startIndex = qMark + 1;
        }
        tmpPatternStr = buffer.toString();
        LogFactory.getLog((String)SigningPolicyParser.class.getCanonicalName()).debug((Object)("String with replaced pattern is " + tmpPatternStr));
        return Pattern.compile(tmpPatternStr, 2);
    }

    private int findIndex(String line) {
        int index = -1;
        if (line == null) {
            return index;
        }
        String trimmedLine = line.trim();
        int spaceIndex = trimmedLine.indexOf(" ");
        int tabIndex = trimmedLine.indexOf("\t");
        index = spaceIndex != -1 ? (tabIndex != -1 ? (spaceIndex < tabIndex ? spaceIndex : tabIndex) : spaceIndex) : tabIndex;
        return index;
    }
}

