/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreException;
import org.globus.gsi.provider.SigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicy;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.util.GlobusPathMatchingResourcePatternResolver;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSigningPolicyStore
implements SigningPolicyStore {
    private GlobusPathMatchingResourcePatternResolver globusResolver = new GlobusPathMatchingResourcePatternResolver();
    private Map<URI, ResourceSigningPolicy> signingPolicyFileMap = new HashMap<URI, ResourceSigningPolicy>();
    private Map<String, SigningPolicy> policyMap = new HashMap<String, SigningPolicy>();
    private ResourceSigningPolicyStoreParameters parameters;
    private Log logger = LogFactory.getLog((String)ResourceSigningPolicyStore.class.getCanonicalName());
    private final Map<String, Long> invalidPoliciesCache = new HashMap<String, Long>();
    private final Map<String, Long> validPoliciesCache = new HashMap<String, Long>();
    private static final long CACHE_TIME_MILLIS = 3600000L;
    private long lastUpdate = 0L;

    public ResourceSigningPolicyStore(SigningPolicyStoreParameters param) throws InvalidAlgorithmParameterException {
        if (param == null) {
            throw new IllegalArgumentException();
        }
        if (!(param instanceof ResourceSigningPolicyStoreParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.parameters = (ResourceSigningPolicyStoreParameters)param;
    }

    @Override
    public synchronized SigningPolicy getSigningPolicy(X500Principal caPrincipal) throws SigningPolicyStoreException {
        if (caPrincipal == null) {
            return null;
        }
        String name = caPrincipal.getName();
        long now = System.currentTimeMillis();
        String hash = CertificateIOUtil.nameHash(caPrincipal);
        Long validCacheTime = this.validPoliciesCache.get(hash);
        Long invalidCacheTime = this.invalidPoliciesCache.get(hash);
        if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) {
            return null;
        }
        if (validCacheTime == null || now - validCacheTime >= 3600000L || !this.policyMap.containsKey(name)) {
            this.loadPolicy(hash);
        }
        return this.policyMap.get(name);
    }

    private synchronized void loadPolicy(String hash) throws SigningPolicyStoreException {
        Long invalidCacheTime;
        String filename;
        String locations = this.parameters.getTrustRootLocations();
        GlobusResource[] resources = this.globusResolver.getResources(locations);
        long now = System.currentTimeMillis();
        boolean found_policy = false;
        for (GlobusResource resource : resources) {
            filename = resource.getFilename();
            invalidCacheTime = this.invalidPoliciesCache.get(filename);
            if (invalidCacheTime != null && now - invalidCacheTime < 36000000L || !filename.startsWith(hash)) continue;
            if (!resource.isReadable()) {
                this.logger.debug((Object)("Cannot read: " + resource.getFilename()));
                continue;
            }
            try {
                this.loadSigningPolicy(resource, this.policyMap, this.signingPolicyFileMap);
            }
            catch (Exception e) {
                invalidCacheTime = this.invalidPoliciesCache.get(filename);
                if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) continue;
                this.logger.warn((Object)("Failed to load signing policy: " + filename));
                this.logger.debug((Object)("Failed to load signing policy: " + filename), (Throwable)e);
                this.invalidPoliciesCache.put(filename, now);
                this.invalidPoliciesCache.put(hash, now);
                continue;
            }
            found_policy = true;
        }
        if (found_policy) {
            if (!this.validPoliciesCache.containsKey(hash)) {
                this.invalidPoliciesCache.put(hash, now);
            }
            return;
        }
        for (GlobusResource resource : resources) {
            filename = resource.getFilename();
            invalidCacheTime = this.invalidPoliciesCache.get(filename);
            if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) continue;
            try {
                this.loadSigningPolicy(resource, this.policyMap, this.signingPolicyFileMap);
            }
            catch (Exception e) {
                invalidCacheTime = this.invalidPoliciesCache.get(filename);
                if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) continue;
                this.logger.warn((Object)("Failed to load signing policy: " + filename));
                this.logger.debug((Object)("Failed to load signing policy: " + filename), (Throwable)e);
                this.invalidPoliciesCache.put(filename, now);
                this.invalidPoliciesCache.put(hash, now);
            }
        }
        if (!this.validPoliciesCache.containsKey(hash)) {
            this.invalidPoliciesCache.put(hash, now);
        }
    }

    private void loadSigningPolicy(GlobusResource policyResource, Map<String, SigningPolicy> policyMapToLoad, Map<URI, ResourceSigningPolicy> currentPolicyFileMap) throws SigningPolicyStoreException {
        URI uri;
        if (!policyResource.isReadable()) {
            throw new SigningPolicyStoreException("Cannot read file");
        }
        try {
            uri = policyResource.getURI();
        }
        catch (IOException e) {
            throw new SigningPolicyStoreException(e);
        }
        ResourceSigningPolicy filePolicy = this.signingPolicyFileMap.get(uri);
        if (filePolicy == null) {
            try {
                filePolicy = new ResourceSigningPolicy(policyResource);
            }
            catch (ResourceStoreException e) {
                throw new SigningPolicyStoreException(e);
            }
        }
        Collection<SigningPolicy> policies = filePolicy.getSigningPolicies();
        currentPolicyFileMap.put(uri, filePolicy);
        if (policies != null) {
            long now = System.currentTimeMillis();
            for (SigningPolicy policy : policies) {
                X500Principal caPrincipal = policy.getCASubjectDN();
                policyMapToLoad.put(caPrincipal.getName(), policy);
                String hash = CertificateIOUtil.nameHash(caPrincipal);
                this.validPoliciesCache.put(hash, now);
            }
        }
    }
}

