/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.stores.ResourceCertStoreParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateRevocationLists {
    private static Log logger;
    private static String prevCaCertLocations;
    private static String defaultCrlLocations;
    private static CertificateRevocationLists defaultCrl;
    private volatile Map<String, X509CRL> crlIssuerDNMap;

    private CertificateRevocationLists() {
    }

    public X509CRL[] getCrls() {
        if (this.crlIssuerDNMap == null) {
            return null;
        }
        Collection<X509CRL> crls = this.crlIssuerDNMap.values();
        return crls.toArray(new X509CRL[crls.size()]);
    }

    public Collection<X509CRL> getCRLs(X509CRLSelector selector) {
        Collection<X500Principal> issuers = selector.getIssuers();
        int size = issuers.size();
        ArrayList<X509CRL> retval = new ArrayList<X509CRL>(size);
        Map<String, X509CRL> crlMap = this.crlIssuerDNMap;
        if (crlMap == null) {
            return retval;
        }
        for (X500Principal principal : issuers) {
            String dn = principal.getName();
            X509CRL crl = crlMap.get(dn);
            if (crl == null) continue;
            retval.add(crl);
        }
        return retval;
    }

    public X509CRL getCrl(String issuerName) {
        if (this.crlIssuerDNMap == null) {
            return null;
        }
        return this.crlIssuerDNMap.get(issuerName);
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        HashMap<String, X509CRL> newCrlIssuerDNMap = new HashMap<String, X509CRL>();
        while (tokens.hasMoreTokens()) {
            try {
                String location = tokens.nextToken().toString().trim();
                ResourceCertStoreParameters parameters = new ResourceCertStoreParameters(null, "file:" + location + "/*.r*");
                CertStore tmp = CertStore.getInstance("PEMFilebasedCertStore", parameters);
                Collection<? extends CRL> coll = tmp.getCRLs(new X509CRLSelector());
                for (X509CRL x509CRL : coll) {
                    newCrlIssuerDNMap.put(x509CRL.getIssuerX500Principal().getName(), x509CRL);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.crlIssuerDNMap = newCrlIssuerDNMap;
    }

    public static CertificateRevocationLists getCertificateRevocationLists(String locations) {
        CertificateRevocationLists crl = new CertificateRevocationLists();
        crl.reload(locations);
        return crl;
    }

    public static synchronized CertificateRevocationLists getDefaultCertificateRevocationLists() {
        return CertificateRevocationLists.getDefault();
    }

    public static void setDefaultCertificateRevocationList(CertificateRevocationLists crl) {
        defaultCrl = crl;
    }

    public static synchronized CertificateRevocationLists getDefault() {
        if (defaultCrl == null) {
            defaultCrl = new DefaultCertificateRevocationLists();
        }
        defaultCrl.refresh();
        return defaultCrl;
    }

    public String toString() {
        if (this.crlIssuerDNMap == null) {
            return "crl list is empty";
        }
        return this.crlIssuerDNMap.toString();
    }

    static {
        new ProviderLoader();
        logger = LogFactory.getLog((String)CertificateRevocationLists.class.getName());
        prevCaCertLocations = null;
        defaultCrlLocations = null;
        defaultCrl = null;
    }

    private static class DefaultCertificateRevocationLists
    extends CertificateRevocationLists {
        private final long lifetime = CoGProperties.getDefault().getCertCacheLifetime();
        private long lastRefresh;

        public void refresh() {
            long now = System.currentTimeMillis();
            if (this.lastRefresh + this.lifetime <= now) {
                this.reload(DefaultCertificateRevocationLists.getDefaultCRLLocations());
                this.lastRefresh = now;
            }
        }

        private static synchronized String getDefaultCRLLocations() {
            String caCertLocations = CoGProperties.getDefault().getCaCertLocations();
            if (prevCaCertLocations == null || !prevCaCertLocations.equals(caCertLocations)) {
                if (caCertLocations == null) {
                    logger.debug((Object)"No CA cert locations specified");
                    prevCaCertLocations = null;
                    defaultCrlLocations = null;
                } else {
                    StringTokenizer tokens = new StringTokenizer(caCertLocations, ",");
                    File crlFile = null;
                    LinkedList<String> crlDirs = new LinkedList<String>();
                    while (tokens.hasMoreTokens()) {
                        String crlFileName = tokens.nextToken().toString().trim();
                        crlFile = new File(crlFileName);
                        if (!crlFile.isDirectory()) {
                            if (!crlFile.isFile()) continue;
                            crlFileName = crlFile.getParent();
                        }
                        if (crlFileName == null || crlDirs.contains(crlFileName)) continue;
                        crlDirs.add(crlFileName);
                    }
                    ListIterator iterator = crlDirs.listIterator(0);
                    String locations = null;
                    while (iterator.hasNext()) {
                        if (locations == null) {
                            locations = (String)iterator.next();
                            continue;
                        }
                        locations = locations + "," + (String)iterator.next();
                    }
                    prevCaCertLocations = caCertLocations;
                    defaultCrlLocations = locations;
                }
            }
            return defaultCrlLocations;
        }
    }
}

