/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static Collection<? extends Certificate> getTrustedCertificates(KeyStore keyStore, X509CertSelector selector) throws KeyStoreException {
        Vector<X509Certificate> certificates = new Vector<X509Certificate>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            X509Certificate x509Cert = (X509Certificate)certificate;
            if (!selector.match(certificate)) continue;
            certificates.add(x509Cert);
        }
        return certificates;
    }
}

