/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.globus.util.GlobusResource;

public class GlobusPathMatchingResourcePatternResolver {
    private Pattern locationPattern = null;
    private String mainClassPath = "";
    private Vector<GlobusResource> pathsMatchingLocationPattern = new Vector();

    public GlobusResource getResource(String location) {
        GlobusResource returnResource;
        if (location.startsWith("classpath:")) {
            URL resourceURL = this.getClass().getClassLoader().getResource(location.replaceFirst("classpath:/", ""));
            returnResource = new GlobusResource(resourceURL.getPath());
        } else {
            returnResource = location.startsWith("file:") ? new GlobusResource(location.replaceFirst("file:", "")) : new GlobusResource(location);
        }
        return returnResource;
    }

    public GlobusResource[] getResources(String locationPattern) {
        String mainPath = "";
        if (locationPattern.startsWith("classpath:")) {
            String pathUntilWildcard = this.getPathUntilWildcard(locationPattern.replaceFirst("classpath:/", ""), false);
            URL resourceURL = this.getClass().getClassLoader().getResource(pathUntilWildcard);
            this.mainClassPath = resourceURL.getPath();
            this.locationPattern = Pattern.compile(this.antToRegexConverter(locationPattern.replaceFirst("classpath:/", "").replaceFirst(pathUntilWildcard, "")));
            this.parseDirectoryStructure(new File(this.mainClassPath));
        } else if (locationPattern.startsWith("file:")) {
            if (locationPattern.replaceFirst("file:", "").compareTo(this.getPathUntilWildcard(locationPattern.replaceFirst("file:", ""), true)) == 0) {
                this.pathsMatchingLocationPattern.add(new GlobusResource(locationPattern.replaceFirst("file:", "")));
            } else {
                try {
                    URL resourceURL = new File(this.getPathUntilWildcard(locationPattern.replaceFirst("file:", ""), true)).toURL();
                    mainPath = resourceURL.getPath();
                    this.locationPattern = Pattern.compile(this.antToRegexConverter(locationPattern.replaceFirst("file:", "")));
                    this.parseDirectoryStructure(new File(mainPath));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            mainPath = this.getPathUntilWildcard(locationPattern, true);
            this.locationPattern = Pattern.compile(this.antToRegexConverter(locationPattern));
            this.parseDirectoryStructure(new File(mainPath));
        }
        return this.pathsMatchingLocationPattern.toArray(new GlobusResource[0]);
    }

    private String antToRegexConverter(String antStyleLocationPattern) {
        String regexStyleLocationPattern = antStyleLocationPattern.replaceAll("\\.", "\\\\.");
        regexStyleLocationPattern = regexStyleLocationPattern.replaceAll("//", "/");
        regexStyleLocationPattern = regexStyleLocationPattern.replace('?', '.');
        regexStyleLocationPattern = regexStyleLocationPattern.replaceAll("\\*", "[^/]*");
        regexStyleLocationPattern = regexStyleLocationPattern.replaceAll("\\[\\^/\\]\\*\\[\\^/\\]\\*", ".*");
        regexStyleLocationPattern = "^" + this.mainClassPath + regexStyleLocationPattern + "$";
        return regexStyleLocationPattern;
    }

    private String getPathUntilWildcard(String locationPatternString, boolean defaultToLocaldir) {
        int questionMarkIndex;
        int locationPatternStringLength = locationPatternString.length();
        int startIndex = locationPatternString.indexOf(42);
        if (startIndex == -1) {
            startIndex = locationPatternStringLength;
        }
        if ((questionMarkIndex = locationPatternString.indexOf(63)) == -1) {
            questionMarkIndex = locationPatternStringLength;
        }
        String currentLocationPatternString = locationPatternString.substring(0, Math.min(startIndex, questionMarkIndex));
        if (defaultToLocaldir && !new File(currentLocationPatternString).canRead()) {
            currentLocationPatternString = "./";
        }
        return currentLocationPatternString;
    }

    private void parseDirectoryStructure(File currentDirectory) {
        File[] directoryContents = currentDirectory.isDirectory() ? currentDirectory.listFiles() : new File[]{currentDirectory};
        if (directoryContents != null) {
            for (File currentFile : directoryContents) {
                if (currentFile.isFile()) {
                    String absolutePath = currentFile.getAbsolutePath();
                    Matcher locationPatternMatcher = this.locationPattern.matcher(absolutePath);
                    if (!locationPatternMatcher.find()) continue;
                    this.pathsMatchingLocationPattern.add(new GlobusResource(absolutePath));
                    continue;
                }
                if (!currentFile.isDirectory()) continue;
                this.parseDirectoryStructure(currentFile);
            }
        }
    }

    private void parseFilesInDirectory(File currentDirectory) {
        File[] directoryContents = null;
        directoryContents = currentDirectory.isDirectory() ? currentDirectory.listFiles() : new File[]{currentDirectory};
        String absolutePath = null;
        Matcher locationPatternMatcher = null;
        if (directoryContents != null) {
            for (File currentFile : directoryContents) {
                if (!currentFile.isFile() || !(locationPatternMatcher = this.locationPattern.matcher(absolutePath = currentFile.getAbsolutePath())).find()) continue;
                this.pathsMatchingLocationPattern.add(new GlobusResource(absolutePath));
            }
        }
    }
}

