/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.testutils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.globus.gsi.testutils.FileSetupUtil;

public class DirSetupUtil {
    private Map<String, FileSetupUtil> map = new HashMap<String, FileSetupUtil>();
    private String[] fileNames;
    private File tempDir;

    public DirSetupUtil(String[] inputFileNames) {
        this.fileNames = inputFileNames;
    }

    public void createTempDirectory() throws IOException {
        this.tempDir = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!this.tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + this.tempDir.getAbsolutePath());
        }
        if (!this.tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + this.tempDir.getAbsolutePath());
        }
    }

    public void copy() throws Exception {
        for (String fileName : this.fileNames) {
            FileSetupUtil util = new FileSetupUtil(fileName);
            util.copyFileToTemp(this.tempDir);
            this.map.put(fileName, util);
        }
    }

    public FileSetupUtil getFileSetupUtil(String filename) {
        return this.map.get(filename);
    }

    public File getTempDirectory() {
        return this.tempDir;
    }

    public String getTempDirectoryName() {
        if (this.tempDir != null) {
            return this.tempDir.getAbsolutePath();
        }
        return null;
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
    }
}

