/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.testutils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSetupUtil {
    private String filename;
    private File tempFile;
    private Log logger = LogFactory.getLog(this.getClass());
    private static final int SLEEP_LENGTH = 1000;

    public FileSetupUtil(String inputFileName) {
        this.filename = inputFileName;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void copyFileToTemp() throws IOException {
        this.copyFileToTemp(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileToTemp(File dir) throws IOException {
        ClassLoader loader = FileSetupUtil.class.getClassLoader();
        int index = this.filename.lastIndexOf(46);
        this.tempFile = File.createTempFile("globusSecurityTest", this.filename.substring(index, this.filename.length()), dir);
        InputStream in = loader.getResourceAsStream(this.filename);
        FileWriter writer = new FileWriter(this.tempFile);
        try {
            int c = in.read();
            while (c != -1) {
                writer.write(c);
                c = in.read();
            }
        }
        finally {
            in.close();
            writer.close();
        }
    }

    public String getAbsoluteFilename() {
        return this.tempFile.getAbsolutePath();
    }

    public String getTempFilename() {
        return this.tempFile.getName();
    }

    public URL getURL() {
        URL url = null;
        try {
            url = this.tempFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.logger.info((Object)"This should not have happened", (Throwable)e);
        }
        return url;
    }

    public void deleteFile() {
        if (this.tempFile != null && !this.tempFile.delete()) {
            this.logger.info((Object)("File was not deleted: " + this.tempFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFile() throws InterruptedException, IOException {
        if (this.tempFile != null) {
            Thread.sleep(1000L);
            FileWriter writer = new FileWriter(this.tempFile, true);
            try {
                writer.write("\n");
            }
            finally {
                writer.close();
            }
        }
    }
}

