/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jibx.util.ClasspathUrlExtender;
import org.jibx.util.NameUtilities;

public class ResourceMatcher {
    private static final Logger s_logger = Logger.getLogger((String)ResourceMatcher.class.getName());

    public static List matchPaths(File basedir, URL baseurl, List paths, ReportMatch report) throws IOException {
        PatternMatcher filter = new PatternMatcher();
        ArrayList<String> errors = new ArrayList<String>();
        for (String path : paths) {
            int wildstart = path.indexOf(42);
            if (wildstart >= 0) {
                if (basedir == null) {
                    errors.add("File name pattern argument not allowed for non-file base: '" + path + '\'');
                    continue;
                }
                File dir = basedir.getCanonicalFile();
                if (File.separatorChar != '/') {
                    path = path.replace('/', File.separatorChar);
                }
                int split = path.lastIndexOf(File.separatorChar);
                String pattern = path;
                if (split >= 0) {
                    if (wildstart < split) {
                        errors.add("Wildcard can only be used for file name, not in the directory path, for pattern '" + path + '\'');
                        continue;
                    }
                    String dirpath = path.substring(0, split);
                    dir = new File(dirpath);
                    if (!dir.isAbsolute()) {
                        dir = new File(basedir, dirpath);
                    }
                    dir = dir.getCanonicalFile();
                    pattern = path.substring(split + 1);
                }
                filter.setPattern(pattern);
                s_logger.debug((Object)("Matching file names to command line pattern '" + path + '\''));
                String[] matches = dir.list(filter);
                if (matches == null || matches.length == 0) {
                    errors.add("No files found matching command line pattern '" + pattern + "' in directory " + dir.getAbsolutePath());
                    continue;
                }
                for (int i = 0; i < matches.length; ++i) {
                    String match = matches[i];
                    report.foundMatch(match, new URL(dir.toURI().toURL(), match));
                }
                continue;
            }
            if (basedir != null) {
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = new File(basedir, path);
                }
                if (file.exists()) {
                    report.foundMatch(path, file.toURI().toURL());
                    continue;
                }
            }
            URL url = ClasspathUrlExtender.buildURL(baseurl, path);
            report.foundMatch(path, url);
        }
        return errors;
    }

    private static class PatternMatcher
    implements FilenameFilter {
        private String m_pattern;

        private PatternMatcher() {
        }

        public void setPattern(String pattern) {
            this.m_pattern = pattern;
        }

        public boolean accept(File dir, String name) {
            boolean match = NameUtilities.isPatternMatch(name, this.m_pattern);
            if (match) {
                s_logger.debug((Object)(" matched file name '" + name + '\''));
            }
            return match;
        }
    }

    public static interface ReportMatch {
        public void foundMatch(String var1, URL var2);
    }
}

