/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.runtime.QName;
import org.jibx.schema.ISkipElements;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupElement;
import org.jibx.schema.elements.CommonTypeDefinition;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.GroupElement;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.validation.ProblemHandler;
import org.jibx.schema.validation.ValidationProblem;
import org.jibx.util.InsertionOrderedMap;

public class ValidationContext
extends SchemaContextTracker
implements ISkipElements {
    private static final Logger s_logger = Logger.getLogger((String)ValidationContext.class.getName());
    private Map m_idSchemaMap = new InsertionOrderedMap();
    private Map m_namespaceSchemaMap = new HashMap();
    private Set m_duplicateNamespaces = new HashSet();
    private int m_unimplementedCount;
    private int m_warningCount;
    private int m_errorCount;
    private int m_fatalCount;
    private ArrayList m_problemList = new ArrayList();
    private Set m_skipSet = new HashSet();

    public void reset() {
        this.m_idSchemaMap.clear();
        this.m_problemList.clear();
        this.m_skipSet.clear();
        this.clearTraversed();
    }

    public SchemaElement getSchemaByNamespace(String uri) {
        return (SchemaElement)this.m_namespaceSchemaMap.get(uri);
    }

    public SchemaElement getSchemaById(String id) {
        return (SchemaElement)this.m_idSchemaMap.get(id);
    }

    public Iterator iterateSchemas() {
        return this.m_idSchemaMap.values().iterator();
    }

    public void setSchema(String id, SchemaElement schema) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Setting schema with id=" + id));
        }
        this.m_idSchemaMap.put(id, schema);
        String tns = schema.getTargetNamespace();
        if (tns != null) {
            if (this.m_namespaceSchemaMap.containsKey(tns)) {
                this.m_namespaceSchemaMap.remove(tns);
                this.m_duplicateNamespaces.add(tns);
            }
            if (!this.m_duplicateNamespaces.contains(tns)) {
                this.m_namespaceSchemaMap.put(tns, schema);
            }
        }
    }

    public int getSchemaCount() {
        return this.m_idSchemaMap.size();
    }

    public int getUnimplementedCount() {
        return this.m_unimplementedCount;
    }

    public int getWarningCount() {
        return this.m_warningCount;
    }

    public int getErrorCount() {
        return this.m_errorCount;
    }

    public int getFatalCount() {
        return this.m_fatalCount;
    }

    public void registerAttribute(QName qname, AttributeElement def) {
        AttributeElement dupl = this.m_nameRegister.registerAttribute(qname, def);
        if (dupl != null) {
            this.addError("Duplicate name " + qname, def);
        }
    }

    public void registerAttributeGroup(QName qname, AttributeGroupElement def) {
        AttributeGroupElement dupl = this.m_nameRegister.registerAttributeGroup(qname, def);
        if (dupl != null) {
            this.addError("Duplicate name " + qname, def);
        }
    }

    public void registerElement(QName qname, ElementElement def) {
        ElementElement dupl = this.m_nameRegister.registerElement(qname, def);
        if (dupl != null) {
            this.addError("Duplicate name " + qname, def);
        }
    }

    public void registerGroup(QName qname, GroupElement def) {
        GroupElement dupl = this.m_nameRegister.registerGroup(qname, def);
        if (dupl != null) {
            this.addError("Duplicate name " + qname, def);
        }
    }

    public void registerType(QName qname, CommonTypeDefinition def) {
        CommonTypeDefinition dupl = this.m_nameRegister.registerType(qname, def);
        if (dupl != null) {
            this.addError("Duplicate name " + qname, def);
        }
    }

    public AttributeElement findAttribute(QName qname) {
        return this.m_nameRegister.findAttribute(qname);
    }

    public AttributeGroupElement findAttributeGroup(QName qname) {
        return this.m_nameRegister.findAttributeGroup(qname);
    }

    public ElementElement findElement(QName qname) {
        return this.m_nameRegister.findElement(qname);
    }

    public GroupElement findGroup(QName qname) {
        return this.m_nameRegister.findGroup(qname);
    }

    public CommonTypeDefinition findType(QName qname) {
        return this.m_nameRegister.findType(qname);
    }

    public void addUnimplemented(String msg, Object obj) {
        this.addProblem(new ValidationProblem(0, msg, obj));
    }

    public void addWarning(String msg, Object obj) {
        this.addProblem(new ValidationProblem(1, msg, obj));
    }

    public boolean addError(String msg, Object obj) {
        this.addProblem(new ValidationProblem(2, msg, obj));
        return true;
    }

    public void addFatal(String msg, Object obj) {
        this.addProblem(new ValidationProblem(3, msg, obj));
    }

    public void addProblem(ValidationProblem problem) {
        this.m_problemList.add(problem);
        switch (problem.getSeverity()) {
            case 2: {
                ++this.m_errorCount;
                break;
            }
            case 3: {
                ++this.m_fatalCount;
                this.addSkip(problem.getComponent());
                break;
            }
            case 0: {
                ++this.m_unimplementedCount;
                break;
            }
            case 1: {
                ++this.m_warningCount;
            }
        }
    }

    public ArrayList getProblems() {
        return this.m_problemList;
    }

    protected void addSkip(Object skip) {
        if (skip instanceof SchemaBase) {
            this.m_skipSet.add(skip);
        }
    }

    public boolean reportProblems(ProblemHandler handler) {
        ArrayList probs = this.getProblems();
        boolean error = false;
        if (probs.size() > 0) {
            block6: for (int j = 0; j < probs.size(); ++j) {
                ValidationProblem prob = (ValidationProblem)probs.get(j);
                switch (prob.getSeverity()) {
                    case 0: {
                        handler.handleUnimplemented(prob);
                        continue block6;
                    }
                    case 1: {
                        handler.handleWarning(prob);
                        continue block6;
                    }
                    case 2: {
                        handler.handleError(prob);
                        error = true;
                        continue block6;
                    }
                    case 3: {
                        handler.handleFatal(prob);
                        error = true;
                    }
                }
            }
        }
        probs.clear();
        return error;
    }

    public boolean isSkipped(Object obj) {
        return this.m_skipSet.contains(obj);
    }
}

