/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jibx.schema.ISchemaResolver;

public class UrlResolver
implements ISchemaResolver {
    private final URL m_url;
    private final String m_name;
    private final String m_id;

    public UrlResolver(String path, URL url) {
        int offset;
        this.m_url = url;
        String file = url.getFile();
        int base = 0;
        while ((offset = file.indexOf("/./", base)) >= 0) {
            file = file.substring(0, offset) + file.substring(offset + 2);
            base = offset;
        }
        base = 1;
        while (file.length() > 1 && (offset = file.indexOf("/../", base)) >= 0) {
            int prior = file.lastIndexOf(47, offset - 1);
            if (prior > 0) {
                file = file.substring(0, prior) + file.substring(offset + 3);
                base = prior;
                continue;
            }
            base = offset + 3;
        }
        this.m_id = url.getProtocol().toLowerCase() + "://" + url.getHost().toLowerCase() + file;
        path.replace('\\', '/');
        int start = path.lastIndexOf(47);
        this.m_name = path.substring(start + 1);
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.m_url.openStream();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public ISchemaResolver resolve(String loc, String tns) throws IOException {
        return new UrlResolver(loc, new URL(this.m_url, loc));
    }

    public URL getUrl() {
        return this.m_url;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UrlResolver) {
            return this.m_id.equals(((UrlResolver)obj).m_id);
        }
        return false;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }
}

