/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.elements;

import java.util.ArrayList;
import java.util.List;
import org.jibx.runtime.QName;
import org.jibx.schema.INamed;
import org.jibx.schema.IReference;
import org.jibx.schema.elements.OpenAttrBase;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.util.LazyList;

public class SchemaPath {
    private static final StepBase WILDCARD_ELEMENT_STEP = new StepBase(){

        @Override
        public boolean isRepeating() {
            return false;
        }

        @Override
        public boolean match(OpenAttrBase elem) {
            return true;
        }

        @Override
        public int position() {
            return -1;
        }
    };
    private static final StepBase WILDCARD_NESTING_STEP = new StepBase(){

        @Override
        public boolean isRepeating() {
            return true;
        }

        @Override
        public boolean match(OpenAttrBase elem) {
            return true;
        }

        @Override
        public int position() {
            return -1;
        }
    };
    private final Object m_sourceObject;
    private final ValidationContext m_validationContext;
    private StepBase[] m_steps;

    private SchemaPath(Object obj, ValidationContext vctx) {
        this.m_sourceObject = obj;
        this.m_validationContext = vctx;
    }

    private boolean validateName(String nameattr) {
        for (int i = 0; i < nameattr.length(); ++i) {
            char chr = nameattr.charAt(i);
            if (Character.isLetter(chr) || chr == '.' || chr == '_' || chr == '-' || i > 0 && Character.isDigit(chr)) continue;
            this.m_validationContext.addError("Invalid path expression name predicate '" + nameattr + '\'', this.m_sourceObject);
            return false;
        }
        return true;
    }

    private int convertPosition(String postext) {
        for (int i = 0; i < postext.length(); ++i) {
            char chr = postext.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            if (i == 0) {
                this.m_validationContext.addError("Unknown path expression predicate '" + postext + '\'', this.m_sourceObject);
            } else {
                this.m_validationContext.addError("Illegal character in path expression position predicate '" + postext + "' (must be digits only)", this.m_sourceObject);
            }
            return -1;
        }
        int position = -1;
        try {
            position = Integer.parseInt(postext);
            if (position <= 0) {
                this.m_validationContext.addError("Path expression position predicate value must be >= 1", this.m_sourceObject);
            }
        }
        catch (NumberFormatException e) {
            this.m_validationContext.addError("Error parsing position predicate in path expression", this.m_sourceObject);
        }
        return position;
    }

    private StepBase buildPathStep(String step) {
        if ("*".equals(step)) {
            return WILDCARD_ELEMENT_STEP;
        }
        if ("**".equals(step)) {
            return WILDCARD_NESTING_STEP;
        }
        boolean valid = true;
        String elemname = null;
        String nameattr = null;
        String postext = null;
        int split = step.indexOf(91);
        if (split >= 0) {
            elemname = step.substring(0, split);
            if ((split = (step = step.substring(split + 1)).indexOf(93)) >= 0) {
                String clause = step.substring(0, split).trim();
                if (clause.startsWith("@name=")) {
                    nameattr = clause.substring(6);
                    valid = this.validateName(nameattr);
                } else {
                    postext = clause;
                }
                step = step.substring(split + 1);
                if (step.length() > 0) {
                    int end = step.length() - 1;
                    if (step.charAt(0) == '[' && step.charAt(end) == ']') {
                        clause = step.substring(1, end).trim();
                        if (postext == null) {
                            postext = clause;
                        } else {
                            this.m_validationContext.addError("Multiple predicates only allowed in path expression with [@name=xxx] as first predicate", this.m_sourceObject);
                            valid = false;
                        }
                    } else {
                        this.m_validationContext.addError("Invalid predicate in path expression", this.m_sourceObject);
                        valid = false;
                    }
                }
            } else {
                this.m_validationContext.addError("Invalid predicate in path expression", this.m_sourceObject);
                valid = false;
            }
        } else {
            elemname = step;
        }
        int position = -1;
        if (valid && postext != null) {
            position = this.convertPosition(postext);
            boolean bl = valid = position > 0;
        }
        if (valid) {
            return new PathStep(elemname, position, nameattr);
        }
        return null;
    }

    private void match(int offset, int end, OpenAttrBase base, ArrayList matches) {
        LazyList childs = base.getChildrenWritable();
        StepBase step = this.m_steps[offset];
        int steppos = step.position();
        int position = 0;
        for (int i = 0; i < childs.size(); ++i) {
            OpenAttrBase child = (OpenAttrBase)childs.get(i);
            if (!step.match(child) || steppos > 0 && steppos != ++position) continue;
            if (offset == end) {
                matches.add(child);
            } else {
                this.match(offset + 1, end, child, matches);
            }
            if (step.isRepeating()) {
                this.match(offset, end, child, matches);
            }
            if (steppos > 0) break;
        }
    }

    public int getPathLength() {
        return this.m_steps.length;
    }

    public boolean isWildStart() {
        return this.m_steps[0] == WILDCARD_ELEMENT_STEP || this.m_steps[0] == WILDCARD_NESTING_STEP;
    }

    public List partialMatchMultiple(int first, int last, OpenAttrBase base) {
        ArrayList matches = new ArrayList();
        this.match(first, last, base, matches);
        return matches;
    }

    public OpenAttrBase partialMatchUnique(int first, int last, OpenAttrBase base) {
        List matches = this.partialMatchMultiple(first, last, base);
        OpenAttrBase match = null;
        if (matches.size() == 0) {
            this.m_validationContext.addError("No match found for path expression", this.m_sourceObject);
        } else if (matches.size() > 1) {
            this.m_validationContext.addError("Multiple matches found for path expression", this.m_sourceObject);
        } else {
            match = (OpenAttrBase)matches.get(0);
        }
        return match;
    }

    public OpenAttrBase matchUnique(OpenAttrBase base) {
        return this.partialMatchUnique(0, this.m_steps.length - 1, base);
    }

    public static SchemaPath buildPath(String path, String elemname, String nameattr, String postext, Object obj, ValidationContext vctx) {
        StepBase[] steps;
        SchemaPath inst = new SchemaPath(obj, vctx);
        boolean valid = true;
        int position = -1;
        if (postext != null && (position = inst.convertPosition(postext)) < 0) {
            valid = false;
        }
        if (nameattr != null && !inst.validateName(nameattr)) {
            valid = false;
        }
        if (path == null) {
            steps = new StepBase[]{new PathStep(elemname, position, nameattr)};
        } else {
            int split;
            ArrayList<StepBase> steplist = new ArrayList<StepBase>();
            int base = 0;
            while ((split = path.indexOf(47, base)) >= 0) {
                StepBase step = inst.buildPathStep(path.substring(base, split));
                base = split + 1;
                if (step == null) {
                    valid = false;
                    continue;
                }
                steplist.add(step);
            }
            String steptext = path.substring(base);
            if ("**".equals(steptext)) {
                steplist.add(WILDCARD_NESTING_STEP);
            } else {
                StepBase step;
                if (steptext.startsWith(elemname)) {
                    steptext = steptext.substring(elemname.length());
                }
                if ((step = inst.buildPathStep(elemname + steptext)) instanceof PathStep) {
                    PathStep laststep = (PathStep)step;
                    if (!elemname.equals(laststep.m_elementName)) {
                        vctx.addError("Last path step must use no element name, or the specified element name", obj);
                        valid = false;
                    }
                    if (position <= 0) {
                        position = laststep.m_position;
                    } else if (laststep.m_position > 0 && position != laststep.m_position) {
                        vctx.addError("Position must not be used in last path step, or must match specified value", obj);
                        valid = false;
                    }
                    if (nameattr == null) {
                        nameattr = laststep.m_name;
                    } else if (laststep.m_name != null && !nameattr.equals(laststep.m_name)) {
                        vctx.addError("Name atribute must not be used in last path step, or must match specified value", obj);
                        valid = false;
                    }
                }
            }
            steplist.add(new PathStep(elemname, position, nameattr));
            steps = steplist.toArray(new StepBase[steplist.size()]);
        }
        if (valid) {
            inst.m_steps = steps;
            return inst;
        }
        return null;
    }

    public static class PathStep
    extends StepBase {
        private final String m_elementName;
        private final int m_position;
        private final String m_name;

        protected PathStep(String elemname, int position, String name) {
            this.m_elementName = elemname;
            this.m_position = position;
            this.m_name = name;
        }

        @Override
        public boolean isRepeating() {
            return false;
        }

        @Override
        public boolean match(OpenAttrBase elem) {
            if (elem.name().equals(this.m_elementName)) {
                if (this.m_name == null) {
                    return true;
                }
                if (elem instanceof INamed && this.m_name.equals(((INamed)((Object)elem)).getName())) {
                    return true;
                }
                if (elem instanceof IReference) {
                    QName ref = ((IReference)((Object)elem)).getRef();
                    return ref != null && this.m_name.equals(ref.getName());
                }
                return false;
            }
            return false;
        }

        @Override
        public int position() {
            return this.m_position;
        }
    }

    public static abstract class StepBase {
        public abstract boolean match(OpenAttrBase var1);

        public abstract boolean isRepeating();

        public abstract int position();
    }
}

