/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.apache.log4j.Logger;
import org.jibx.runtime.QName;
import org.jibx.schema.INamed;
import org.jibx.schema.IReference;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.ReferenceItem;
import org.jibx.schema.codegen.TypeData;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AttributeGroupElement;
import org.jibx.schema.elements.GroupElement;
import org.jibx.schema.elements.SchemaBase;

public class DefinitionItem
extends GroupItem {
    private static final Logger s_logger = Logger.getLogger((String)DefinitionItem.class.getName());
    private int m_referenceCount;
    private boolean m_inlineBlocked;
    private boolean m_checked;
    private boolean m_referenced;
    private boolean m_classified;
    private boolean m_typeIsomorphic;
    private QName m_qname;

    public DefinitionItem(AnnotatedBase comp) {
        super(comp, null);
    }

    DefinitionItem(GroupItem group) {
        super(group, null, null);
    }

    public int getReferenceCount() {
        return this.m_referenceCount;
    }

    public void countReference() {
        ++this.m_referenceCount;
    }

    public boolean isInlineBlocked() {
        return this.m_inlineBlocked;
    }

    public void setInlineBlocked(boolean blocked) {
        if (!blocked && this.isPregenerated()) {
            throw new IllegalStateException("Internal error - inlining forbidden for pregenerated definition");
        }
        this.m_inlineBlocked = blocked;
        if (s_logger.isInfoEnabled()) {
            s_logger.info((Object)("Setting inlining blocked " + blocked + " for " + SchemaUtils.describeComponent((SchemaBase)this.getSchemaComponent())));
        }
    }

    public boolean isChecked() {
        return this.m_checked;
    }

    public void setChecked(boolean checked) {
        this.m_checked = checked;
    }

    public boolean isReferenced() {
        return this.m_referenced;
    }

    public void setReferenced(boolean refed) {
        this.m_referenced = refed;
    }

    public boolean isTypeIsomorphic() {
        return this.m_typeIsomorphic;
    }

    public void setTypeIsomorphic(boolean iso) {
        this.m_typeIsomorphic = iso;
    }

    public boolean isPregenerated() {
        TypeData data = super.getGenerateClass();
        return data != null && data.isPregenerated();
    }

    public boolean hasDirectGenerateClass() {
        return super.getGenerateClass() != null;
    }

    @Override
    public TypeData getGenerateClass() {
        TypeData data = super.getGenerateClass();
        if (data == null) {
            if (this.isInline() || this.isTypeIsomorphic()) {
                if (this.getChildCount() == 1) {
                    Item child = this.getFirstChild();
                    if (child instanceof ReferenceItem) {
                        return ((ReferenceItem)child).getDefinition().getGenerateClass();
                    }
                    throw new IllegalStateException("Internal error - no generate class for definition with non-reference child");
                }
                throw new IllegalStateException("Internal error - no generate class for definition with multiple children");
            }
            throw new IllegalStateException("Internal error - no generate class for non-inlined definition");
        }
        return data;
    }

    public QName getQName() {
        if (this.m_qname == null) {
            AnnotatedBase comp = this.getSchemaComponent();
            QName qname = ((INamed)comp).getQName();
            if (qname == null && comp instanceof IReference) {
                qname = ((IReference)comp).getRef();
            }
            if (comp instanceof AttributeGroupElement) {
                qname = new QName(qname.getUri(), qname.getName() + "-AttributeGroup");
            } else if (comp instanceof GroupElement) {
                qname = new QName(qname.getUri(), qname.getName() + "-Group");
            }
            this.m_qname = qname;
        }
        return this.m_qname;
    }

    @Override
    public void classifyContent() {
        if (!this.m_classified) {
            this.m_classified = true;
            super.classifyContent();
        }
    }

    @Override
    protected String describe(int depth, boolean classified) {
        StringBuffer buff = new StringBuffer(depth + 50);
        buff.append(this.leadString(depth));
        if (this.isInline()) {
            buff.append("inlined ");
        }
        if (this.isEnumeration()) {
            buff.append("enumeration ");
        }
        buff.append("definition with ");
        buff.append(this.m_referenceCount);
        buff.append(" references");
        if (this.m_inlineBlocked) {
            buff.append(" (inlining blocked)");
        }
        buff.append(", and class name ");
        buff.append(this.getClassName());
        if (this.m_classified) {
            buff.append(this.isAllOptional() ? " (all items optional)" : " (not all items optional)");
        }
        buff.append(": ");
        buff.append(SchemaUtils.describeComponent((SchemaBase)this.getSchemaComponent()));
        buff.append('\n');
        buff.append(this.nestedString(depth, classified));
        return buff.toString();
    }

    protected String describe() {
        return this.describe(0, this.m_classified);
    }
}

